/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontSetFamilyInfo;
import net.sf.jasperreports.engine.fonts.FontSetInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.AdditionalEntryMap;
import net.sf.jasperreports.engine.util.CharPredicateCache;
import net.sf.jasperreports.engine.util.CharScriptsSet;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.engine.util.StyledTextListInfo;
import net.sf.jasperreports.engine.util.StyledTextListItemInfo;
import net.sf.jasperreports.engine.util.StyledTextWriteContext;

public class JRStyledTextUtil {
    private final JRStyledTextAttributeSelector allSelector;
    private final FontUtil fontUtil;
    private final boolean ignoreMissingFonts;
    private final Map<Pair<String, Locale>, FamilyFonts> familyFonts = new ConcurrentHashMap<Pair<String, Locale>, FamilyFonts>();
    private static FamilyFonts NULL_FAMILY_FONTS = new FamilyFonts(null);

    private JRStyledTextUtil(JasperReportsContext jasperReportsContext) {
        this.allSelector = JRStyledTextAttributeSelector.getAllSelector(jasperReportsContext);
        this.fontUtil = FontUtil.getInstance(jasperReportsContext);
        this.ignoreMissingFonts = JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font");
    }

    public static JRStyledTextUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new JRStyledTextUtil(jasperReportsContext);
    }

    public String getTruncatedText(JRPrintText printText) {
        String truncatedText = null;
        String originalText = printText.getOriginalText();
        if (originalText != null) {
            truncatedText = printText.getTextTruncateIndex() == null ? originalText : (!"none".equals(printText.getMarkup()) ? JRStyledTextParser.getInstance().write(printText.getFullStyledText(this.allSelector), 0, printText.getTextTruncateIndex()) : originalText.substring(0, printText.getTextTruncateIndex()));
            String textTruncateSuffix = printText.getTextTruncateSuffix();
            if (textTruncateSuffix != null) {
                truncatedText = truncatedText + textTruncateSuffix;
            }
        }
        return truncatedText;
    }

    public JRStyledText getStyledText(JRPrintText printText, JRStyledTextAttributeSelector attributeSelector) {
        String truncatedText = this.getTruncatedText(printText);
        if (truncatedText == null) {
            return null;
        }
        Locale locale = JRStyledTextAttributeSelector.getTextLocale(printText);
        JRStyledText styledText = this.getStyledText(printText, truncatedText, attributeSelector, locale);
        return styledText;
    }

    protected JRStyledText getStyledText(JRPrintText printText, String text, JRStyledTextAttributeSelector attributeSelector, Locale locale) {
        return JRStyledTextParser.getInstance().getStyledText(attributeSelector.getStyledTextAttributes(printText), text, !"none".equals(printText.getMarkup()), locale);
    }

    public JRStyledText getProcessedStyledText(JRPrintText printText, JRStyledTextAttributeSelector attributeSelector, String exporterKey) {
        String truncatedText = this.getTruncatedText(printText);
        if (truncatedText == null) {
            return null;
        }
        Locale locale = JRStyledTextAttributeSelector.getTextLocale(printText);
        JRStyledText styledText = this.getStyledText(printText, truncatedText, attributeSelector, locale);
        JRStyledText processedStyledText = this.resolveFonts(styledText, locale, exporterKey);
        return processedStyledText;
    }

    public JRStyledText resolveFonts(JRStyledText styledText, Locale locale) {
        return this.resolveFonts(styledText, locale, null);
    }

    protected JRStyledText resolveFonts(JRStyledText styledText, Locale locale, String exporterKey) {
        if (styledText == null || styledText.length() == 0) {
            return styledText;
        }
        String text = styledText.getText();
        List<JRStyledText.Run> runs = styledText.getRuns();
        ArrayList<JRStyledText.Run> newRuns = null;
        if (runs.size() == 1) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = runs.get((int)0).attributes;
            FamilyFonts families = this.getFamilyFonts(attributes, locale);
            if (families.needsToResolveFonts(exporterKey)) {
                newRuns = new ArrayList(runs.size() + 2);
                this.matchFonts(text, 0, styledText.length(), attributes, families, newRuns);
            }
        } else {
            boolean needsFontMatching = false;
            for (JRStyledText.Run run : runs) {
                FamilyFonts families = this.getFamilyFonts(run.attributes, locale);
                if (!families.needsToResolveFonts(exporterKey)) continue;
                needsFontMatching = true;
                break;
            }
            if (needsFontMatching) {
                newRuns = new ArrayList<JRStyledText.Run>(runs.size() + 2);
                AttributedCharacterIterator attributesIt = styledText.getAttributedString().getIterator();
                int index = 0;
                while (index < styledText.length()) {
                    int runEndIndex = attributesIt.getRunLimit();
                    Map<AttributedCharacterIterator.Attribute, Object> runAttributes = attributesIt.getAttributes();
                    FamilyFonts familyFonts = this.getFamilyFonts(runAttributes, locale);
                    if (familyFonts.needsToResolveFonts(exporterKey)) {
                        this.matchFonts(text, index, runEndIndex, runAttributes, familyFonts, newRuns);
                    } else {
                        this.copyRun(newRuns, runAttributes, index, runEndIndex);
                    }
                    index = runEndIndex;
                    attributesIt.setIndex(index);
                }
            }
        }
        if (newRuns == null) {
            return styledText;
        }
        JRStyledText processedText = this.createProcessedStyledText(styledText, text, newRuns);
        return processedText;
    }

    protected JRStyledText createProcessedStyledText(JRStyledText styledText, String text, List<JRStyledText.Run> newRuns) {
        Map<AttributedCharacterIterator.Attribute, Object> globalAttributes = null;
        JRStyledText processedText = new JRStyledText(styledText.getLocale(), text);
        for (JRStyledText.Run newRun : newRuns) {
            if (newRun.startIndex == 0 && newRun.endIndex == text.length() && globalAttributes == null) {
                globalAttributes = newRun.attributes;
                continue;
            }
            processedText.addRun(newRun);
        }
        processedText.setGlobalAttributes(globalAttributes == null ? styledText.getGlobalAttributes() : globalAttributes);
        return processedText;
    }

    protected void matchFonts(String text, int startIndex, int endIndex, Map<AttributedCharacterIterator.Attribute, Object> attributes, FamilyFonts familyFonts, List<JRStyledText.Run> newRuns) {
        FontMatch fontMatch;
        Number posture = (Number)attributes.get(TextAttribute.POSTURE);
        boolean italic = posture != null && !TextAttribute.POSTURE_REGULAR.equals(posture);
        Number weight = (Number)attributes.get(TextAttribute.WEIGHT);
        boolean bold = weight != null && !TextAttribute.WEIGHT_REGULAR.equals(weight);
        boolean hadUnmatched = false;
        int index = startIndex;
        do {
            fontMatch = null;
            if (bold && italic) {
                fontMatch = this.fontMatchRun(text, index, endIndex, familyFonts.boldItalicFonts);
            }
            if (bold && (fontMatch == null || fontMatch.fontInfo == null)) {
                fontMatch = this.fontMatchRun(text, index, endIndex, familyFonts.boldFonts);
            }
            if (italic && (fontMatch == null || fontMatch.fontInfo == null)) {
                fontMatch = this.fontMatchRun(text, index, endIndex, familyFonts.italicFonts);
            }
            if (fontMatch == null || fontMatch.fontInfo == null) {
                fontMatch = this.fontMatchRun(text, index, endIndex, familyFonts.normalFonts);
            }
            if (fontMatch.fontInfo != null) {
                this.addFontRun(newRuns, attributes, index, fontMatch.endIndex, fontMatch.fontInfo);
                continue;
            }
            hadUnmatched = true;
        } while ((index = fontMatch.endIndex) < endIndex);
        if (hadUnmatched) {
            this.addFallbackRun(newRuns, attributes, startIndex, endIndex, familyFonts);
        }
    }

    protected void copyRun(List<JRStyledText.Run> newRuns, Map<AttributedCharacterIterator.Attribute, Object> attributes, int startIndex, int endIndex) {
        Map<AttributedCharacterIterator.Attribute, Object> newAttributes = Collections.unmodifiableMap(attributes);
        JRStyledText.Run newRun = new JRStyledText.Run(newAttributes, startIndex, endIndex);
        newRuns.add(newRun);
    }

    protected void addFallbackRun(List<JRStyledText.Run> newRuns, Map<AttributedCharacterIterator.Attribute, Object> attributes, int startIndex, int endIndex, FamilyFonts familyFonts) {
        Map<AttributedCharacterIterator.Attribute, Object> newAttributes;
        if (familyFonts.fontSet.getPrimaryFamily() != null) {
            newAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>(attributes);
            String primaryFamilyName = familyFonts.fontSet.getPrimaryFamily().getFontFamily().getName();
            newAttributes.put(TextAttribute.FAMILY, primaryFamilyName);
        } else {
            newAttributes = Collections.unmodifiableMap(attributes);
        }
        JRStyledText.Run newRun = new JRStyledText.Run(newAttributes, startIndex, endIndex);
        newRuns.add(newRun);
    }

    protected void addFontRun(List<JRStyledText.Run> newRuns, Map<AttributedCharacterIterator.Attribute, Object> attributes, int startIndex, int endIndex, FontInfo fontInfo) {
        AdditionalEntryMap<AttributedCharacterIterator.Attribute, Object> newAttributes = new AdditionalEntryMap<AttributedCharacterIterator.Attribute, Object>(attributes, JRTextAttribute.FONT_INFO, fontInfo);
        JRStyledText.Run newRun = new JRStyledText.Run(newAttributes, startIndex, endIndex);
        newRuns.add(newRun);
    }

    protected FontMatch fontMatchRun(String text, int startIndex, int endIndex, List<Face> fonts) {
        int charIndex;
        LinkedList<Face> validFonts = new LinkedList<Face>(fonts);
        Face lastValid = null;
        int nextCharIndex = charIndex = startIndex;
        while (charIndex < endIndex) {
            int codePoint;
            int textChar = text.charAt(charIndex);
            nextCharIndex = charIndex + 1;
            if (Character.isHighSurrogate((char)textChar)) {
                char nextChar;
                if (charIndex + 1 >= endIndex || !Character.isLowSurrogate(nextChar = text.charAt(charIndex + 1))) break;
                codePoint = Character.toCodePoint((char)textChar, nextChar);
                ++nextCharIndex;
            } else {
                codePoint = textChar;
            }
            ListIterator fontIt = validFonts.listIterator();
            while (fontIt.hasNext()) {
                Face face = (Face)fontIt.next();
                if (face.supports(codePoint)) continue;
                fontIt.remove();
            }
            if (validFonts.isEmpty()) break;
            lastValid = validFonts.getFirst();
            charIndex = nextCharIndex;
        }
        FontMatch fontMatch = new FontMatch();
        fontMatch.endIndex = lastValid == null ? nextCharIndex : charIndex;
        fontMatch.fontInfo = lastValid == null ? null : lastValid.fontInfo;
        return fontMatch;
    }

    private FamilyFonts getFamilyFonts(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        String family = (String)attributes.get(TextAttribute.FAMILY);
        return this.getFamilyFonts(family, locale);
    }

    protected FamilyFonts getFamilyFonts(String name, Locale locale) {
        Pair<String, Locale> key = new Pair<String, Locale>(name, locale);
        FamilyFonts fonts = this.familyFonts.get(key);
        if (fonts == null) {
            fonts = this.loadFamilyFonts(name, locale);
            this.familyFonts.put(key, fonts);
        }
        return fonts;
    }

    protected FamilyFonts loadFamilyFonts(String name, Locale locale) {
        if (name == null) {
            return NULL_FAMILY_FONTS;
        }
        FontInfo fontInfo = this.fontUtil.getFontInfo(name, locale);
        if (fontInfo != null) {
            return NULL_FAMILY_FONTS;
        }
        FontSetInfo fontSetInfo = this.fontUtil.getFontSetInfo(name, locale, this.ignoreMissingFonts);
        if (fontSetInfo == null) {
            return NULL_FAMILY_FONTS;
        }
        return new FamilyFonts(fontSetInfo);
    }

    public static String getIndentedBulletText(StyledTextWriteContext context) {
        String bulletIndent = null;
        if (context.isListItemChange()) {
            if (!context.isFirstRun() && !context.prevListItemEndedWithNewLine() && (!context.listItemStartsWithNewLine() && context.isListItemStart() || context.isListItemEnd())) {
                bulletIndent = "\n";
            }
            if (context.getDepth() > 0) {
                bulletIndent = (bulletIndent == null ? "" : bulletIndent) + new String(new char[context.getDepth() * 4]).replace('\u0000', ' ');
            }
        }
        String bulletText = JRStyledTextUtil.getBulletText(context);
        return bulletIndent == null ? null : bulletIndent + (bulletText == null ? "" : bulletText + " ");
    }

    public static String getBulletText(StyledTextWriteContext context) {
        String bulletText = null;
        if (context.isListItemStart() && !context.getListItem().noBullet()) {
            bulletText = JRStyledTextUtil.getBulletText(context.getList(), context.getListItem());
        }
        return bulletText;
    }

    public static String getBulletText(StyledTextListInfo list, StyledTextListItemInfo listItem) {
        String bulletText = null;
        if (list == null || !list.ordered()) {
            bulletText = "\u2022";
        } else {
            int itemNumber = list.getStart() + listItem.getItemIndex();
            if (list.getType() == null) {
                bulletText = String.valueOf(itemNumber);
            } else {
                switch (list.getType()) {
                    case "A": {
                        bulletText = JRStringUtil.getLetterNumeral(itemNumber, true);
                        break;
                    }
                    case "a": {
                        bulletText = JRStringUtil.getLetterNumeral(itemNumber, false);
                        break;
                    }
                    case "I": {
                        bulletText = JRStringUtil.getRomanNumeral(itemNumber, true);
                        break;
                    }
                    case "i": {
                        bulletText = JRStringUtil.getRomanNumeral(itemNumber, false);
                        break;
                    }
                    default: {
                        bulletText = String.valueOf(itemNumber);
                    }
                }
            }
            bulletText = bulletText + ".";
        }
        return bulletText;
    }

    public static JRStyledText getBulletedText(JRStyledText styledText) {
        if (styledText != null) {
            StyledTextWriteContext context = new StyledTextWriteContext();
            StringBuilder sb = new StringBuilder();
            AttributedCharacterIterator allParagraphs = styledText.getAttributedString().getIterator();
            String allText = styledText.getText();
            int runLimit = 0;
            while (runLimit < allParagraphs.getEndIndex() && (runLimit = allParagraphs.getRunLimit(JRTextAttribute.HTML_LIST_ATTRIBUTES)) <= allParagraphs.getEndIndex()) {
                Map<AttributedCharacterIterator.Attribute, Object> attributes = allParagraphs.getAttributes();
                String runText = allText.substring(allParagraphs.getIndex(), runLimit);
                context.next(attributes, runText);
                if (context.listItemStartsWithNewLine() && !context.isListItemStart() && (context.isListItemEnd() || context.isListStart() || context.isListEnd())) {
                    runText = runText.substring(1);
                }
                if (runText.length() > 0) {
                    String bulletText = JRStyledTextUtil.getIndentedBulletText(context);
                    sb.append((bulletText == null ? "" : bulletText) + runText);
                }
                allParagraphs.setIndex(runLimit);
            }
            styledText = new JRStyledText(styledText.getLocale(), sb.toString(), styledText.getGlobalAttributes());
        }
        return styledText;
    }

    public static JRStyledText getBulletedStyledText(JRStyledText styledText) {
        if (styledText != null) {
            StyledTextWriteContext context = new StyledTextWriteContext();
            StringBuilder sb = new StringBuilder();
            AttributedCharacterIterator allParagraphs = styledText.getAttributedString().getIterator();
            String allText = styledText.getText();
            int resizeOffset = 0;
            int runLimit = 0;
            while (runLimit < allParagraphs.getEndIndex() && (runLimit = allParagraphs.getRunLimit(JRTextAttribute.HTML_LIST_ATTRIBUTES)) <= allParagraphs.getEndIndex()) {
                Map<AttributedCharacterIterator.Attribute, Object> attributes = allParagraphs.getAttributes();
                String runText = allText.substring(allParagraphs.getIndex(), runLimit);
                context.next(attributes, runText);
                int initRunTextLength = runText.length();
                int initBufferSize = sb.length();
                if (context.listItemStartsWithNewLine() && !context.isListItemStart() && (context.isListItemEnd() || context.isListStart() || context.isListEnd())) {
                    runText = runText.substring(1);
                }
                if (runText.length() > 0) {
                    String bulletText = JRStyledTextUtil.getIndentedBulletText(context);
                    if (bulletText != null) {
                        sb.append(bulletText);
                    }
                    sb.append(runText);
                }
                int resizeAmount = sb.length() - initBufferSize - initRunTextLength;
                JRStyledTextUtil.resizeRuns(styledText.getRuns(), allParagraphs.getIndex() + resizeOffset, resizeAmount);
                resizeOffset += resizeAmount;
                allParagraphs.setIndex(runLimit);
            }
            styledText = new JRStyledText(styledText.getLocale(), sb.toString(), styledText.getGlobalAttributes(), styledText.getRuns());
        }
        return styledText;
    }

    public static void resizeRuns(List<JRStyledText.Run> runs, int startIndex, int count) {
        for (int j = 0; j < runs.size(); ++j) {
            JRStyledText.Run run = runs.get(j);
            if (startIndex < run.startIndex) {
                run.startIndex += count;
            }
            if (startIndex >= run.endIndex) continue;
            run.endIndex += count;
        }
    }

    private static class Face {
        final Family family;
        final FontInfo fontInfo;
        final CharPredicateCache cache;

        public Face(Family family, FontFace fontFace, int style) {
            this.family = family;
            this.fontInfo = new FontInfo(family.fontFamily.getFontFamily(), fontFace, style);
            this.cache = new CharPredicateCache();
        }

        public boolean supports(int code) {
            boolean supports;
            CharPredicateCache.Result cacheResult = this.cache.getCached(code);
            switch (cacheResult) {
                case TRUE: {
                    supports = true;
                    break;
                }
                case FALSE: {
                    supports = false;
                    break;
                }
                case NOT_FOUND: {
                    supports = this.supported(code);
                    this.cache.set(code, supports);
                    break;
                }
                default: {
                    supports = this.supported(code);
                }
            }
            return supports;
        }

        protected boolean supported(int code) {
            return this.family.includesCharacter(code) && this.fontInfo.getFontFace().getFont().canDisplay(code);
        }
    }

    private static class Family {
        final FontSetFamilyInfo fontFamily;
        CharScriptsSet scriptsSet;

        public Family(FontSetFamilyInfo fontSetFamily) {
            this.fontFamily = fontSetFamily;
            this.initScripts();
        }

        private void initScripts() {
            List<String> includedScripts = this.fontFamily.getFontSetFamily().getIncludedScripts();
            List<String> excludedScripts = this.fontFamily.getFontSetFamily().getExcludedScripts();
            if (includedScripts != null && !includedScripts.isEmpty() || excludedScripts != null && !excludedScripts.isEmpty()) {
                this.scriptsSet = new CharScriptsSet(includedScripts, excludedScripts);
            }
        }

        public boolean includesCharacter(int codePoint) {
            return this.scriptsSet == null || this.scriptsSet.includesCharacter(codePoint);
        }
    }

    private static class FamilyFonts {
        FontSetInfo fontSet;
        List<Face> normalFonts;
        List<Face> boldFonts;
        List<Face> italicFonts;
        List<Face> boldItalicFonts;

        public FamilyFonts(FontSetInfo fontSet) {
            this.fontSet = fontSet;
            this.init();
        }

        private void init() {
            if (this.fontSet == null) {
                return;
            }
            List<FontSetFamilyInfo> families = this.fontSet.getFamilies();
            this.normalFonts = new ArrayList<Face>(families.size());
            this.boldFonts = new ArrayList<Face>(families.size());
            this.italicFonts = new ArrayList<Face>(families.size());
            this.boldItalicFonts = new ArrayList<Face>(families.size());
            for (FontSetFamilyInfo fontSetFamily : families) {
                Family family = new Family(fontSetFamily);
                FontFamily fontFamily = fontSetFamily.getFontFamily();
                if (fontFamily.getNormalFace() != null && fontFamily.getNormalFace().getFont() != null) {
                    this.normalFonts.add(new Face(family, fontFamily.getNormalFace(), 0));
                }
                if (fontFamily.getBoldFace() != null && fontFamily.getBoldFace().getFont() != null) {
                    this.boldFonts.add(new Face(family, fontFamily.getBoldFace(), 1));
                }
                if (fontFamily.getItalicFace() != null && fontFamily.getItalicFace().getFont() != null) {
                    this.italicFonts.add(new Face(family, fontFamily.getItalicFace(), 2));
                }
                if (fontFamily.getBoldItalicFace() == null || fontFamily.getBoldItalicFace().getFont() == null) continue;
                this.boldItalicFonts.add(new Face(family, fontFamily.getBoldItalicFace(), 3));
            }
        }

        public boolean needsToResolveFonts(String exporterKey) {
            return this.fontSet != null && (exporterKey == null || this.fontSet.getFontSet().getExportFont(exporterKey) == null);
        }
    }

    protected static class FontMatch {
        FontInfo fontInfo;
        int endIndex;

        protected FontMatch() {
        }
    }
}

