/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.jasperreports.engine.BookmarkHelper;
import net.sf.jasperreports.engine.BookmarkIterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.DelayedFillActions;
import net.sf.jasperreports.engine.fill.FillerParent;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRResourcesFillUtil;
import net.sf.jasperreports.engine.fill.JasperReportSource;
import net.sf.jasperreports.engine.fill.SimpleJasperReportSource;
import net.sf.jasperreports.engine.part.DelayedPrintPart;
import net.sf.jasperreports.engine.part.FillPart;
import net.sf.jasperreports.engine.part.FillPartPrintOutput;
import net.sf.jasperreports.engine.part.FillParts;
import net.sf.jasperreports.engine.part.FillPrintPart;
import net.sf.jasperreports.engine.part.FillPrintPartQueue;
import net.sf.jasperreports.engine.part.FillingPrintPart;
import net.sf.jasperreports.engine.part.FinalFillingPrintPart;
import net.sf.jasperreports.engine.part.GroupFillParts;
import net.sf.jasperreports.engine.part.PartEvaluationTime;
import net.sf.jasperreports.engine.part.PartPrintOutput;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.type.SectionTypeEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.parts.PartFillerParent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartReportFiller
extends BaseReportFiller {
    private static final Log log = LogFactory.getLog(PartReportFiller.class);
    public static final String EXCEPTION_MESSAGE_KEY_EVALUATION_GROUP_NOT_FOUND = "fill.part.filler.evaluation.group.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_EVALUATION_TIME_TYPE = "fill.part.filler.unknown.evaluation.time.type";
    public static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_SECTION_TYPE = "fill.part.filler.unsupported.section.type";
    private FillParts detailParts;
    private List<GroupFillParts> groupParts;
    private Map<String, GroupFillParts> groupPartsByName;
    private FillPrintPartQueue partQueue;
    private List<DelayedPrintPart> reportEvaluatedParts;

    public PartReportFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport) throws JRException {
        this(jasperReportsContext, (JasperReportSource)SimpleJasperReportSource.from(jasperReport), null);
    }

    public PartReportFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport, PartFillerParent parent) throws JRException {
        this(jasperReportsContext, (JasperReportSource)SimpleJasperReportSource.from(jasperReport), parent);
    }

    public PartReportFiller(JasperReportsContext jasperReportsContext, JasperReportSource reportSource, PartFillerParent parent) throws JRException {
        super(jasperReportsContext, reportSource, (FillerParent)parent);
        this.detailParts = new FillParts(this.jasperReport.getDetailSection(), this.factory);
        JRGroup[] reportGroups = this.jasperReport.getGroups();
        if (reportGroups == null || reportGroups.length == 0) {
            this.groupParts = Collections.emptyList();
            this.groupPartsByName = Collections.emptyMap();
        } else {
            this.groupParts = new ArrayList<GroupFillParts>(reportGroups.length);
            this.groupPartsByName = new HashMap<String, GroupFillParts>();
            for (JRGroup reportGroup : reportGroups) {
                GroupFillParts groupFillParts = new GroupFillParts(reportGroup, this.factory);
                this.groupParts.add(groupFillParts);
                this.groupPartsByName.put(reportGroup.getName(), groupFillParts);
            }
        }
        this.initDatasets();
        this.reportEvaluatedParts = new ArrayList<DelayedPrintPart>();
        if (parent == null) {
            JasperPrintPartOutput jasperPrintOutput = new JasperPrintPartOutput();
            this.partQueue = new FillPrintPartQueue(jasperPrintOutput);
        } else {
            this.partQueue = parent.getFiller().partQueue;
        }
    }

    @Override
    protected void jasperReportSet() {
        if (this.jasperReport.getSectionType() != SectionTypeEnum.PART) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_SECTION_TYPE, this.jasperReport.getSectionType());
        }
    }

    @Override
    protected JRFillObjectFactory initFillFactory() {
        return new JRFillObjectFactory(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JasperPrint fill(Map<String, Object> parameterValues) throws JRException {
        if (parameterValues == null) {
            parameterValues = new HashMap<String, Object>();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.fillerId + ": filling report"));
        }
        this.setParametersToContext(parameterValues);
        this.fillingThread = Thread.currentThread();
        JRResourcesFillUtil.ResourcesFillContext resourcesContext = JRResourcesFillUtil.setResourcesFillContext(parameterValues);
        boolean success = false;
        try {
            this.createBoundElemementMaps();
            this.setParameters(parameterValues);
            this.setBookmarkHelper();
            this.jasperPrint.setName(this.jasperReport.getName());
            this.jasperPrint.setPageWidth(this.jasperReport.getPageWidth());
            this.jasperPrint.setPageHeight(this.jasperReport.getPageHeight());
            this.jasperPrint.setTopMargin(this.jasperReport.getTopMargin());
            this.jasperPrint.setLeftMargin(this.jasperReport.getLeftMargin());
            this.jasperPrint.setBottomMargin(this.jasperReport.getBottomMargin());
            this.jasperPrint.setRightMargin(this.jasperReport.getRightMargin());
            this.jasperPrint.setOrientation(this.jasperReport.getOrientationValue());
            this.jasperPrint.setFormatFactoryClass(this.jasperReport.getFormatFactoryClass());
            this.jasperPrint.setLocaleCode(JRDataUtils.getLocaleCode(this.getLocale()));
            this.jasperPrint.setTimeZoneId(JRDataUtils.getTimeZoneId(this.getTimeZone()));
            this.propertiesUtil.transferProperties(this.mainDataset, (JRPropertiesHolder)this.jasperPrint, "net.sf.jasperreports.print.transfer.");
            this.mainDataset.start();
            this.fillReport();
            if (this.bookmarkHelper != null) {
                this.jasperPrint.setBookmarks(this.bookmarkHelper.getRootBookmarks());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.fillerId + ": ended"));
            }
            success = true;
            JasperPrint jasperPrint = this.jasperPrint;
            return jasperPrint;
        }
        finally {
            this.mainDataset.closeDatasource();
            this.mainDataset.disposeParameterContributors();
            if (success && this.parent == null) {
                this.fillContext.cacheDone();
            }
            this.delayedActions.dispose();
            this.fillingThread = null;
            if (this.parent == null) {
                this.fillContext.dispose();
            }
            JRResourcesFillUtil.revertResourcesFillContext(resourcesContext);
        }
    }

    private void createBoundElemementMaps() {
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_MASTER);
    }

    @Override
    protected void ignorePaginationSet(Map<String, Object> parameterValues) {
    }

    protected void fillReport() throws JRException {
        if (this.mainDataset.next()) {
            this.startReport();
            this.fillFirstGroupHeaders();
            this.calculateDetail();
            this.fillDetail();
            while (this.mainDataset.next()) {
                this.checkInterrupted();
                this.estimateGroups();
                this.fillChangedGroupFooters();
                this.fillChangedGroupEvaluatedParts();
                this.calculateGroups();
                this.fillChangedGroupHeaders();
                this.calculateDetail();
                this.fillDetail();
            }
            this.fillLastGroupFooters();
            this.fillLastGroupEvaluatedParts();
        } else {
            this.startReport();
        }
        this.fillReportEvaluatedParts();
        assert (this.partQueue.isCollapsed());
        if (this.isMasterReport()) {
            this.resolveMasterBoundElements();
        }
    }

    protected void startReport() throws JRScriptletException, JRException {
        this.scriptlet.callBeforeReportInit();
        this.calculator.initializeVariables(ResetTypeEnum.REPORT, IncrementTypeEnum.REPORT);
        this.scriptlet.callAfterReportInit();
    }

    protected void calculateDetail() throws JRScriptletException, JRException {
        this.scriptlet.callBeforeDetailEval();
        this.calculator.calculateVariables(true);
        this.scriptlet.callAfterDetailEval();
    }

    protected void estimateGroups() throws JRException {
        this.calculator.estimateGroupRuptures();
    }

    protected void calculateGroups() throws JRException {
        this.scriptlet.callBeforeGroupInit();
        this.calculator.initializeVariables(ResetTypeEnum.GROUP, IncrementTypeEnum.GROUP);
        this.scriptlet.callAfterGroupInit();
    }

    protected void fillDetail() throws JRException {
        this.fillParts(this.detailParts, (byte)3);
    }

    protected void fillFirstGroupHeaders() throws JRException {
        for (GroupFillParts group : this.groupParts) {
            this.fillParts(group.getHeaderParts(), (byte)3);
        }
    }

    protected void fillChangedGroupHeaders() throws JRException {
        for (GroupFillParts group : this.groupParts) {
            if (!group.hasChanged()) continue;
            this.fillParts(group.getHeaderParts(), (byte)3);
        }
    }

    private void fillChangedGroupFooters() throws JRException {
        ListIterator<GroupFillParts> iterator = this.groupParts.listIterator(this.groupParts.size());
        while (iterator.hasPrevious()) {
            GroupFillParts group = iterator.previous();
            if (!group.hasChanged()) continue;
            this.fillParts(group.getFooterParts(), (byte)1);
        }
    }

    private void fillLastGroupFooters() throws JRException {
        ListIterator<GroupFillParts> iterator = this.groupParts.listIterator(this.groupParts.size());
        while (iterator.hasPrevious()) {
            GroupFillParts group = iterator.previous();
            this.fillParts(group.getFooterParts(), (byte)3);
        }
    }

    protected void fillParts(FillParts parts, byte evaluation) throws JRException {
        for (FillPart part : parts.getParts()) {
            this.checkInterrupted();
            this.fillPart(part, evaluation);
        }
    }

    protected void fillPart(FillPart part, byte evaluation) throws JRException {
        PartEvaluationTime evaluationTime = part.getEvaluationTime();
        switch (evaluationTime.getEvaluationTimeType()) {
            case NOW: {
                PartPrintOutput appendOutput = this.partQueue.tail().getOutput();
                if (appendOutput != null) {
                    part.fill(evaluation, appendOutput);
                    break;
                }
                FillPartPrintOutput localOutput = new FillPartPrintOutput(this);
                part.fill(evaluation, localOutput);
                this.partQueue.appendOutput(localOutput);
                break;
            }
            case REPORT: {
                DelayedPrintPart delayedPart = this.partQueue.appendDelayed(part);
                this.reportEvaluatedParts.add(delayedPart);
                break;
            }
            case GROUP: {
                GroupFillParts groupFillParts = this.groupPartsByName.get(evaluationTime.getEvaluationGroup());
                if (groupFillParts == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_EVALUATION_GROUP_NOT_FOUND, evaluationTime.getEvaluationGroup());
                }
                DelayedPrintPart delayedPart = this.partQueue.appendDelayed(part);
                groupFillParts.addGroupEvaluatedPart(delayedPart);
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_EVALUATION_TIME_TYPE, evaluationTime.getEvaluationTimeType());
            }
        }
    }

    @Override
    public boolean isPageFinal(int pageIndex) {
        if (this.isSubreport()) {
            return false;
        }
        return ((JasperPrintPartOutput)this.partQueue.head().getOutput()).isPageFinal(pageIndex);
    }

    protected void partPageUpdated(int pageIndex) {
        if (this.fillListener != null) {
            this.fillListener.pageUpdated(this.jasperPrint, pageIndex);
        }
    }

    protected void fillReportEvaluatedParts() throws JRException {
        this.fillDelayedEvaluatedParts(this.reportEvaluatedParts, (byte)3);
    }

    protected void fillChangedGroupEvaluatedParts() throws JRException {
        for (GroupFillParts group : this.groupParts) {
            if (!group.hasChanged()) continue;
            this.fillDelayedEvaluatedParts(group.getGroupEvaluatedParts(), (byte)1);
        }
    }

    protected void fillLastGroupEvaluatedParts() throws JRException {
        for (GroupFillParts group : this.groupParts) {
            this.fillDelayedEvaluatedParts(group.getGroupEvaluatedParts(), (byte)3);
        }
    }

    protected void fillDelayedEvaluatedParts(List<DelayedPrintPart> parts, byte evaluation) throws JRException {
        ListIterator<DelayedPrintPart> it = parts.listIterator();
        while (it.hasNext()) {
            DelayedPrintPart part = it.next();
            it.remove();
            this.fillDelayedPart(evaluation, part);
        }
    }

    protected void fillDelayedPart(byte evaluation, DelayedPrintPart part) throws JRException {
        this.partQueue.fillDelayed(part, this, evaluation);
    }

    public BookmarkHelper getFirstBookmarkHelper() {
        for (FillPrintPart part = this.partQueue.head(); part != null; part = part.nextPart()) {
            BookmarkHelper bookmarks;
            PartPrintOutput output = part.getOutput();
            if (output == null || !(bookmarks = output.getBookmarkHelper()).hasBookmarks()) continue;
            return bookmarks;
        }
        return null;
    }

    protected class JasperPrintPartOutput
    implements PartPrintOutput {
        private final ReadWriteLock currentFillPartLock = new ReentrantReadWriteLock();
        private transient int currentPartStartIndex;
        private FillingPrintPart currentFillingPart;

        protected JasperPrintPartOutput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startPart(PrintPart part, FillingPrintPart fillingPart) {
            int startIndex = PartReportFiller.this.jasperPrint.getPages().size();
            PartReportFiller.this.jasperPrint.addPart(startIndex, part);
            this.currentFillPartLock.writeLock().lock();
            try {
                this.currentPartStartIndex = startIndex;
                this.currentFillingPart = fillingPart;
            }
            finally {
                this.currentFillPartLock.writeLock().unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("added part " + part.getName() + " at index " + startIndex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPageFinal(int pageIndex) {
            this.currentFillPartLock.readLock().lock();
            try {
                JRPrintPage page = this.getPage(pageIndex);
                boolean hasMasterActions = PartReportFiller.this.delayedActions.hasDelayedActions(page);
                if (hasMasterActions) {
                    boolean bl = false;
                    return bl;
                }
                boolean isFinal = pageIndex < this.currentPartStartIndex ? true : this.currentFillingPart.isPageFinal(page);
                boolean bl = isFinal;
                return bl;
            }
            finally {
                this.currentFillPartLock.readLock().unlock();
            }
        }

        @Override
        public void addPage(JRPrintPage page, DelayedFillActions delayedActionsSource) {
            int pageIndex = PartReportFiller.this.jasperPrint.getPages().size();
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding part page at index " + pageIndex));
            }
            PartReportFiller.this.jasperPrint.addPage(page);
            PartReportFiller.this.addLastPageBookmarks();
            PartReportFiller.this.delayedActions.moveMasterEvaluations(delayedActionsSource, page, pageIndex);
            if (PartReportFiller.this.fillListener != null) {
                PartReportFiller.this.fillListener.pageGenerated(PartReportFiller.this.jasperPrint, pageIndex);
            }
        }

        @Override
        public JRPrintPage getPage(int pageIndex) {
            return PartReportFiller.this.jasperPrint.getPages().get(pageIndex);
        }

        @Override
        public void pageUpdated(int partPageIndex) {
            PartReportFiller.this.partPageUpdated(this.currentPartStartIndex + partPageIndex);
        }

        @Override
        public void append(FillPartPrintOutput output) {
            this.addStyles(output.getStyles());
            this.addOrigins(output.getOrigins());
            int pageOffset = PartReportFiller.this.jasperPrint.getPages().size();
            BookmarkHelper outputBookmarks = output.getBookmarkHelper();
            BookmarkIterator bookmarkIterator = null;
            if (PartReportFiller.this.bookmarkHelper != null && outputBookmarks != null) {
                bookmarkIterator = outputBookmarks.bookmarkIterator();
            }
            DelayedFillActions sourceActions = output.getDelayedActions();
            ListIterator<JRPrintPage> pagesIterator = output.getPages().listIterator();
            int prevPartStart = 0;
            for (Map.Entry<Integer, PrintPart> partEntry : output.getParts().entrySet()) {
                int partStart = partEntry.getKey();
                for (int i = prevPartStart; i < partStart; ++i) {
                    JRPrintPage page = pagesIterator.next();
                    this.addPage(page, pageOffset, sourceActions, bookmarkIterator);
                }
                prevPartStart = partStart;
                PrintPart part = partEntry.getValue();
                this.startPart(part, FinalFillingPrintPart.instance());
            }
            while (pagesIterator.hasNext()) {
                JRPrintPage page = pagesIterator.next();
                this.addPage(page, pageOffset, sourceActions, bookmarkIterator);
            }
        }

        protected void addPage(JRPrintPage page, int pageOffset, DelayedFillActions sourceActions, BookmarkIterator sourceBookmarkIterator) {
            int pageIndex = PartReportFiller.this.jasperPrint.getPages().size();
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding part page at index " + pageIndex));
            }
            PartReportFiller.this.jasperPrint.addPage(page);
            if (sourceBookmarkIterator != null) {
                int sourcePageIndex = pageIndex - pageOffset;
                while (sourceBookmarkIterator.hasBookmark() && sourceBookmarkIterator.bookmark().getPageIndex() == sourcePageIndex) {
                    PartReportFiller.this.bookmarkHelper.addBookmark(sourceBookmarkIterator.bookmark(), pageOffset);
                    sourceBookmarkIterator.next();
                }
            }
            PartReportFiller.this.delayedActions.moveMasterEvaluations(sourceActions, page, pageIndex);
            if (PartReportFiller.this.fillListener != null) {
                PartReportFiller.this.fillListener.pageGenerated(PartReportFiller.this.jasperPrint, pageIndex);
            }
        }

        @Override
        public BookmarkHelper getBookmarkHelper() {
            return PartReportFiller.this.bookmarkHelper;
        }

        @Override
        public void addStyles(Collection<JRStyle> stylesList) {
            for (JRStyle style : stylesList) {
                try {
                    PartReportFiller.this.jasperPrint.addStyle(style, true);
                }
                catch (JRException e) {
                    throw new JRRuntimeException(e);
                }
            }
        }

        @Override
        public void addOrigins(Collection<JROrigin> origins) {
            for (JROrigin origin : origins) {
                PartReportFiller.this.jasperPrint.addOrigin(origin);
            }
        }
    }
}

