/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.components.charts.ChartSettings;
import net.sf.jasperreports.components.spiderchart.SpiderChartCompiler;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardChartSettings
implements ChartSettings,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final byte CHART_TYPE_SPIDER = 22;
    public static final String PROPERTY_LEGEND_BACKGROUND_COLOR = "legendBackgroundColor";
    public static final String PROPERTY_LEGEND_COLOR = "legendColor";
    public static final String PROPERTY_LEGEND_POSITION = "legendPosition";
    public static final String PROPERTY_SHOW_LEGEND = "showLegend";
    public static final String PROPERTY_SUBTITLE_COLOR = "subtitleColor";
    public static final String PROPERTY_TITLE_COLOR = "titleColor";
    public static final String PROPERTY_TITLE_POSITION = "titlePosition";
    public static final String PROPERTY_RENDER_TYPE = "renderType";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_BACKCOLOR = "backcolor";
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL_EXPRESSION = "bookmarkLevelExpression";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_CHART_TYPE = "chartType";
    public static final String PROPERTY_LEGEND_FONT = "legendFont";
    public static final String PROPERTY_SUBTITLE_EXPRESSION = "subtitleExpression";
    public static final String PROPERTY_SUBTITLE_FONT = "subtitleFont";
    public static final String PROPERTY_TITLE_EXPRESSION = "titleExpression";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    public static final String PROPERTY_HYPERLINK_ANCHOR_EXPRESSION = "hyperlinkAnchorExpression";
    public static final String PROPERTY_HYPERLINK_PAGE_EXPRESSION = "hyperlinkPageExpression";
    public static final String PROPERTY_HYPERLINK_REFERENCE_EXPRESSION = "hyperlinkReferenceExpression";
    public static final String PROPERTY_HYPERLINK_WHEN_EXPRESSION = "hyperlinkWhenExpression";
    public static final String PROPERTY_HYPERLINK_TARGET = "hyperlinkTarget";
    public static final String PROPERTY_LINK_TARGET = "linkTarget";
    public static final String PROPERTY_HYPERLINK_TOOLTIP_EXPRESSION = "hyperlinkTooltipExpression";
    public static final String PROPERTY_LINK_TYPE = "linkType";
    public static final String PROPERTY_HYPERLINK_PARAMETERS = "hyperlinkParameters";
    public static final String PROPERTY_CUSTOMIZER_CLASS = "customizerClass";
    protected Byte chartType = 22;
    protected Boolean showLegend;
    protected String linkType;
    protected String linkTarget;
    protected List<JRHyperlinkParameter> hyperlinkParameters = new ArrayList<JRHyperlinkParameter>();
    protected Color backcolor;
    protected Color titleColor;
    protected Color subtitleColor;
    protected Color legendColor;
    protected Color legendBackgroundColor;
    protected EdgeEnum legendPosition;
    protected EdgeEnum titlePosition;
    protected String renderType;
    protected JRFont titleFont;
    protected JRFont subtitleFont;
    protected JRFont legendFont;
    protected JRExpression titleExpression;
    protected JRExpression subtitleExpression;
    protected JRExpression anchorNameExpression;
    protected JRExpression bookmarkLevelExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    protected JRExpression hyperlinkTooltipExpression;
    protected String customizerClass;
    protected int bookmarkLevel = 0;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardChartSettings() {
    }

    public StandardChartSettings(ChartSettings chart, JRBaseObjectFactory factory) {
        this.showLegend = chart.getShowLegend();
        this.backcolor = chart.getBackcolor();
        this.linkType = chart.getLinkType();
        this.linkTarget = chart.getLinkTarget();
        this.titlePosition = chart.getTitlePosition();
        this.titleColor = chart.getTitleColor();
        this.subtitleColor = chart.getSubtitleColor();
        this.legendColor = chart.getLegendColor();
        this.legendBackgroundColor = chart.getLegendBackgroundColor();
        this.legendPosition = chart.getLegendPosition();
        this.renderType = chart.getRenderType();
        this.titleFont = chart.getTitleFont();
        this.subtitleFont = chart.getSubtitleFont();
        this.legendFont = chart.getLegendFont();
        this.titleExpression = factory.getExpression(chart.getTitleExpression());
        this.subtitleExpression = factory.getExpression(chart.getSubtitleExpression());
        this.anchorNameExpression = factory.getExpression(chart.getAnchorNameExpression());
        this.bookmarkLevelExpression = factory.getExpression(chart.getBookmarkLevelExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(chart.getHyperlinkReferenceExpression());
        this.hyperlinkWhenExpression = factory.getExpression(chart.getHyperlinkWhenExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(chart.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(chart.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(chart.getHyperlinkTooltipExpression());
        this.bookmarkLevel = chart.getBookmarkLevel();
        this.customizerClass = chart.getCustomizerClass();
        JRHyperlinkParameter[] hyperlinkParams = chart.getHyperlinkParameters();
        if (hyperlinkParams != null && hyperlinkParams.length > 0) {
            for (int i = 0; i < hyperlinkParams.length; ++i) {
                this.addHyperlinkParameter(factory.getHyperlinkParameter(hyperlinkParams[i]));
            }
        }
    }

    @Override
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(Boolean isShowLegend) {
        Boolean old = this.showLegend;
        this.showLegend = isShowLegend;
        this.getEventSupport().firePropertyChange(PROPERTY_SHOW_LEGEND, old, this.showLegend);
    }

    @Override
    public Color getBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color backcolor) {
        Color old = this.backcolor;
        this.backcolor = backcolor;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKCOLOR, old, this.backcolor);
    }

    @Override
    public JRFont getTitleFont() {
        return this.titleFont;
    }

    @Override
    public EdgeEnum getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(EdgeEnum titlePosition) {
        EdgeEnum old = this.titlePosition;
        this.titlePosition = titlePosition;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_POSITION, old, this.titlePosition);
    }

    @Override
    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        Color old = this.titleColor;
        this.titleColor = titleColor;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_COLOR, old, this.titleColor);
    }

    @Override
    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    @Override
    public Color getSubtitleColor() {
        return this.subtitleColor;
    }

    public void setSubtitleColor(Color subtitleColor) {
        Color old = this.subtitleColor;
        this.subtitleColor = subtitleColor;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_COLOR, old, this.subtitleColor);
    }

    @Override
    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    @Override
    public Color getLegendColor() {
        return this.legendColor;
    }

    @Override
    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        Color old = this.legendBackgroundColor;
        this.legendBackgroundColor = legendBackgroundColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_BACKGROUND_COLOR, old, this.legendBackgroundColor);
    }

    public void setLegendColor(Color legendColor) {
        Color old = this.legendColor;
        this.legendColor = legendColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_COLOR, old, this.legendColor);
    }

    @Override
    public EdgeEnum getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(EdgeEnum legendPosition) {
        EdgeEnum old = this.legendPosition;
        this.legendPosition = legendPosition;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_POSITION, old, this.legendPosition);
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    @Override
    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    @Override
    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getBookmarkLevelExpression() {
        return this.bookmarkLevelExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public byte getChartType() {
        return this.chartType;
    }

    @Override
    public String getRenderType() {
        return this.renderType;
    }

    public void setRenderType(String renderType) {
        String old = this.renderType;
        this.renderType = renderType;
        this.getEventSupport().firePropertyChange(PROPERTY_RENDER_TYPE, old, this.renderType);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        Integer old = this.bookmarkLevel;
        this.bookmarkLevel = bookmarkLevel;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, old, (Object)this.bookmarkLevel);
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    @Override
    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public void setChartType(Byte chartType) {
        Byte old = this.chartType;
        this.chartType = chartType;
        this.getEventSupport().firePropertyChange(PROPERTY_CHART_TYPE, old, this.chartType);
    }

    public void setLinkType(String linkType) {
        String old = this.linkType;
        this.linkType = linkType;
        this.getEventSupport().firePropertyChange(PROPERTY_LINK_TYPE, old, this.linkType);
    }

    public void setLinkTarget(String linkTarget) {
        String old = this.linkTarget;
        this.linkTarget = linkTarget;
        this.getEventSupport().firePropertyChange(PROPERTY_LINK_TARGET, old, this.linkTarget);
    }

    public void setTitleFont(JRFont titleFont) {
        String old = this.linkTarget;
        this.titleFont = titleFont;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_FONT, old, this.titleFont);
    }

    public void setSubtitleFont(JRFont subtitleFont) {
        JRFont old = this.subtitleFont;
        this.subtitleFont = subtitleFont;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_FONT, old, this.subtitleFont);
    }

    public void setLegendFont(JRFont legendFont) {
        JRFont old = this.legendFont;
        this.legendFont = legendFont;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_FONT, old, this.legendFont);
    }

    public void setTitleExpression(JRExpression titleExpression) {
        JRExpression old = this.titleExpression;
        this.titleExpression = titleExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_EXPRESSION, old, this.titleExpression);
    }

    public void setSubtitleExpression(JRExpression subtitleExpression) {
        JRExpression old = this.subtitleExpression;
        this.subtitleExpression = subtitleExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_EXPRESSION, old, this.subtitleExpression);
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        JRExpression old = this.anchorNameExpression;
        this.anchorNameExpression = anchorNameExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, old, this.anchorNameExpression);
    }

    public void setBookmarkLevelExpression(JRExpression bookmarkLevelExpression) {
        JRExpression old = this.bookmarkLevelExpression;
        this.bookmarkLevelExpression = bookmarkLevelExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL_EXPRESSION, old, this.bookmarkLevelExpression);
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        JRExpression old = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_REFERENCE_EXPRESSION, old, this.hyperlinkReferenceExpression);
    }

    public void setHyperlinkWhenExpression(JRExpression hyperlinkWhenExpression) {
        JRExpression old = this.hyperlinkWhenExpression;
        this.hyperlinkWhenExpression = hyperlinkWhenExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_WHEN_EXPRESSION, old, this.hyperlinkWhenExpression);
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        JRExpression old = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_ANCHOR_EXPRESSION, old, this.hyperlinkAnchorExpression);
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        JRExpression old = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = hyperlinkPageExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_PAGE_EXPRESSION, old, this.hyperlinkPageExpression);
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        JRExpression old = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_TOOLTIP_EXPRESSION, old, this.hyperlinkTooltipExpression);
    }

    public void setCustomizerClass(String customizerClass) {
        String old = this.customizerClass;
        this.customizerClass = customizerClass;
        this.getEventSupport().firePropertyChange(PROPERTY_CUSTOMIZER_CLASS, old, this.customizerClass);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        SpiderChartCompiler.collectExpressions(this, collector);
    }

    @Override
    public Object clone() {
        StandardChartSettings clone = null;
        try {
            clone = (StandardChartSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.hyperlinkParameters = JRCloneUtils.cloneList(this.hyperlinkParameters);
        clone.titleExpression = JRCloneUtils.nullSafeClone(this.titleExpression);
        clone.subtitleExpression = JRCloneUtils.nullSafeClone(this.subtitleExpression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.bookmarkLevelExpression = JRCloneUtils.nullSafeClone(this.bookmarkLevelExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = JRCloneUtils.nullSafeClone(this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardChartSettings standardChartSettings = this;
        synchronized (standardChartSettings) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters = null;
        if (!this.hyperlinkParameters.isEmpty()) {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    public List<JRHyperlinkParameter> getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_HYPERLINK_PARAMETERS, parameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        int idx = this.hyperlinkParameters.indexOf(parameter);
        if (idx >= 0) {
            this.hyperlinkParameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_HYPERLINK_PARAMETERS, parameter, idx);
        }
    }

    public void removeHyperlinkParameter(String parameterName) {
        ListIterator<JRHyperlinkParameter> it = this.hyperlinkParameters.listIterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_HYPERLINK_PARAMETERS, parameter, it.nextIndex());
        }
    }
}

