/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.rest;

import java.util.List;
import java.util.Set;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.flows.rest.model.FlowGraphUrlInfo;
import org.opennms.netmgt.flows.rest.model.FlowNodeDetails;
import org.opennms.netmgt.flows.rest.model.FlowNodeSummary;
import org.opennms.netmgt.flows.rest.model.FlowSeriesResponse;
import org.opennms.netmgt.flows.rest.model.FlowSummaryResponse;

@Path(value="flows")
public interface FlowRestService {
    public static final String DEFAULT_STEP_MS = "300000";
    public static final String DEFAULT_TOP_N = "10";
    public static final String DEFAULT_LIMIT = "10";

    @GET
    @Path(value="count")
    public Long getFlowCount(@Context UriInfo var1);

    @GET
    @Path(value="exporters")
    @Produces(value={"application/json"})
    public List<FlowNodeSummary> getFlowExporters();

    @GET
    @Path(value="exporters/{nodeId}")
    @Produces(value={"application/json"})
    public FlowNodeDetails getFlowExporter(@PathParam(value="nodeId") Integer var1);

    @GET
    @Path(value="dscp/enumerate")
    @Produces(value={"application/json"})
    public List<Integer> getDscpValues(@Context UriInfo var1);

    @GET
    @Path(value="dscp")
    @Produces(value={"application/json"})
    public FlowSummaryResponse getDscpSummaries(@Context UriInfo var1);

    @GET
    @Path(value="dscp/series")
    @Produces(value={"application/json"})
    public FlowSeriesResponse getDscpSeries(@DefaultValue(value="300000") @QueryParam(value="step") long var1, @Context UriInfo var3);

    @GET
    @Path(value="applications/enumerate")
    @Produces(value={"application/json"})
    public List<String> getApplications(@DefaultValue(value="") @QueryParam(value="prefix") String var1, @DefaultValue(value="10") @QueryParam(value="limit") long var2, @Context UriInfo var4);

    @GET
    @Path(value="applications")
    @Produces(value={"application/json"})
    public FlowSummaryResponse getApplicationSummary(@QueryParam(value="N") Integer var1, @QueryParam(value="application") Set<String> var2, @DefaultValue(value="false") @QueryParam(value="includeOther") boolean var3, @Context UriInfo var4);

    @GET
    @Path(value="applications/series")
    @Produces(value={"application/json"})
    public FlowSeriesResponse getApplicationSeries(@DefaultValue(value="300000") @QueryParam(value="step") long var1, @QueryParam(value="N") Integer var3, @QueryParam(value="application") Set<String> var4, @DefaultValue(value="false") @QueryParam(value="includeOther") boolean var5, @Context UriInfo var6);

    @GET
    @Path(value="hosts/enumerate")
    @Produces(value={"application/json"})
    public List<String> getHosts(@DefaultValue(value=".*") @QueryParam(value="pattern") String var1, @DefaultValue(value="10") @QueryParam(value="limit") long var2, @Context UriInfo var4);

    @GET
    @Path(value="hosts")
    @Produces(value={"application/json"})
    public FlowSummaryResponse getHostSummary(@QueryParam(value="N") Integer var1, @QueryParam(value="host") Set<String> var2, @DefaultValue(value="false") @QueryParam(value="includeOther") boolean var3, @Context UriInfo var4);

    @GET
    @Path(value="hosts/series")
    @Produces(value={"application/json"})
    public FlowSeriesResponse getHostSeries(@DefaultValue(value="300000") @QueryParam(value="step") long var1, @QueryParam(value="N") Integer var3, @QueryParam(value="host") Set<String> var4, @DefaultValue(value="false") @QueryParam(value="includeOther") boolean var5, @Context UriInfo var6);

    @GET
    @Path(value="conversations/enumerate")
    @Produces(value={"application/json"})
    public List<String> getConversations(@DefaultValue(value=".*") @QueryParam(value="location") String var1, @DefaultValue(value=".*") @QueryParam(value="protocol") String var2, @DefaultValue(value=".*") @QueryParam(value="lower") String var3, @DefaultValue(value=".*") @QueryParam(value="upper") String var4, @DefaultValue(value=".*") @QueryParam(value="application") String var5, @DefaultValue(value="10") @QueryParam(value="limit") long var6, @Context UriInfo var8);

    @GET
    @Path(value="conversations")
    @Produces(value={"application/json"})
    public FlowSummaryResponse getConversationSummary(@QueryParam(value="N") Integer var1, @QueryParam(value="conversation") Set<String> var2, @DefaultValue(value="false") @QueryParam(value="includeOther") boolean var3, @Context UriInfo var4);

    @GET
    @Path(value="conversations/series")
    @Produces(value={"application/json"})
    public FlowSeriesResponse getConversationSeries(@DefaultValue(value="300000") @QueryParam(value="step") long var1, @QueryParam(value="N") Integer var3, @QueryParam(value="conversation") Set<String> var4, @DefaultValue(value="false") @QueryParam(value="includeOther") boolean var5, @Context UriInfo var6);

    @GET
    @Path(value="flowGraphUrl")
    public FlowGraphUrlInfo getFlowGraphUrlInfo(@Context UriInfo var1);
}

