/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.asterisk.monitor;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionFactory;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.SipShowPeerAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.config.AmiPeerFactory;
import org.opennms.netmgt.config.ami.AmiAgentConfig;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsteriskSIPPeerMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(AsteriskSIPPeerMonitor.class);
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String DEFAULT_SIPPEER = "";

    public void initialize(Map<String, Object> parameters) {
        try {
            AmiPeerFactory.init();
        }
        catch (Exception e) {
            LOG.error("Initalize: Failed to load AMI configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String sipPeer = ParameterMap.getKeyedString(parameters, (String)"sip-peer", (String)DEFAULT_SIPPEER);
        if (sipPeer.equals(DEFAULT_SIPPEER)) {
            LOG.error("AsteriskMonitor: No sip-peer parameter in poller configuration");
            throw new RuntimeException("AsteriskMonitor: required parameter 'sip-peer' is not present in supplied properties.");
        }
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 0, 3000);
        AmiPeerFactory amiPeerFactory = AmiPeerFactory.getInstance();
        AmiAgentConfig amiConfig = amiPeerFactory.getAgentConfig(svc.getAddress());
        LOG.debug("{}: Creating new AMI-Connection: {}:{}, {}/{}", new Object[]{svc.getSvcName(), svc.getIpAddr(), amiConfig.getPort(), amiConfig.getUsername(), amiConfig.getPassword()});
        ManagerConnectionFactory factory = new ManagerConnectionFactory(svc.getIpAddr(), ((Integer)amiConfig.getPort().orElse(null)).intValue(), (String)amiConfig.getUsername().orElse(null), (String)amiConfig.getPassword().orElse(null));
        ManagerConnection managerConnection = amiConfig.getUseTls().orElse(false) != false ? factory.createSecureManagerConnection() : factory.createManagerConnection();
        managerConnection.setSocketTimeout(new Long(timeoutTracker.getTimeoutInMillis()).intValue());
        while (timeoutTracker.shouldRetry()) {
            timeoutTracker.nextAttempt();
            LOG.debug("{}: Attempt {}", (Object)svc.getSvcName(), (Object)timeoutTracker.getAttempt());
            try {
                LOG.debug("{}: AMI login", (Object)svc.getSvcName());
                managerConnection.login();
                LOG.debug("{}: AMI sendAction SipShowPeer", (Object)svc.getSvcName());
                ManagerResponse response = managerConnection.sendAction((ManagerAction)new SipShowPeerAction(sipPeer));
                if (response.getAttribute("Status") == null) {
                    LOG.debug("{}: service status down", (Object)svc.getSvcName());
                    return PollStatus.decode((String)"Down", (String)"State of SIP Peer is unknown, because it was not found on the Asterisk server");
                }
                LOG.debug("{}: Response: {}", (Object)svc.getSvcName(), (Object)response.getAttribute("Status"));
                LOG.debug("{}: AMI logoff", (Object)svc.getSvcName());
                managerConnection.logoff();
                if (response.getAttribute("Status").startsWith("OK")) {
                    LOG.debug("{}: service status up", (Object)svc.getSvcName());
                    return PollStatus.decode((String)"Up", (String)"OK");
                }
                LOG.debug("{}: service status down", (Object)svc.getSvcName());
                return PollStatus.decode((String)"Down", (String)("State of SIP Peer is " + response.getAttribute("Status") + " and not OK"));
            }
            catch (AuthenticationFailedException e) {
                LOG.debug("{}: AMI AuthenticationError.", (Object)svc.getSvcName(), (Object)e);
                return PollStatus.decode((String)"Down", (String)"Could not get the state of SIP Peer: AMI AuthenticationError");
            }
            catch (TimeoutException e) {
                LOG.debug("{}: TimeOut reached.", (Object)svc.getSvcName(), (Object)e);
            }
            catch (SocketTimeoutException e) {
                LOG.debug("{}: TimeOut reached.", (Object)svc.getSvcName(), (Object)e);
            }
            catch (Exception e) {
                LOG.error("{}: An Unknown Exception Occurred.", (Object)svc.getSvcName(), (Object)e);
                return PollStatus.decode((String)"Down", (String)("Could not get the state of SIP Peer: " + e.toString()));
            }
        }
        return PollStatus.decode((String)"Down", (String)"Could not get the state of SIP Peer: Timeout exceeded");
    }
}

