/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.asterisk.agi.scripts;

import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiRequest;
import org.opennms.netmgt.asterisk.agi.scripts.BaseOnmsAgiScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadNoticeDetailsAgiScript
extends BaseOnmsAgiScript {
    private static final Logger LOG = LoggerFactory.getLogger(ReadNoticeDetailsAgiScript.class);

    public void service(AgiRequest req, AgiChannel chan) throws AgiException {
        this.authenticateUser();
        this.sayNode();
        this.sayServiceName();
        this.streamFile("silence/1");
        this.sayIpAddr();
    }

    public void authenticateUser() throws AgiException {
        String actualPin = this.getVariable("OPENNMS_USER_PIN");
        if (actualPin == null || "".equals(actualPin)) {
            LOG.info("User has no TUI PIN, so proceeding without authentication");
            return;
        }
        String inputPin = null;
        for (int attempts = 0; !String.valueOf(inputPin).equals(String.valueOf(actualPin)) && attempts < 3; ++attempts) {
            if (attempts > 0) {
                this.streamFile("auth-incorrect");
            }
            inputPin = this.getData("enter-password");
        }
        if (String.valueOf(inputPin).equals(String.valueOf(actualPin))) {
            return;
        }
        LOG.warn("User {} failed authentication", (Object)this.getVariable("OPENNMS_USERNAME"));
        this.streamFile("auth-incorrect");
        this.streamFile("goodbye");
        this.hangup();
    }

    public void sayNode() throws AgiException {
        String nodeID = null;
        String nodeLabel = null;
        nodeID = this.getVariable("OPENNMS_NODEID");
        nodeLabel = this.getVariable("OPENNMS_NODELABEL");
        if (!"".equals(nodeLabel)) {
            LOG.debug("Reading node label to user: {}", (Object)nodeLabel);
            this.streamFileInterruptible("node");
            try {
                this.streamFileInterruptible(nodeLabel.toLowerCase());
            }
            catch (AgiException e) {
                this.sayAlphaInterruptible(nodeLabel);
            }
        } else if (!"".equals(nodeID)) {
            LOG.debug("Reading node ID to user: {}", (Object)nodeID);
            this.streamFileInterruptible("node");
            this.streamFileInterruptible("number");
            this.sayDigitsInterruptible(nodeID);
        } else {
            LOG.debug("No node label or node ID available");
        }
    }

    public void sayIpAddr() throws AgiException {
        String ipAddr = null;
        ipAddr = this.getVariable("OPENNMS_INTERFACE");
        if (ipAddr != null && !"".equals(ipAddr)) {
            LOG.debug("Reading IP address to user: {}", (Object)ipAddr);
            this.streamFileInterruptible("letters/i");
            this.streamFileInterruptible("letters/p");
            this.streamFileInterruptible("address");
            this.sayIpAddressInterruptible(ipAddr);
        }
    }

    public void sayServiceName() throws AgiException {
        String svcName = null;
        svcName = this.getVariable("OPENNMS_SERVICE");
        if (svcName != null && !"".equals(svcName)) {
            LOG.debug("Reading service name to user: {}", (Object)svcName);
            this.streamFileInterruptible("service");
            try {
                this.streamFileInterruptible(svcName.toLowerCase());
            }
            catch (AgiException e) {
                this.sayAlphaInterruptible(svcName);
            }
        } else {
            LOG.debug("No service name available");
        }
    }
}

