/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.situationfeedback.elastic;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.opennms.features.situationfeedback.api.AlarmFeedback;

public class FeedbackDocument {
    private static final int DOCUMENT_VERSION = 1;
    @SerializedName(value="@timestamp")
    private long timestamp;
    @SerializedName(value="@version")
    private final Integer version = 1;
    @SerializedName(value="alarm_key")
    private String alarmKey;
    @SerializedName(value="feedback_type")
    private String feedbackType;
    @SerializedName(value="situation_fingerprint")
    private String situationFingerprint;
    @SerializedName(value="situation_key")
    private String situationKey;
    @SerializedName(value="reason")
    private String reason;
    @SerializedName(value="root_cause")
    private Boolean isRootCause;
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    @SerializedName(value="user")
    private String user;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getAlarmKey() {
        return this.alarmKey;
    }

    public void setAlarmKey(String alarmKey) {
        this.alarmKey = alarmKey;
    }

    public String getFeedbackType() {
        return this.feedbackType;
    }

    public void setFeedbackType(String feedbackType) {
        this.feedbackType = feedbackType;
    }

    public String getSituationFingerprint() {
        return this.situationFingerprint;
    }

    public void setSituationFingerprint(String situationFingerprint) {
        this.situationFingerprint = situationFingerprint;
    }

    public String getSituationKey() {
        return this.situationKey;
    }

    public void setSituationKey(String situationKey) {
        this.situationKey = situationKey;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Boolean getIsRootCause() {
        return this.isRootCause;
    }

    public void setIsRootCause(Boolean isRootCause) {
        this.isRootCause = isRootCause;
    }

    public List<String> getTags() {
        return this.tags;
    }

    private void setTags(List<String> tags) {
        this.tags.addAll(tags);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static FeedbackDocument from(AlarmFeedback feedback) {
        FeedbackDocument doc = new FeedbackDocument();
        doc.setTimestamp(feedback.getTimestamp());
        doc.setAlarmKey(feedback.getAlarmKey());
        doc.setFeedbackType(feedback.getFeedbackType().toString());
        doc.setReason(feedback.getReason());
        doc.setSituationFingerprint(feedback.getSituationFingerprint());
        doc.setSituationKey(feedback.getSituationKey());
        doc.setIsRootCause(feedback.getRootCause());
        doc.setTags(feedback.getTags());
        doc.setUser(feedback.getUser());
        return doc;
    }

    public static AlarmFeedback toAlarmFeedback(FeedbackDocument doc) {
        return AlarmFeedback.newBuilder().withSituationKey(doc.situationKey).withSituationFingerprint(doc.situationFingerprint).withAlarmKey(doc.alarmKey).withFeedbackType(AlarmFeedback.FeedbackType.valueOfOrUnknown((String)doc.feedbackType)).withReason(doc.reason).withRootCause(doc.isRootCause).withUser(doc.user).withTags(doc.tags).withTimestamp(doc.timestamp).build();
    }
}

