/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.utils;

import java.util.Objects;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.features.apilayer.utils.NodeCriteriaCache;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.model.NodeCriteria;
import org.opennms.integration.api.v1.model.TopologyEdge;
import org.opennms.integration.api.v1.model.TopologyPort;
import org.opennms.integration.api.v1.model.TopologySegment;
import org.opennms.integration.api.v1.model.immutables.ImmutableNode;
import org.opennms.integration.api.v1.model.immutables.ImmutableNodeCriteria;
import org.opennms.integration.api.v1.model.immutables.ImmutableTopologyEdge;
import org.opennms.integration.api.v1.model.immutables.ImmutableTopologyPort;
import org.opennms.integration.api.v1.model.immutables.ImmutableTopologySegment;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;

public class EdgeMapper {
    private final NodeCriteriaCache nodeCriteriaCache;

    public EdgeMapper(NodeCriteriaCache nodeCriteriaCache) {
        this.nodeCriteriaCache = Objects.requireNonNull(nodeCriteriaCache);
    }

    public TopologyEdge toEdge(OnmsTopologyProtocol protocol, OnmsTopologyEdge edge) {
        ImmutableTopologyEdge.Builder topologyEdge = ImmutableTopologyEdge.newBuilder().setId(edge.getId()).setProtocol(ModelMappers.toTopologyProtocol(protocol)).setTooltipText(edge.getToolTipText());
        if (edge.getSource().getVertex().getNodeid() == null) {
            topologyEdge.setSource(this.getSegment(edge.getSource(), protocol));
        } else if (edge.getSource().getIfindex() != null && edge.getSource().getIfindex() >= 0) {
            topologyEdge.setSource(this.getPort(edge.getSource()));
        } else {
            topologyEdge.setSource(this.getNode(edge.getSource()));
        }
        if (edge.getTarget().getVertex().getNodeid() == null) {
            topologyEdge.setTarget(this.getSegment(edge.getTarget(), protocol));
        } else if (edge.getTarget().getIfindex() != null && edge.getTarget().getIfindex() >= 0) {
            topologyEdge.setTarget(this.getPort(edge.getTarget()));
        } else {
            topologyEdge.setTarget(this.getNode(edge.getTarget()));
        }
        return topologyEdge.build();
    }

    private TopologySegment getSegment(OnmsTopologyPort port, OnmsTopologyProtocol protocol) {
        return ImmutableTopologySegment.newBuilder().setId(port.getId()).setTooltipText(port.getToolTipText()).setProtocol(ModelMappers.toTopologyProtocol(protocol)).build();
    }

    private TopologyPort getPort(OnmsTopologyPort port) {
        ImmutableTopologyPort.Builder portBuilder = ImmutableTopologyPort.newBuilder().setId(port.getId()).setTooltipText(port.getToolTipText()).setIfIndex(port.getIfindex()).setIfName(port.getIfname()).setIfAddress(port.getAddr());
        Integer nodeId = port.getVertex().getNodeid();
        ImmutableNodeCriteria.Builder nodeCriteriaBuilder = ImmutableNodeCriteria.newBuilder().setId(nodeId);
        this.nodeCriteriaCache.getNodeCriteria(nodeId.longValue()).ifPresent(nc -> {
            nodeCriteriaBuilder.setForeignSource(nc.getForeignSource());
            nodeCriteriaBuilder.setForeignId(nc.getForeignId());
        });
        portBuilder.setNodeCriteria((NodeCriteria)nodeCriteriaBuilder.build());
        return portBuilder.build();
    }

    private Node getNode(OnmsTopologyPort port) {
        Integer nodeId = port.getVertex().getNodeid();
        ImmutableNode.Builder nodeBuilder = ImmutableNode.newBuilder().setId(nodeId.intValue());
        this.nodeCriteriaCache.getNodeCriteria(nodeId.longValue()).ifPresent(nc -> {
            nodeBuilder.setForeignSource(nc.getForeignSource());
            nodeBuilder.setForeignId(nc.getForeignId());
        });
        return nodeBuilder.build();
    }
}

