/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Win32ServiceDetector
extends SnmpDetector {
    private static final Logger LOG = LoggerFactory.getLogger(Win32ServiceDetector.class);
    private static final String SV_SVC_OPERATING_STATE_OID = ".1.3.6.1.4.1.77.1.2.3.1.3";
    private static final String DEFAULT_SERVICE_NAME = "Win32Service";
    private String m_win32SvcName;

    public Win32ServiceDetector() {
        this.setServiceName(DEFAULT_SERVICE_NAME);
        this.setVbvalue("1");
    }

    public String getWin32ServiceName() {
        return this.m_win32SvcName;
    }

    public void setWin32ServiceName(String serviceName) {
        this.m_win32SvcName = serviceName;
        LOG.debug("setWin32ServiceName: setting service name to {}", (Object)serviceName);
        int snLength = serviceName.length();
        StringBuilder serviceOidBuf = new StringBuilder(SV_SVC_OPERATING_STATE_OID);
        serviceOidBuf.append(".").append(Integer.toString(snLength));
        for (byte thisByte : serviceName.getBytes()) {
            serviceOidBuf.append(".").append(Byte.toString(thisByte));
        }
        LOG.debug("setWin32ServiceName: the OID for the Win32 service  is {}", (Object)serviceOidBuf.toString());
        this.setOid(serviceOidBuf.toString());
    }
}

