/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.shell;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.features.scv.shell.AliasCompleter;

@Command(scope="opennms", name="scv-validate", description="validate credentials for the given alias.")
@Service
public class ScvValidateCommand
implements Action {
    @Reference
    public SecureCredentialsVault secureCredentialsVault;
    @Option(name="-u", aliases={"--username"}, description="Username to validate.", required=true, multiValued=false)
    public String username = null;
    @Option(name="-p", aliases={"--password"}, description="Password to validate.", required=true, multiValued=false, censor=true, mask=42)
    public String password = null;
    @Argument(index=0, name="alias", description="Alias used to retrieve the credentials.", required=true, multiValued=false)
    @Completion(value=AliasCompleter.class)
    public String alias = null;

    public Object execute() throws Exception {
        Credentials credentials = this.secureCredentialsVault.getCredentials(this.alias);
        if (credentials == null) {
            System.out.println("No credentials found for Alias '" + this.alias + "'.");
        } else if (credentials.getUsername() != null && credentials.getPassword() != null && credentials.getUsername().equals(this.username) && credentials.getPassword().equals(this.password)) {
            System.out.printf("Found valid credentials for Alias %s, Username: %s, Password: ******\n", this.alias, this.username);
        } else if (credentials.getAttribute(this.username) != null && credentials.getAttribute(this.username).equals(this.password)) {
            System.out.printf("Found valid credentials for Alias %s, Attribute Key: %s, Attribute Value: ******\n", this.alias, this.username);
        } else {
            System.out.printf("No valid credentials found for Alias %s, Username: %s and Password: ****** \n", this.alias, this.username);
        }
        return null;
    }
}

