/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlBuilder {
    private static final Log logger = LogFactory.getLog(HtmlBuilder.class);
    private Writer writer;

    public HtmlBuilder() {
        this.writer = new StringWriter();
    }

    public HtmlBuilder(Writer writer) {
        this.writer = writer;
    }

    public void flushBuilder() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            logger.error((Object)"failed to flush HTML string builder", (Throwable)e);
        }
    }

    public void closeBuilder() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            logger.error((Object)"failed to close HTML string builder", (Throwable)e);
        }
    }

    private HtmlBuilder write(String text) {
        try {
            this.writer.write(text);
        }
        catch (IOException e) {
            logger.error((Object)"failed to write to HTML string builder", (Throwable)e);
        }
        return this;
    }

    public int length() {
        return this.writer.toString().length();
    }

    public HtmlBuilder append(Object text) {
        if (text != null) {
            this.write(text.toString());
        }
        return this;
    }

    public HtmlBuilder append(String text) {
        this.write(text);
        return this;
    }

    public HtmlBuilder format(int tabs, int newlines) {
        this.tabs(tabs);
        this.newlines(newlines);
        return this;
    }

    public HtmlBuilder tabs(int tabs) {
        for (int i = 0; i < tabs; ++i) {
            this.tab();
        }
        return this;
    }

    public HtmlBuilder newlines(int newlines) {
        for (int i = 0; i < newlines; ++i) {
            this.newline();
        }
        return this;
    }

    public HtmlBuilder tab() {
        this.write("\t");
        return this;
    }

    public HtmlBuilder newline() {
        this.write("\n");
        return this;
    }

    public HtmlBuilder close() {
        this.write(">");
        return this;
    }

    public HtmlBuilder xclose() {
        this.write("/>");
        return this;
    }

    public HtmlBuilder table(int tabs) {
        this.newline();
        this.tabs(tabs);
        this.write("<table");
        return this;
    }

    public HtmlBuilder tableEnd(int tabs) {
        this.newline();
        this.tabs(tabs);
        this.write("</table>");
        return this;
    }

    public HtmlBuilder button() {
        this.write("<button");
        return this;
    }

    public HtmlBuilder buttonEnd() {
        this.write("</button>");
        return this;
    }

    public HtmlBuilder tr(int tabs) {
        this.newline();
        this.tabs(tabs);
        this.write("<tr");
        return this;
    }

    public HtmlBuilder trEnd(int tabs) {
        this.newline();
        this.tabs(tabs);
        this.write("</tr>");
        return this;
    }

    public HtmlBuilder th(int tabs) {
        this.newline();
        this.tabs(tabs);
        this.write("<th");
        return this;
    }

    public HtmlBuilder thEnd() {
        this.write("</th>");
        return this;
    }

    public HtmlBuilder td(int tabs) {
        this.newline();
        this.tabs(tabs);
        this.write("<td");
        return this;
    }

    public HtmlBuilder tdEnd() {
        this.write("</td>");
        return this;
    }

    public HtmlBuilder input() {
        this.write("<input");
        return this;
    }

    public HtmlBuilder type(String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            this.write(" type=\"").write(type).write("\" ");
        }
        return this;
    }

    public HtmlBuilder input(String type) {
        this.write("<input type=\"").write(type).write("\" ");
        return this;
    }

    public HtmlBuilder select() {
        this.write("<select");
        return this;
    }

    public HtmlBuilder selectEnd() {
        this.write("</select>");
        return this;
    }

    public HtmlBuilder option() {
        this.write("<option");
        return this;
    }

    public HtmlBuilder optionEnd() {
        this.write("</option>");
        return this;
    }

    public HtmlBuilder form() {
        this.newline();
        this.write("<form");
        return this;
    }

    public HtmlBuilder formEnd() {
        this.newline();
        this.write("</form>");
        return this;
    }

    public HtmlBuilder name(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            this.write(" name=\"").write(name).write("\" ");
        }
        return this;
    }

    public HtmlBuilder value(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.write(" value=\"").write(value).write("\" ");
        } else {
            this.write(" value=\"").write("\" ");
        }
        return this;
    }

    public HtmlBuilder title(String title) {
        if (StringUtils.isNotBlank((CharSequence)title)) {
            this.write(" title=\"").write(title).write("\" ");
        }
        return this;
    }

    public HtmlBuilder action(String action) {
        this.write(" action=\"");
        if (StringUtils.isNotBlank((CharSequence)action)) {
            this.write(action);
        }
        this.write("\" ");
        return this;
    }

    public HtmlBuilder method(String method) {
        if (StringUtils.isNotBlank((CharSequence)method)) {
            this.write(" method=\"").write(method).write("\" ");
        }
        return this;
    }

    public HtmlBuilder enctype(String enctype) {
        if (StringUtils.isNotBlank((CharSequence)enctype)) {
            this.write(" enctype=\"").write(enctype).write("\" ");
        }
        return this;
    }

    public HtmlBuilder onchange(String onchange) {
        if (StringUtils.isNotBlank((CharSequence)onchange)) {
            this.write(" onchange=\"").write(onchange).write("\" ");
        }
        return this;
    }

    public HtmlBuilder onsubmit(String onsubmit) {
        if (StringUtils.isNotBlank((CharSequence)onsubmit)) {
            this.write(" onsubmit=\"").write(onsubmit).write("\" ");
        }
        return this;
    }

    public HtmlBuilder onclick(String onclick) {
        if (StringUtils.isNotBlank((CharSequence)onclick)) {
            this.write(" onclick=\"").write(onclick).write("\" ");
        }
        return this;
    }

    public HtmlBuilder onmouseover(String onmouseover) {
        if (StringUtils.isNotBlank((CharSequence)onmouseover)) {
            this.write(" onmouseover=\"").write(onmouseover).write("\" ");
        }
        return this;
    }

    public HtmlBuilder onmouseout(String onmouseout) {
        if (StringUtils.isNotBlank((CharSequence)onmouseout)) {
            this.write(" onmouseout=\"").write(onmouseout).write("\" ");
        }
        return this;
    }

    public HtmlBuilder onkeypress(String onkeypress) {
        if (StringUtils.isNotBlank((CharSequence)onkeypress)) {
            this.write(" onkeypress=\"").write(onkeypress).write("\" ");
        }
        return this;
    }

    public HtmlBuilder id(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.write(" id=\"").write(id).write("\" ");
        }
        return this;
    }

    public HtmlBuilder styleClass(String styleClass) {
        if (StringUtils.isNotBlank((CharSequence)styleClass)) {
            this.write(" class=\"").write(styleClass).write("\" ");
        }
        return this;
    }

    public HtmlBuilder style(String style) {
        if (StringUtils.isNotBlank((CharSequence)style)) {
            this.write(" style=\"").write(style).write("\" ");
        }
        return this;
    }

    public HtmlBuilder width(String width) {
        if (StringUtils.isNotBlank((CharSequence)width)) {
            this.write(" width=\"").write(width).write("\" ");
        }
        return this;
    }

    public HtmlBuilder align(String align) {
        if (StringUtils.isNotBlank((CharSequence)align)) {
            this.write(" align=\"").write(align).write("\" ");
        }
        return this;
    }

    public HtmlBuilder valign(String valign) {
        if (StringUtils.isNotBlank((CharSequence)valign)) {
            this.write(" valign=\"").write(valign).write("\" ");
        }
        return this;
    }

    public HtmlBuilder border(String border) {
        if (StringUtils.isNotBlank((CharSequence)border)) {
            this.write(" border=\"").write(border).write("\" ");
        }
        return this;
    }

    public HtmlBuilder cellPadding(String cellPadding) {
        if (StringUtils.isNotBlank((CharSequence)cellPadding)) {
            this.write(" cellpadding=\"").write(cellPadding).write("\" ");
        }
        return this;
    }

    public HtmlBuilder cellSpacing(String cellSpacing) {
        if (StringUtils.isNotBlank((CharSequence)cellSpacing)) {
            this.write(" cellspacing=\"").write(cellSpacing).write("\" ");
        }
        return this;
    }

    public HtmlBuilder colSpan(String colspan) {
        if (StringUtils.isNotBlank((CharSequence)colspan)) {
            this.write(" colspan=\"").write(colspan).write("\" ");
        }
        return this;
    }

    public HtmlBuilder rowSpan(String rowspan) {
        if (StringUtils.isNotBlank((CharSequence)rowspan)) {
            this.write(" rowspan=\"").write(rowspan).write("\" ");
        }
        return this;
    }

    public HtmlBuilder size(String size) {
        if (StringUtils.isNotBlank((CharSequence)size)) {
            this.write(" size=\"").write(size).write("\" ");
        }
        return this;
    }

    public HtmlBuilder span() {
        this.write("<span");
        return this;
    }

    public HtmlBuilder spanEnd() {
        this.write("</span>");
        return this;
    }

    public HtmlBuilder div() {
        this.write("<div");
        return this;
    }

    public HtmlBuilder divEnd() {
        this.write("</div>");
        return this;
    }

    public HtmlBuilder param(String name, String value) {
        this.append(name);
        this.equals();
        this.append(value);
        return this;
    }

    public HtmlBuilder a(String href) {
        this.append("<a href=");
        this.quote();
        this.append(href);
        this.quote();
        return this;
    }

    public HtmlBuilder a() {
        this.write("<a href=");
        return this;
    }

    public HtmlBuilder aEnd() {
        this.write("</a>");
        return this;
    }

    public HtmlBuilder bold() {
        this.write("<b>");
        return this;
    }

    public HtmlBuilder boldEnd() {
        this.write("</b>");
        return this;
    }

    public HtmlBuilder quote() {
        this.write("\"");
        return this;
    }

    public HtmlBuilder question() {
        this.write("?");
        return this;
    }

    public HtmlBuilder equals() {
        this.write("=");
        return this;
    }

    public HtmlBuilder ampersand() {
        this.write("&");
        return this;
    }

    public HtmlBuilder img() {
        this.write("<img");
        return this;
    }

    public HtmlBuilder src(String src) {
        if (StringUtils.isNotBlank((CharSequence)src)) {
            this.write(" src=\"").write(src).write("\" ");
        }
        return this;
    }

    public HtmlBuilder alt(String alt) {
        if (StringUtils.isNotBlank((CharSequence)alt)) {
            this.write(" alt=\"").write(alt).write("\" ");
        }
        return this;
    }

    public HtmlBuilder img(String src) {
        this.write("<img src=\"").write(src).write("\" style=\"border:0\"/> ");
        return this;
    }

    public HtmlBuilder img(String img, String tooltip) {
        this.write("<img src=\"").write(img).write("\" style=\"border:0\"");
        if (tooltip != null) {
            this.write(" title=\"").write(tooltip).write("\">");
        }
        return this;
    }

    public HtmlBuilder textarea() {
        this.write("<textarea");
        return this;
    }

    public HtmlBuilder textareaEnd() {
        this.write("</textarea>");
        return this;
    }

    public HtmlBuilder cols(String cols) {
        if (StringUtils.isNotBlank((CharSequence)cols)) {
            this.write(" cols=\"").write(cols).write("\" ");
        }
        return this;
    }

    public HtmlBuilder rows(String rows) {
        if (StringUtils.isNotBlank((CharSequence)rows)) {
            this.write(" rows=\"").write(rows).write("\" ");
        }
        return this;
    }

    public HtmlBuilder checked() {
        this.write(" checked=\"checked\"");
        return this;
    }

    public HtmlBuilder selected() {
        this.write(" selected=\"selected\"");
        return this;
    }

    public HtmlBuilder readonly() {
        this.write(" readonly=\"readonly\"");
        return this;
    }

    public HtmlBuilder nbsp() {
        this.write("&#160;");
        return this;
    }

    public HtmlBuilder comment(String comment) {
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            this.write(" <!-- ").write(comment).write(" -->");
        }
        return this;
    }

    public HtmlBuilder ul() {
        this.write("<ul>");
        return this;
    }

    public HtmlBuilder ulEnd() {
        this.write("</ul>");
        return this;
    }

    public HtmlBuilder li(String text) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            this.write("<li>").write(text).write("</li>");
        }
        return this;
    }

    public HtmlBuilder br() {
        this.write("<br/>");
        return this;
    }

    public HtmlBuilder disabled() {
        this.write(" disabled=\"disabled\" ");
        return this;
    }

    public HtmlBuilder nowrap() {
        this.write(" nowrap=\"nowrap\" ");
        return this;
    }

    public HtmlBuilder maxlength(String maxlength) {
        if (StringUtils.isNotBlank((CharSequence)maxlength)) {
            this.write(" maxlength=\"").write(maxlength).write("\" ");
        }
        return this;
    }

    public HtmlBuilder tbody(int tabs) {
        this.newline();
        this.tabs(tabs);
        this.write("<tbody");
        return this;
    }

    public HtmlBuilder tbodyEnd(int tabs) {
        this.newline();
        this.tabs(tabs);
        this.write("</tbody>");
        return this;
    }

    public HtmlBuilder thead(int tabs) {
        this.newline();
        this.tabs(tabs);
        this.write("<thead");
        return this;
    }

    public HtmlBuilder theadEnd(int tabs) {
        this.newline();
        this.tabs(tabs);
        this.write("</thead>");
        return this;
    }

    public HtmlBuilder p() {
        this.write("<p");
        return this;
    }

    public HtmlBuilder pEnd() {
        this.write("</p>");
        return this;
    }

    public HtmlBuilder h1() {
        this.write("<h1");
        return this;
    }

    public HtmlBuilder h1End() {
        this.write("</h1>");
        return this;
    }

    public HtmlBuilder h2() {
        this.write("<h2");
        return this;
    }

    public HtmlBuilder h2End() {
        this.write("</h2>");
        return this;
    }

    public HtmlBuilder h3() {
        this.write("<h3");
        return this;
    }

    public HtmlBuilder h3End() {
        this.write("</h3>");
        return this;
    }

    public HtmlBuilder h4() {
        this.write("<h4");
        return this;
    }

    public HtmlBuilder h4End() {
        this.write("</h4>");
        return this;
    }

    public HtmlBuilder h5() {
        this.write("<h5");
        return this;
    }

    public HtmlBuilder h5End() {
        this.write("</h5>");
        return this;
    }

    public String toString() {
        return this.writer.toString();
    }
}

