/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view;

import java.util.List;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.bean.Export;
import org.extremecomponents.table.calc.CalcResult;
import org.extremecomponents.table.calc.CalcUtils;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.ExportViewUtils;
import org.extremecomponents.table.view.View;
import org.extremecomponents.util.ExtremeUtils;

public class PdfView
implements View {
    public static final String FONT = "exportPdf.font";
    public static final String HEADER_BACKGROUND_COLOR = "headerBackgroundColor";
    public static final String HEADER_TITLE = "headerTitle";
    public static final String HEADER_COLOR = "headerColor";
    private StringBuffer xlsfo = new StringBuffer();
    private String viewFont;

    @Override
    public void beforeBody(TableModel model) {
        this.viewFont = model.getPreferences().getPreference(FONT);
        this.xlsfo.append(this.startRoot());
        this.xlsfo.append(this.regionBefore(model));
        this.xlsfo.append(this.regionAfter());
        this.xlsfo.append(this.columnDefinitions(model));
        this.xlsfo.append(this.header(model));
        this.xlsfo.append(" <fo:table-body> ");
    }

    @Override
    public void body(TableModel model, Column column) {
        if (column.isFirstColumn()) {
            this.xlsfo.append(" <fo:table-row> ");
        }
        String value = ExportViewUtils.parsePDF(column.getCellDisplay());
        this.xlsfo.append(" <fo:table-cell border=\"solid silver .5px\" display-align=\"center\" padding=\"3pt\"> ");
        this.xlsfo.append(" <fo:block" + this.getFont() + ">" + value + "</fo:block> ");
        this.xlsfo.append(" </fo:table-cell> ");
        if (column.isLastColumn()) {
            this.xlsfo.append(" </fo:table-row> ");
        }
    }

    @Override
    public Object afterBody(TableModel model) {
        if (model.getLimit().getTotalRows() != 0) {
            this.xlsfo.append(this.totals(model));
        }
        this.xlsfo.append(" </fo:table-body> ");
        this.xlsfo.append(this.endRoot());
        return this.xlsfo.toString();
    }

    public String startRoot() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">");
        sb.append(" <fo:layout-master-set> ");
        sb.append(" <fo:simple-page-master master-name=\"simple\" ");
        sb.append(" page-height=\"8.5in\" ");
        sb.append(" page-width=\"11in\" ");
        sb.append(" margin-top=\".5in\" ");
        sb.append(" margin-bottom=\".25in\" ");
        sb.append(" margin-left=\".5in\" ");
        sb.append(" margin-right=\".5in\"> ");
        sb.append(" <fo:region-body margin-top=\".5in\" margin-bottom=\".25in\"/> ");
        sb.append(" <fo:region-before extent=\".5in\"/> ");
        sb.append(" <fo:region-after extent=\".25in\"/> ");
        sb.append(" </fo:simple-page-master> ");
        sb.append(" </fo:layout-master-set> ");
        sb.append(" <fo:page-sequence master-reference=\"simple\" initial-page-number=\"1\"> ");
        return sb.toString();
    }

    public String regionBefore(TableModel model) {
        StringBuffer sb = new StringBuffer();
        Export export = model.getExportHandler().getCurrentExport();
        String headerBackgroundColor = export.getAttributeAsString(HEADER_BACKGROUND_COLOR);
        sb.append(" <fo:static-content flow-name=\"xsl-region-before\"> ");
        String title = export.getAttributeAsString(HEADER_TITLE);
        sb.append(" <fo:block space-after.optimum=\"15pt\" color=\"" + headerBackgroundColor + "\" font-size=\"17pt\" font-family=\"" + this.getHeadFont() + "'Times'\">" + title + "</fo:block> ");
        sb.append(" </fo:static-content> ");
        return sb.toString();
    }

    public String regionAfter() {
        StringBuffer sb = new StringBuffer();
        sb.append(" <fo:static-content flow-name=\"xsl-region-after\" display-align=\"after\"> ");
        sb.append(" <fo:block text-align=\"end\">Page <fo:page-number/></fo:block> ");
        sb.append(" </fo:static-content> ");
        return sb.toString();
    }

    public String columnDefinitions(TableModel model) {
        StringBuffer sb = new StringBuffer();
        sb.append(" <fo:flow flow-name=\"xsl-region-body\"> ");
        sb.append(" <fo:block" + this.getFont() + ">");
        sb.append(" <fo:table table-layout=\"fixed\" font-size=\"10pt\"> ");
        double columnCount = model.getColumnHandler().columnCount();
        double colwidth = 10.0 / columnCount;
        int i = 1;
        while ((double)i <= columnCount) {
            sb.append(" <fo:table-column column-number=\"" + i + "\" column-width=\"" + colwidth + "in\"/> ");
            ++i;
        }
        return sb.toString();
    }

    public String header(TableModel model) {
        StringBuffer sb = new StringBuffer();
        Export export = model.getExportHandler().getCurrentExport();
        String headerColor = export.getAttributeAsString(HEADER_COLOR);
        String headerBackgroundColor = export.getAttributeAsString(HEADER_BACKGROUND_COLOR);
        sb.append(" <fo:table-header background-color=\"" + headerBackgroundColor + "\" color=\"" + headerColor + "\"> ");
        sb.append(" <fo:table-row> ");
        List<Column> columns = model.getColumnHandler().getHeaderColumns();
        for (Column column : columns) {
            String title = column.getCellDisplay();
            sb.append(" <fo:table-cell border=\"solid silver .5px\" text-align=\"center\" display-align=\"center\" padding=\"3pt\"> ");
            sb.append(" <fo:block" + this.getFont() + ">" + title + "</fo:block> ");
            sb.append(" </fo:table-cell> ");
        }
        sb.append(" </fo:table-row> ");
        sb.append(" </fo:table-header> ");
        return sb.toString();
    }

    public String endRoot() {
        StringBuffer sb = new StringBuffer();
        sb.append(" </fo:table> ");
        sb.append(" </fo:block> ");
        sb.append(" </fo:flow> ");
        sb.append(" </fo:page-sequence> ");
        sb.append(" </fo:root> ");
        return sb.toString();
    }

    protected String getFont() {
        return this.viewFont == null ? "" : " font-family=\"" + this.viewFont + "\"";
    }

    protected String getHeadFont() {
        return this.viewFont == null ? "" : this.viewFont + ",";
    }

    public StringBuffer totals(TableModel model) {
        StringBuffer sb = new StringBuffer();
        Export export = model.getExportHandler().getCurrentExport();
        String headerColor = export.getAttributeAsString(HEADER_COLOR);
        String headerBackgroundColor = export.getAttributeAsString(HEADER_BACKGROUND_COLOR);
        Column firstCalcColumn = model.getColumnHandler().getFirstCalcColumn();
        if (firstCalcColumn != null) {
            int rows = firstCalcColumn.getCalc().length;
            for (int i = 0; i < rows; ++i) {
                sb.append("<fo:table-row>");
                for (Column column : model.getColumnHandler().getColumns()) {
                    if (column.isFirstColumn()) {
                        String calcTitle = CalcUtils.getFirstCalcColumnTitleByPosition(model, i);
                        sb.append(" <fo:table-cell border=\"solid silver .5px\" text-align=\"center\" display-align=\"center\" padding=\"3pt\" background-color=\"");
                        sb.append(headerBackgroundColor + "\" color=\"" + headerColor + "\">");
                        sb.append(" <fo:block " + this.getFont() + ">" + calcTitle);
                        sb.append(" </fo:block></fo:table-cell> ");
                        continue;
                    }
                    if (column.isCalculated()) {
                        sb.append(" <fo:table-cell border=\"solid silver .5px\" text-align=\"center\" display-align=\"center\" padding=\"3pt\" background-color=\"");
                        sb.append(headerBackgroundColor + "\" color=\"" + headerColor + "\"> ");
                        sb.append(" <fo:block " + this.getFont() + ">");
                        CalcResult calcResult = CalcUtils.getCalcResultsByPosition(model, column, i);
                        Number value = calcResult.getValue();
                        if (value != null) {
                            sb.append(ExtremeUtils.formatNumber(column.getFormat(), value, model.getLocale()));
                        } else {
                            sb.append("n/a");
                        }
                        sb.append("</fo:block> ");
                    } else {
                        sb.append(" <fo:table-cell border=\"solid silver .5px\" text-align=\"center\" display-align=\"center\" padding=\"3pt\" background-color=\"");
                        sb.append(headerBackgroundColor + "\" color=\"" + headerColor + "\"> ");
                        sb.append(" <fo:block " + this.getFont() + ">");
                        sb.append(" ");
                        sb.append("</fo:block> ");
                    }
                    sb.append(" </fo:table-cell> ");
                }
                sb.append("</fo:table-row>");
            }
        }
        return sb;
    }
}

