/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.cell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.comparators.NullComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.cell.Cell;
import org.extremecomponents.table.cell.FilterOption;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.html.TableActions;
import org.extremecomponents.util.ExtremeUtils;
import org.extremecomponents.util.HtmlBuilder;

public class FilterDroplistCell
implements Cell {
    private static Log logger = LogFactory.getLog(FilterDroplistCell.class);

    @Override
    public String getExportDisplay(TableModel model, Column column) {
        return null;
    }

    @Override
    public String getHtmlDisplay(TableModel model, Column column) {
        HtmlBuilder html = new HtmlBuilder();
        if (!column.isFilterable()) {
            html.append("");
        } else {
            Collection filterOptions = column.getFilterOptions();
            if (filterOptions == null || filterOptions.isEmpty()) {
                filterOptions = this.getFilterDropList(model, column);
            }
            html.append(this.dropListHtml(model, column, filterOptions));
        }
        return html.toString();
    }

    protected Collection getFilterDropList(TableModel model, Column column) {
        ArrayList<Option> droplist = new ArrayList<Option>();
        HashSet<Object> options = new HashSet<Object>();
        Collection beans = model.getCollectionOfBeans();
        for (Object bean : beans) {
            try {
                Object obj = this.getFilterOption(column, bean);
                if (obj == null || options.contains(obj)) continue;
                droplist.add(new Option(obj));
                options.add(obj);
            }
            catch (Exception e) {
                logger.debug((Object)"Problems getting the droplist.", (Throwable)e);
            }
        }
        BeanComparator comparator = new BeanComparator("label", (Comparator)new NullComparator());
        Collections.sort(droplist, comparator);
        return droplist;
    }

    protected Object getFilterOption(Column column, Object bean) throws Exception {
        return PropertyUtils.getProperty((Object)bean, (String)column.getProperty());
    }

    protected String dropListHtml(TableModel model, Column column, Collection droplist) {
        HtmlBuilder html = new HtmlBuilder();
        html.td(2).close();
        html.newline();
        html.tabs(2);
        html.select().name(model.getTableHandler().prefixWithTableId() + "f_" + column.getAlias());
        StringBuffer onkeypress = new StringBuffer();
        onkeypress.append(new TableActions(model).getFilterAction());
        html.onchange(onkeypress.toString());
        html.close();
        html.newline();
        html.tabs(2);
        html.option().value("").close();
        html.optionEnd();
        Locale locale = model.getLocale();
        for (FilterOption filterOption : droplist) {
            String value = String.valueOf(filterOption.getValue());
            String label = String.valueOf(filterOption.getLabel());
            if (column.isDate()) {
                value = ExtremeUtils.formatDate(column.getParse(), column.getFormat(), filterOption.getValue(), locale);
            }
            html.newline();
            html.tabs(2);
            html.option().value(value);
            if (value.equals(column.getValueAsString())) {
                html.selected();
            }
            html.close();
            html.append(label);
            html.optionEnd();
        }
        html.newline();
        html.tabs(2);
        html.selectEnd();
        html.tdEnd();
        return html.toString();
    }

    protected static class Option
    implements FilterOption {
        private final Object label;
        private final Object value;

        public Option(Object obj) {
            this.label = obj;
            this.value = obj;
        }

        public Option(Object label, Object value) {
            this.label = label;
            this.value = value;
        }

        @Override
        public Object getLabel() {
            return this.label;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

