/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow5.proto;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Objects;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.BooleanValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.IPv4AddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UnsignedValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow5.proto.Packet;

public class Record {
    public static final int SIZE = 48;
    public final Packet packet;
    public final Inet4Address srcAddr;
    public final Inet4Address dstAddr;
    public final Inet4Address nextHop;
    public final int input;
    public final int output;
    public final long dPkts;
    public final long dOctets;
    public final long first;
    public final long last;
    public final int srcPort;
    public final int dstPort;
    public final int tcpFlags;
    public final int proto;
    public final int srcAs;
    public final int dstAs;
    public final int tos;
    public final int srcMask;
    public final int dstMask;
    public final boolean egress;

    public Record(Packet packet, ByteBuf buffer) throws InvalidPacketException {
        this.packet = Objects.requireNonNull(packet);
        this.srcAddr = Record.parseAddress(buffer);
        this.dstAddr = Record.parseAddress(buffer);
        this.nextHop = Record.parseAddress(buffer);
        this.input = BufferUtils.uint16((ByteBuf)buffer);
        this.output = BufferUtils.uint16((ByteBuf)buffer);
        this.dPkts = BufferUtils.uint32((ByteBuf)buffer);
        this.dOctets = BufferUtils.uint32((ByteBuf)buffer);
        this.first = BufferUtils.uint32((ByteBuf)buffer);
        this.last = BufferUtils.uint32((ByteBuf)buffer);
        this.srcPort = BufferUtils.uint16((ByteBuf)buffer);
        this.dstPort = BufferUtils.uint16((ByteBuf)buffer);
        int padding1 = BufferUtils.uint8((ByteBuf)buffer);
        this.tcpFlags = BufferUtils.uint8((ByteBuf)buffer);
        this.proto = BufferUtils.uint8((ByteBuf)buffer);
        this.tos = BufferUtils.uint8((ByteBuf)buffer);
        this.srcAs = BufferUtils.uint16((ByteBuf)buffer);
        this.dstAs = BufferUtils.uint16((ByteBuf)buffer);
        this.srcMask = BufferUtils.uint8((ByteBuf)buffer);
        this.dstMask = BufferUtils.uint8((ByteBuf)buffer);
        int padding2 = BufferUtils.uint16((ByteBuf)buffer);
        this.egress = padding2 == 8;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("srcAddr", (Object)this.srcAddr).add("dstAddr", (Object)this.dstAddr).add("nextHop", (Object)this.nextHop).add("input", this.input).add("output", this.output).add("dPkts", this.dPkts).add("dOctets", this.dOctets).add("first", this.first).add("last", this.last).add("srcPort", this.srcPort).add("dstPort", this.dstPort).add("tcpFlags", this.tcpFlags).add("proto", this.proto).add("srcAs", this.srcAs).add("dstAs", this.dstAs).add("tos", this.tos).add("srcMask", this.srcMask).add("dstMask", this.dstMask).add("egress", this.egress).toString();
    }

    private static Inet4Address parseAddress(ByteBuf buffer) throws InvalidPacketException {
        try {
            return (Inet4Address)Inet4Address.getByAddress(BufferUtils.bytes((ByteBuf)buffer, (int)4));
        }
        catch (UnknownHostException e) {
            throw new InvalidPacketException(buffer, "Error parsing IPv4 value", e);
        }
    }

    public Iterable<Value<?>> asValues() {
        return ImmutableList.builder().add((Object)new IPv4AddressValue("srcAddr", this.srcAddr)).add((Object)new IPv4AddressValue("dstAddr", this.dstAddr)).add((Object)new IPv4AddressValue("nextHop", this.nextHop)).add((Object)new UnsignedValue("input", this.input)).add((Object)new UnsignedValue("output", this.output)).add((Object)new UnsignedValue("dPkts", this.dPkts)).add((Object)new UnsignedValue("dOctets", this.dOctets)).add((Object)new UnsignedValue("first", this.first)).add((Object)new UnsignedValue("last", this.last)).add((Object)new UnsignedValue("srcPort", this.srcPort)).add((Object)new UnsignedValue("dstPort", this.dstPort)).add((Object)new UnsignedValue("tcpFlags", this.tcpFlags)).add((Object)new UnsignedValue("proto", this.proto)).add((Object)new UnsignedValue("srcAs", this.srcAs)).add((Object)new UnsignedValue("dstAs", this.dstAs)).add((Object)new UnsignedValue("tos", this.tos)).add((Object)new UnsignedValue("srcMask", this.srcMask)).add((Object)new UnsignedValue("dstMask", this.dstMask)).add((Object)new BooleanValue("egress", this.egress)).build();
    }
}

