/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow5.proto;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UnsignedValue;

public final class Header {
    public static final int SIZE = 24;
    public static final int VERSION = 5;
    public final int versionNumber;
    public final int count;
    public final long sysUptime;
    public final long unixSecs;
    public final long unixNSecs;
    public final long flowSequence;
    public final int engineType;
    public final int engineId;
    public final int samplingAlgorithm;
    public final int samplingInterval;

    public Header(ByteBuf buffer) throws InvalidPacketException {
        this.versionNumber = BufferUtils.uint16((ByteBuf)buffer);
        if (this.versionNumber != 5) {
            throw new InvalidPacketException(buffer, "Invalid version number: 0x%04X", this.versionNumber);
        }
        this.count = BufferUtils.uint16((ByteBuf)buffer);
        if (this.count < 1 || this.count > 30) {
            throw new InvalidPacketException(buffer, "Invalid record count: %d", this.count);
        }
        this.sysUptime = BufferUtils.uint32((ByteBuf)buffer);
        this.unixSecs = BufferUtils.uint32((ByteBuf)buffer);
        this.unixNSecs = BufferUtils.uint32((ByteBuf)buffer);
        this.flowSequence = BufferUtils.uint32((ByteBuf)buffer);
        this.engineType = BufferUtils.uint8((ByteBuf)buffer);
        this.engineId = BufferUtils.uint8((ByteBuf)buffer);
        int sampling = BufferUtils.uint16((ByteBuf)buffer);
        this.samplingAlgorithm = sampling >>> 14;
        this.samplingInterval = sampling & 0x3FFF;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("versionNumber", this.versionNumber).add("count", this.count).add("sysUptime", this.sysUptime).add("unixSecs", this.unixSecs).add("unixNSecs", this.unixNSecs).add("flowSequence", this.flowSequence).add("engineType", this.engineType).add("engineId", this.engineId).add("samplingAlgorithm", this.samplingAlgorithm).add("samplingInterval", this.samplingInterval).toString();
    }

    public Iterable<Value<?>> asValues() {
        return ImmutableList.builder().add((Object)new UnsignedValue("@versionNumber", this.versionNumber)).add((Object)new UnsignedValue("@count", this.count)).add((Object)new UnsignedValue("@sysUptime", this.sysUptime)).add((Object)new UnsignedValue("@unixSecs", this.unixSecs)).add((Object)new UnsignedValue("@unixNSecs", this.unixNSecs)).add((Object)new UnsignedValue("@flowSequence", this.flowSequence)).add((Object)new UnsignedValue("@engineType", this.engineType)).add((Object)new UnsignedValue("@engineId", this.engineId)).add((Object)new UnsignedValue("@samplingAlgorithm", this.samplingAlgorithm)).add((Object)new UnsignedValue("@samplingInterval", this.samplingInterval)).build();
    }
}

