/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.XMPPNotificationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMPPGroupNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(XMPPGroupNotificationStrategy.class);
    private static final int XMPP_TO = 0;
    private static final int XMPP_MESSAGE = 1;
    private static final int XMPP_MAX = 2;
    private static final String[] INDEX_TO_NAME = new String[XMPP_MAX];

    public int send(List<Argument> arguments) {
        try {
            String[] parsedArgs = this.parseArguments(arguments);
            XMPPNotificationManager xmppManager = XMPPNotificationManager.getInstance();
            xmppManager.sendGroupChat(parsedArgs[XMPP_TO], parsedArgs[XMPP_MESSAGE]);
        }
        catch (Throwable e) {
            LOG.error(e.getMessage());
            return 1;
        }
        return 0;
    }

    private String[] parseArguments(List<Argument> arguments) throws Exception {
        int i;
        String[] parsedArgs = new String[XMPP_MAX];
        for (i = 0; i < arguments.size(); ++i) {
            Argument arg = arguments.get(i);
            if ("-xmpp".equals(arg.getSwitch())) {
                parsedArgs[XMPPGroupNotificationStrategy.XMPP_TO] = arg.getValue();
                continue;
            }
            if (!"-tm".equals(arg.getSwitch())) continue;
            parsedArgs[XMPPGroupNotificationStrategy.XMPP_MESSAGE] = arg.getValue();
        }
        for (i = 0; i < XMPP_MAX; ++i) {
            if (parsedArgs[i] != null) continue;
            throw new Exception("Incomplete argument set, missing argument: " + INDEX_TO_NAME[i]);
        }
        return parsedArgs;
    }

    static {
        XMPPGroupNotificationStrategy.INDEX_TO_NAME[XMPPGroupNotificationStrategy.XMPP_TO] = "To";
        XMPPGroupNotificationStrategy.INDEX_TO_NAME[XMPPGroupNotificationStrategy.XMPP_MESSAGE] = "Message";
    }
}

