/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import java.io.IOException;
import java.util.Properties;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import ndr.NdrBuffer;
import rpc.DefaultConnection;
import rpc.core.AuthenticationVerifier;
import rpc.security.ntlm.NtlmAuthentication;

public class NtlmConnection
extends DefaultConnection {
    private static int contextSerial;
    private final NtlmAuthentication authentication;
    protected Properties properties;
    private NtlmMessage ntlm;

    public NtlmConnection(Properties properties) {
        this.authentication = new NtlmAuthentication(properties);
        this.properties = properties;
    }

    public void setTransmitLength(int transmitLength) {
        this.transmitBuffer = new NdrBuffer(new byte[transmitLength], 0);
    }

    public void setReceiveLength(int receiveLength) {
        this.receiveBuffer = new NdrBuffer(new byte[receiveLength], 0);
    }

    @Override
    protected void incomingRebind(AuthenticationVerifier verifier) throws IOException {
        switch (verifier.body[8]) {
            case 1: {
                this.contextId = verifier.contextId;
                this.ntlm = new Type1Message(verifier.body);
                break;
            }
            case 2: {
                this.ntlm = new Type2Message(verifier.body);
                break;
            }
            case 3: {
                Type2Message type2 = (Type2Message)this.ntlm;
                this.ntlm = new Type3Message(verifier.body);
                boolean usentlmv2 = Boolean.valueOf(this.properties.getProperty("rpc.ntlm.ntlm2"));
                if (!usentlmv2) break;
                this.authentication.createSecurityWhenServer(this.ntlm);
                this.setSecurity(this.authentication.getSecurity());
                break;
            }
            default: {
                throw new IOException("Invalid NTLM message type.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AuthenticationVerifier outgoingRebind() throws IOException {
        if (this.ntlm == null) {
            Class<NtlmConnection> clazz = NtlmConnection.class;
            synchronized (NtlmConnection.class) {
                this.contextId = ++contextSerial;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.ntlm = this.authentication.createType1();
            }
        } else if (this.ntlm instanceof Type1Message) {
            this.ntlm = this.authentication.createType2((Type1Message)this.ntlm);
        } else if (this.ntlm instanceof Type2Message) {
            Type2Message type2 = (Type2Message)this.ntlm;
            this.ntlm = this.authentication.createType3(type2);
            boolean usentlmv2 = Boolean.valueOf(this.properties.getProperty("rpc.ntlm.ntlm2"));
            if (usentlmv2) {
                this.setSecurity(this.authentication.getSecurity());
            }
        } else {
            if (this.ntlm instanceof Type3Message) {
                return null;
            }
            throw new IOException("Unrecognized NTLM message.");
        }
        {
            int protectionLevel = this.ntlm.getFlag(32) ? 6 : (this.ntlm.getFlag(16) ? 5 : 2);
            return new AuthenticationVerifier(10, protectionLevel, this.contextId, this.ntlm.toByteArray());
        }
    }
}

