/*
 * Decompiled with CFR 0.152.
 */
package rpc.core;

import java.util.Objects;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;

public class Port
extends NdrObject {
    private String portSpec;

    public Port() {
        this(null);
    }

    public Port(String portSpec) {
        this.portSpec = portSpec;
    }

    @Override
    public void read(NetworkDataRepresentation ndr) {
        int length = ndr.readUnsignedShort();
        if (length > 0) {
            char[] portSpecChars = new char[length - 1];
            ndr.readCharacterArray(portSpecChars, 0, portSpecChars.length);
            ndr.readUnsignedSmall();
            this.portSpec = new String(portSpecChars);
        } else {
            this.portSpec = null;
        }
    }

    @Override
    public void write(NetworkDataRepresentation ndr) {
        char[] spec;
        if (this.portSpec != null) {
            spec = new char[this.portSpec.length() + 1];
            this.portSpec.getChars(0, this.portSpec.length(), spec, 0);
        } else {
            spec = new char[]{};
        }
        ndr.writeUnsignedShort(spec.length);
        if (spec.length > 0) {
            ndr.writeCharacterArray(spec, 0, spec.length);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.portSpec);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Port other = (Port)obj;
        return Objects.equals(this.portSpec, other.portSpec);
    }

    public String getPortSpec() {
        return this.portSpec;
    }
}

