/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="security")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="eventconf.xsd")
public class Security
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="doNotOverride", required=true)
    private List<String> m_doNotOverride = new ArrayList<String>();

    public List<String> getDoNotOverrides() {
        return this.m_doNotOverride;
    }

    public void setDoNotOverride(List<String> doNotOverride) {
        ConfigUtils.assertMinimumSize(doNotOverride, 1L, "doNotOverride");
        if (this.m_doNotOverride == doNotOverride) {
            return;
        }
        this.m_doNotOverride.clear();
        if (doNotOverride != null) {
            this.m_doNotOverride.addAll(doNotOverride);
        }
    }

    public void addDoNotOverride(String doNotOverride) {
        this.m_doNotOverride.add(doNotOverride);
    }

    public boolean removeDoNotOverride(String doNotOverride) {
        return this.m_doNotOverride.remove(doNotOverride);
    }

    public boolean isSecureTag(String tag) {
        return this.m_doNotOverride == null ? false : this.m_doNotOverride.contains(tag);
    }

    public int hashCode() {
        return Objects.hash(this.m_doNotOverride);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Security) {
            Security that = (Security)obj;
            return Objects.equals(this.m_doNotOverride, that.m_doNotOverride);
        }
        return false;
    }
}

