/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.EventMatcher;
import org.opennms.netmgt.xml.eventconf.EventOrdering;
import org.opennms.netmgt.xml.eventconf.Global;
import org.opennms.netmgt.xml.eventconf.Mask;
import org.opennms.netmgt.xml.eventconf.Maskelement;
import org.opennms.netmgt.xml.eventconf.Partition;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.StringUtils;

@XmlRootElement(name="events")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="eventconf.xsd")
@XmlType(propOrder={})
public class Events
implements Serializable {
    private static final DefaultResourceLoader RESOURCE_LOADER = new DefaultResourceLoader();
    private static final long serialVersionUID = 2L;
    @XmlElement(name="global", required=false)
    private Global m_global;
    @XmlElement(name="event", required=false)
    private List<Event> m_events = new ArrayList<Event>();
    @XmlElement(name="event-file", required=false)
    private List<String> m_eventFiles = new ArrayList<String>();
    @XmlTransient
    private Map<String, Events> m_loadedEventFiles = new LinkedHashMap<String, Events>();
    @XmlTransient
    private Partition m_partition;
    @XmlTransient
    private Map<String, List<Event>> m_partitionedEvents;
    @XmlTransient
    private List<Event> m_nullPartitionedEvents;
    @XmlTransient
    private Map<String, Event> m_eventsByUei = new ConcurrentSkipListMap<String, Event>();
    @XmlTransient
    private List<Event> m_wildcardEvents;
    @XmlTransient
    private EventOrdering m_ordering;

    public Global getGlobal() {
        return this.m_global;
    }

    public void setGlobal(Global global) {
        this.m_global = global;
    }

    public List<Event> getEvents() {
        return this.m_events;
    }

    public void setEvents(List<Event> events) {
        if (this.m_events == events) {
            return;
        }
        this.m_events.clear();
        if (events != null) {
            this.m_events.addAll(events);
        }
    }

    public void addEvent(Event event) {
        this.m_events.add(event);
    }

    public boolean removeEvent(Event event) {
        return this.m_events.remove(event);
    }

    public List<String> getEventFiles() {
        return this.m_eventFiles;
    }

    public void setEventFiles(List<String> eventFiles) {
        if (this.m_eventFiles == eventFiles) {
            return;
        }
        this.m_eventFiles.clear();
        if (eventFiles != null) {
            this.m_eventFiles.addAll(eventFiles);
        }
    }

    public void addEventFile(String eventFile) {
        this.m_eventFiles.add(ConfigUtils.normalizeAndInternString(eventFile));
    }

    public boolean removeEventFile(String eventFile) {
        return this.m_eventFiles.remove(eventFile);
    }

    public EventOrdering getOrdering() {
        return this.m_ordering;
    }

    public static Resource getRelative(Resource baseRef, String relative) {
        try {
            if (relative.startsWith("classpath:")) {
                return RESOURCE_LOADER.getResource(relative);
            }
            return baseRef.createRelative(relative);
        }
        catch (IOException e) {
            throw new ObjectRetrievalFailureException(Resource.class, (Object)baseRef, "Resource location has a relative path, however the configResource does not reference a file, so the relative path cannot be resolved.  The location is: " + relative, null);
        }
    }

    public Map<String, Long> loadEventFiles(Resource configResource) throws IOException {
        LinkedHashMap<String, Long> lastModifiedEventFiles = new LinkedHashMap<String, Long>();
        this.loadEventFilesIfModified(configResource, lastModifiedEventFiles);
        return lastModifiedEventFiles;
    }

    public void loadEventFilesIfModified(Resource configResource, Map<String, Long> lastModifiedEventFiles) throws IOException {
        Iterator<Object> it = this.m_loadedEventFiles.entrySet().iterator();
        while (it.hasNext()) {
            String eventFile = it.next().getKey();
            if (this.m_eventFiles.contains(eventFile)) continue;
            it.remove();
        }
        for (String eventFile : this.m_eventFiles) {
            Resource eventResource = Events.getRelative(configResource, eventFile);
            long lastModified = eventResource.lastModified();
            boolean shouldLoadFile = true;
            if (lastModifiedEventFiles.containsKey(eventFile) && lastModifiedEventFiles.get(eventFile) == lastModified) {
                shouldLoadFile = false;
                assert (this.m_loadedEventFiles.containsKey(eventFile));
            }
            if (!shouldLoadFile) continue;
            lastModifiedEventFiles.put(eventFile, lastModified);
            Events events = (Events)JaxbUtils.unmarshal(Events.class, (Resource)eventResource);
            if (events.getEvents().isEmpty()) {
                throw new IllegalStateException("Uh oh! An event file " + String.valueOf(eventResource.getFile()) + " with no events has been loaded!");
            }
            if (events.getGlobal() != null) {
                throw new ObjectRetrievalFailureException(Resource.class, (Object)eventResource, "The event resource " + String.valueOf(eventResource) + " included from the root event configuration file cannot have a 'global' element", null);
            }
            if (!events.getEventFiles().isEmpty()) {
                throw new ObjectRetrievalFailureException(Resource.class, (Object)eventResource, "The event resource " + String.valueOf(eventResource) + " included from the root event configuration file cannot include other configuration files: " + StringUtils.collectionToCommaDelimitedString(events.getEventFiles()), null);
            }
            this.m_loadedEventFiles.put(eventFile, events);
        }
        LinkedHashMap<String, Events> orderedAndLoadedEventFiles = new LinkedHashMap<String, Events>();
        for (String eventFile : this.m_eventFiles) {
            Events loadedEvents = this.m_loadedEventFiles.get(eventFile);
            if (loadedEvents == null) continue;
            orderedAndLoadedEventFiles.put(eventFile, loadedEvents);
        }
        this.m_loadedEventFiles = orderedAndLoadedEventFiles;
    }

    public boolean isSecureTag(String tag) {
        return this.m_global != null && this.m_global.isSecureTag(tag);
    }

    private void partitionEvents(Partition partition) {
        this.m_partition = partition;
        this.m_partitionedEvents = new LinkedHashMap<String, List<Event>>();
        this.m_nullPartitionedEvents = new ArrayList<Event>();
        for (Event event : this.m_events) {
            List<String> keys = partition.group(event);
            if (keys == null) {
                this.m_nullPartitionedEvents.add(event);
                continue;
            }
            for (String key : keys) {
                List events = this.m_partitionedEvents.computeIfAbsent(key, k -> new ArrayList());
                events.add(event);
            }
        }
        this.m_partitionedEvents.values().forEach(Collections::sort);
        Collections.sort(this.m_nullPartitionedEvents);
    }

    public Event findFirstMatchingEvent(org.opennms.netmgt.xml.event.Event matchingEvent) {
        List<Event> events;
        Event matchedEvent;
        String ueiToMatch = matchingEvent.getUei();
        if (ueiToMatch != null && (matchedEvent = this.m_eventsByUei.get(ueiToMatch)) != null) {
            return matchedEvent;
        }
        String key = this.m_partition.group(matchingEvent);
        SequencedCollection<Event> potentialMatches = this.m_nullPartitionedEvents;
        if (key != null && (events = this.m_partitionedEvents.get(key)) != null) {
            potentialMatches = new TreeSet<Event>(this.m_nullPartitionedEvents);
            potentialMatches.addAll(events);
        }
        for (Event event : potentialMatches) {
            if (!event.matches(matchingEvent).matched()) continue;
            return event;
        }
        for (Events subEvents : this.m_loadedEventFiles.values()) {
            Event event = subEvents.findFirstMatchingEvent(matchingEvent);
            if (event == null) continue;
            return event;
        }
        return null;
    }

    public Set<Event> findMatchingEvents(EventCriteria criteria) {
        HashSet<Event> results = new HashSet<Event>();
        for (Event event : this.m_events) {
            if (!criteria.matches(event)) continue;
            results.add(event);
        }
        for (Map.Entry entry : this.m_loadedEventFiles.entrySet()) {
            Events events = (Events)entry.getValue();
            Set<Event> moreResults = events.findMatchingEvents(criteria);
            if (moreResults == null) continue;
            results.addAll(moreResults);
        }
        return results;
    }

    public Event findFirstMatchingEvent(EventCriteria criteria) {
        for (Event event : this.m_events) {
            if (!criteria.matches(event)) continue;
            return event;
        }
        for (Map.Entry entry : this.m_loadedEventFiles.entrySet()) {
            Events events = (Events)entry.getValue();
            Event result = events.findFirstMatchingEvent(criteria);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <T> T forEachEvent(T initial, EventCallback<T> callback) {
        T result = initial;
        for (Event event : this.m_events) {
            result = callback.process(result, event);
        }
        for (Map.Entry entry : this.m_loadedEventFiles.entrySet()) {
            Events events = (Events)entry.getValue();
            result = events.forEachEvent(result, callback);
        }
        return result;
    }

    public void initialize(Partition partition, EventOrdering eventOrdering) {
        this.m_ordering = eventOrdering;
        for (Event event : this.m_events) {
            event.initialize(this.m_ordering.next());
        }
        this.partitionEvents(partition);
        for (Events events : this.m_loadedEventFiles.values()) {
            events.initialize(partition, this.m_ordering.subsequence());
        }
        List<Event> prioritizedEvents = this.getPrioritizedEvents();
        this.m_events.removeAll(prioritizedEvents);
        this.m_events.addAll(prioritizedEvents);
        this.m_events.sort(Comparator.naturalOrder());
        this.m_nullPartitionedEvents.removeAll(prioritizedEvents);
        this.m_nullPartitionedEvents.addAll(prioritizedEvents);
        this.m_nullPartitionedEvents.sort(Comparator.naturalOrder());
        this.indexEventsByUei();
    }

    private List<Event> getPrioritizedEvents() {
        List<Event> prioritizedEvents = this.m_events.stream().filter(e -> e.getPriority() > 0).collect(Collectors.toList());
        for (Events eventsFile : this.m_loadedEventFiles.values()) {
            prioritizedEvents.addAll(eventsFile.getPrioritizedEvents());
        }
        return prioritizedEvents;
    }

    private void indexEventsByUei() {
        this.m_eventsByUei.clear();
        HashSet ueisWithManyEventDefinitions = new HashSet();
        this.forEachEvent(e -> {
            String uei = e.getUei();
            if (uei == null) {
                return;
            }
            if (this.m_eventsByUei.putIfAbsent(uei, (Event)e) != null) {
                ueisWithManyEventDefinitions.add(uei);
            }
        });
        ueisWithManyEventDefinitions.forEach(uei -> {
            this.m_eventsByUei.remove(uei);
            for (Events events : this.m_loadedEventFiles.values()) {
                events.m_eventsByUei.remove(uei);
            }
        });
        ArrayList matchers = new ArrayList();
        this.forEachEvent(e -> {
            Maskelement ueiMask;
            Mask mask = e.getMask();
            if (mask != null && (ueiMask = mask.getMaskElement("uei")) != null) {
                matchers.add(ueiMask.constructMatcher());
            }
        });
        if (matchers.size() >= 1) {
            Iterator<Map.Entry<String, Event>> it = this.m_eventsByUei.entrySet().iterator();
            block0: while (it.hasNext()) {
                Map.Entry<String, Event> entry = it.next();
                for (EventMatcher matcher : matchers) {
                    org.opennms.netmgt.xml.event.Event eventToMatch = new org.opennms.netmgt.xml.event.Event();
                    eventToMatch.setUei(entry.getKey());
                    if (!matcher.matches(eventToMatch).matched()) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
    }

    public Events getLoadEventsByFile(String relativePath) {
        return this.m_loadedEventFiles.get(relativePath);
    }

    public Map<String, Events> getLoadedEventFiles() {
        return this.m_loadedEventFiles;
    }

    public void addLoadedEventFile(String relativePath, Events events) {
        if (!this.m_eventFiles.contains(relativePath)) {
            this.m_eventFiles.add(relativePath);
        }
        this.m_loadedEventFiles.put(relativePath, events);
    }

    public void removeLoadedEventFile(String relativePath) {
        this.m_eventFiles.remove(relativePath);
        this.m_loadedEventFiles.remove(relativePath);
    }

    public void saveEvents(Resource resource) {
        StringWriter stringWriter = new StringWriter();
        JaxbUtils.marshal((Object)this, (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            File file;
            try {
                file = resource.getFile();
            }
            catch (IOException e) {
                throw new DataAccessResourceFailureException("Event resource '" + String.valueOf(resource) + "' is not a file resource and cannot be saved.  Nested exception: " + String.valueOf(e), (Throwable)e);
            }
            try (FileOutputStream fos = new FileOutputStream(file);
                 OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                fileWriter.write(stringWriter.toString());
            }
            catch (Exception e) {
                throw new DataAccessResourceFailureException("Event file '" + String.valueOf(file) + "' could not be opened.  Nested exception: " + String.valueOf(e), (Throwable)e);
            }
        }
    }

    public void save(Resource resource) {
        for (Map.Entry<String, Events> entry : this.m_loadedEventFiles.entrySet()) {
            String eventFile = entry.getKey();
            Events events = entry.getValue();
            Resource eventResource = Events.getRelative(resource, eventFile);
            events.save(eventResource);
        }
        this.saveEvents(resource);
    }

    public int hashCode() {
        return Objects.hash(this.m_global, this.m_events, this.m_eventFiles);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Events) {
            Events that = (Events)obj;
            return Objects.equals(this.m_global, that.m_global) && Objects.equals(this.m_events, that.m_events) && Objects.equals(this.m_eventFiles, that.m_eventFiles);
        }
        return false;
    }

    private void forEachEvent(Consumer<Event> callback) {
        this.forEachEvent(callback, this, null);
    }

    private void forEachEvent(Consumer<Event> callback, Events eventFile, Set<String> filesProcessed) {
        for (Event event : eventFile.m_events) {
            callback.accept(event);
        }
        if (filesProcessed == null) {
            filesProcessed = new HashSet<String>();
        }
        for (Map.Entry entry : this.m_loadedEventFiles.entrySet()) {
            if (filesProcessed.contains(entry.getKey())) continue;
            filesProcessed.add((String)entry.getKey());
            this.forEachEvent(callback, (Events)entry.getValue(), filesProcessed);
        }
    }

    public Event getEventByUeiOptimistic(String uei) {
        return this.m_eventsByUei.get(uei);
    }

    public static interface EventCriteria {
        public boolean matches(Event var1);
    }

    public static interface EventCallback<T> {
        public T process(T var1, Event var2);
    }
}

