/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.kscReports;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="Report")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="ksc-performance-reports.xsd")
public class Report
implements Serializable {
    private static final long serialVersionUID = 3L;
    @XmlAttribute(name="id")
    private Integer m_id;
    @XmlAttribute(name="title", required=true)
    private String m_title;
    @XmlAttribute(name="show_timespan_button")
    private Boolean m_showTimespanButton;
    @XmlAttribute(name="show_graphtype_button")
    private Boolean m_showGraphtypeButton;
    @XmlAttribute(name="graphs_per_line")
    private Integer m_graphsPerLine;
    @XmlElement(name="Graph")
    private List<Graph> m_graphs = new ArrayList<Graph>();

    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = ConfigUtils.assertNotEmpty(title, "title");
    }

    public Optional<Boolean> getShowTimespanButton() {
        return Optional.ofNullable(this.m_showTimespanButton);
    }

    public void setShowTimespanButton(Boolean showTimespanButton) {
        this.m_showTimespanButton = showTimespanButton;
    }

    public Optional<Boolean> getShowGraphtypeButton() {
        return Optional.ofNullable(this.m_showGraphtypeButton);
    }

    public void setShowGraphtypeButton(Boolean showGraphtypeButton) {
        this.m_showGraphtypeButton = showGraphtypeButton;
    }

    public List<Graph> getGraphs() {
        return this.m_graphs;
    }

    public void setGraphs(List<Graph> graphs) {
        if (graphs == this.m_graphs) {
            return;
        }
        this.m_graphs.clear();
        if (graphs != null) {
            this.m_graphs.addAll(graphs);
        }
    }

    public void addGraph(Graph graph) {
        this.m_graphs.add(graph);
    }

    public void addGraph(int index, Graph graph) {
        this.m_graphs.add(index, graph);
    }

    public boolean removeGraph(Graph graph) {
        return this.m_graphs.remove(graph);
    }

    public Optional<Integer> getGraphsPerLine() {
        return Optional.ofNullable(this.m_graphsPerLine);
    }

    public void setGraphsPerLine(Integer graphsPerLine) {
        this.m_graphsPerLine = ConfigUtils.assertMinimumInclusive(graphsPerLine, 0L, "graphs_per_line");
    }

    public int hashCode() {
        return Objects.hash(this.m_id, this.m_title, this.m_showTimespanButton, this.m_showGraphtypeButton, this.m_graphsPerLine, this.m_graphs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Report) {
            Report that = (Report)obj;
            return Objects.equals(this.m_id, that.m_id) && Objects.equals(this.m_title, that.m_title) && Objects.equals(this.m_showTimespanButton, that.m_showTimespanButton) && Objects.equals(this.m_showGraphtypeButton, that.m_showGraphtypeButton) && Objects.equals(this.m_graphsPerLine, that.m_graphsPerLine) && Objects.equals(this.m_graphs, that.m_graphs);
        }
        return false;
    }

    public String toString() {
        return "Report [id=" + this.m_id + ", m_title=" + this.m_title + ", showTimespanButton=" + this.m_showTimespanButton + ", showGraphtypeButton=" + this.m_showGraphtypeButton + ", graphsPerLine=" + this.m_graphsPerLine + ", graphs=" + String.valueOf(this.m_graphs) + "]";
    }
}

