/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="exclude-range")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="discovery-configuration.xsd")
public class ExcludeRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="begin", required=true)
    private String begin;
    @XmlElement(name="end", required=true)
    private String end;
    @XmlAttribute(name="location")
    private String location;

    public ExcludeRange() {
    }

    public ExcludeRange(String begin, String end) {
        this.setBegin(begin);
        this.setEnd(end);
    }

    public String getBegin() {
        return this.begin;
    }

    public void setBegin(String begin) {
        this.begin = ConfigUtils.assertNotEmpty(begin, "begin");
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = ConfigUtils.assertNotEmpty(end, "end");
    }

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int hashCode() {
        return Objects.hash(this.begin, this.end, this.location);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExcludeRange) {
            ExcludeRange temp = (ExcludeRange)obj;
            return Objects.equals(temp.begin, this.begin) && Objects.equals(temp.end, this.end) && Objects.equals(temp.location, this.location);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("begin", (Object)this.begin).add("end", (Object)this.end).add("location", (Object)this.location).toString();
    }
}

