/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors.support;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;

public abstract class ParameterSubstitutingMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(ParameterSubstitutingMonitor.class);
    private static final Pattern LOOKS_LIKE_SUBSTITUTION = Pattern.compile(".*[{][a-zA-Z0-9]*[}].*");
    private static Map<String, Pattern> subPatterns = new HashMap<String, Pattern>();
    private static Pattern substitutionPattern;
    private static final Supplier<NodeDao> nodeDao;

    public Map<String, Object> getRuntimeAttributes(MonitoredService svc, Map<String, Object> parameters) {
        return ParameterSubstitutingMonitor.getSubstitutedParameters(svc, parameters);
    }

    public static Map<String, Object> getSubstitutedParameters(MonitoredService svc, Map<String, Object> parameters) {
        HashMap<String, Object> subbedParams = new HashMap<String, Object>();
        parameters.forEach((k, v) -> {
            Matcher m = substitutionPattern.matcher(v.toString());
            if (m.matches()) {
                subbedParams.put("subbed-" + k, ParameterSubstitutingMonitor.parseString(v.toString(), m, svc));
            } else if (LOOKS_LIKE_SUBSTITUTION.matcher(v.toString()).matches()) {
                LOG.error("unknown substitution found: {}. Possible substitutions: {}", (Object)v.toString(), (Object)substitutionPattern.toString());
            }
        });
        return subbedParams;
    }

    protected static String parseString(String unformattedString, Matcher m, MonitoredService svc) {
        StringBuilder sb;
        Pattern p = subPatterns.get(m.group(1));
        if (p == null) {
            LOG.error("invalid substitution pattern found: {}", (Object)m.group(1));
            return null;
        }
        Matcher n = p.matcher(unformattedString);
        if (n.matches()) {
            sb = new StringBuilder();
            sb.append(n.group(1));
            switch (m.group(1)) {
                case "ipAddr": 
                case "ipAddress": {
                    sb.append(svc.getIpAddr());
                    break;
                }
                case "nodeId": {
                    sb.append(svc.getNodeId());
                    break;
                }
                case "nodeLabel": {
                    sb.append(svc.getNodeLabel());
                    break;
                }
                case "foreignId": {
                    sb.append(((OnmsNode)((NodeDao)nodeDao.get()).get((Serializable)Integer.valueOf(svc.getNodeId()))).getForeignId());
                    break;
                }
                case "foreignSource": {
                    sb.append(((OnmsNode)((NodeDao)nodeDao.get()).get((Serializable)Integer.valueOf(svc.getNodeId()))).getForeignSource());
                    break;
                }
                default: {
                    BeanWrapperImpl wrapper;
                    Object obj;
                    LOG.debug("attempting to add node asset property {}", (Object)m.group(1));
                    OnmsNode node = (OnmsNode)((NodeDao)nodeDao.get()).get((Serializable)Integer.valueOf(svc.getNodeId()));
                    if (node == null || (obj = (wrapper = new BeanWrapperImpl((Object)node.getAssetRecord())).getPropertyValue(m.group(1))) == null) break;
                    sb.append(obj.toString());
                }
            }
        } else {
            throw new IllegalStateException(String.format("Engineering mistake: we should never end up here, the regular expression seems to have a problem: %s", substitutionPattern.toString()));
        }
        sb.append(n.group(2));
        String formattedString = sb.toString();
        Matcher o = substitutionPattern.matcher(formattedString);
        if (o.matches()) {
            return ParameterSubstitutingMonitor.parseString(formattedString, o, svc);
        }
        return formattedString;
    }

    protected static String resolveKeyedString(Map<String, Object> parameterMap, String key, String defaultValue) {
        String ret = ParameterMap.getKeyedString(parameterMap, (String)key, (String)defaultValue);
        String subKey = "subbed-" + key;
        if (parameterMap.containsKey(subKey)) {
            ret = ParameterMap.getKeyedString(parameterMap, (String)subKey, (String)defaultValue);
        }
        return ret;
    }

    static {
        nodeDao = Suppliers.memoize(() -> (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class));
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append(".*[{](ipAddr(?:ess)?|nodeId|nodeLabel|foreignId|foreignSource");
        try {
            PropertyDescriptor[] pds;
            BeanInfo info = Introspector.getBeanInfo(OnmsAssetRecord.class);
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                patternBuilder.append("|").append(pd.getName());
                subPatterns.put(pd.getName(), Pattern.compile("(.*)[{]" + pd.getName() + "[}](.*)"));
            }
        }
        catch (IntrospectionException ie) {
            LOG.warn("Failed to introspect OnmsAssetRecord when initializing due to {}", (Object)ie.getLocalizedMessage());
        }
        patternBuilder.append(")[}].*");
        substitutionPattern = Pattern.compile(patternBuilder.toString());
        Pattern p = Pattern.compile("(.*)[{]ipAddr(?:ess)?[}](.*)");
        subPatterns.put("ipAddr", p);
        subPatterns.put("ipAddress", p);
        subPatterns.put("nodeId", Pattern.compile("(.*)[{]nodeId[}](.*)"));
        subPatterns.put("nodeLabel", Pattern.compile("(.*)[{]nodeLabel[}](.*)"));
        subPatterns.put("foreignId", Pattern.compile("(.*)[{]foreignId[}](.*)"));
        subPatterns.put("foreignSource", Pattern.compile("(.*)[{]foreignSource[}](.*)"));
    }
}

