/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.reporting.availability.AvailabilityData;
import org.opennms.reporting.availability.Categories;
import org.opennms.reporting.availability.Created;
import org.opennms.reporting.availability.Report;
import org.opennms.reporting.availability.ViewInfo;
import org.opennms.reporting.availability.render.HTMLReportRenderer;
import org.opennms.reporting.availability.render.PDFReportRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AvailabilityReport {
    private static final Logger LOG = LoggerFactory.getLogger(AvailabilityReport.class);
    private static final String LOG4J_CATEGORY = "reports";
    private static final String MONTH_FORMAT_CLASSIC = "classic";
    private Report m_report = null;
    public static String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public AvailabilityReport(final String author, final String startMonth, final String startDate, final String startYear) {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.debug("Inside AvailabilityReport");
                GregorianCalendar today = new GregorianCalendar();
                int day = Integer.parseInt(startDate);
                int year = Integer.parseInt(startYear);
                String month = months[Integer.parseInt(startMonth)];
                int hour = today.get(10);
                int minute = today.get(12);
                int second = today.get(13);
                Created created = new Created();
                created.setDay(day);
                created.setHour(hour);
                created.setMin(minute);
                created.setMonth(month);
                created.setSec(second);
                created.setYear(year);
                created.setContent(new BigDecimal(today.getTime().getTime()));
                AvailabilityReport.this.m_report = new Report();
                AvailabilityReport.this.m_report.setCreated(created);
                AvailabilityReport.this.m_report.setAuthor(author);
                LOG.debug("Leaving AvailabilityReport");
            }
        });
    }

    public void getReportData(String logourl, String categoryName, String reportFormat, String monthFormat, String startMonth, String startDate, String startYear) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("inside getReportData");
            LOG.debug("Category name {}", (Object)categoryName);
            LOG.debug("Report format {}", (Object)reportFormat);
            LOG.debug("logo {}", (Object)logourl);
            LOG.debug("monthFormat {}", (Object)monthFormat);
        }
        this.populateReport(logourl, categoryName, reportFormat, monthFormat, startMonth, startDate, startYear);
        try {
            this.marshalReport();
        }
        catch (Throwable e) {
            LOG.error("Exception", e);
        }
    }

    public void populateReport(String logourl, String categoryName, String reportFormat, String monthFormat, String startMonth, String startDate, String startYear) {
        this.m_report.setLogo(logourl);
        ViewInfo viewInfo = new ViewInfo();
        this.m_report.setViewInfo(viewInfo);
        Categories categories = new Categories();
        this.m_report.setCategories(categories);
        try {
            AvailabilityData reportSource = new AvailabilityData();
            reportSource.fillReport(categoryName, this.m_report, reportFormat, monthFormat, startMonth, startDate, startYear);
        }
        catch (Throwable e) {
            LOG.error("Exception", e);
        }
    }

    public void marshalReport() throws IOException, Exception {
        File file = new File(ConfigFileConstants.getHome() + "/share/reports/AvailReport.xml");
        try {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            JaxbUtils.marshal((Object)this.m_report, (Writer)fileWriter);
            LOG.debug("The xml marshalled from the JAXB classes is saved in {}/share/reports/AvailReport.xml", (Object)ConfigFileConstants.getHome());
            ((Writer)fileWriter).close();
        }
        catch (Throwable e) {
            LOG.error("Exception", e);
        }
    }

    public void generatePDF(final String xsltFileName, final OutputStream out, final String format) throws Exception {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.debug("inside generatePDF");
                File file = new File(ConfigFileConstants.getHome() + "/share/reports/AvailReport.xml");
                try {
                    LOG.debug("The xml marshalled from the JAXB classes is saved in {}/share/reports/AvailReport.xml", (Object)ConfigFileConstants.getHome());
                    InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                    if (!format.equals("HTML")) {
                        new PDFReportRenderer().render(fileReader, out, new InputStreamReader((InputStream)new FileInputStream(xsltFileName), StandardCharsets.UTF_8));
                    } else {
                        new HTMLReportRenderer().render(fileReader, out, new InputStreamReader((InputStream)new FileInputStream(xsltFileName), StandardCharsets.UTF_8));
                    }
                }
                catch (Throwable e) {
                    LOG.error("Exception", e);
                }
                LOG.info("leaving generatePDF");
            }
        });
    }

    public static void main(final String[] args) {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                String monthFormat;
                String format;
                LOG.debug("main() called with args: {}", (Object)StringUtils.arrayToDelimitedString((Object[])args, (String)", "));
                System.setProperty("java.awt.headless", "true");
                String logourl = System.getProperty("image");
                String categoryName = System.getProperty("catName");
                if (categoryName == null || categoryName.equals("")) {
                    categoryName = "all";
                }
                if ((format = System.getProperty("format")) == null || format.equals("")) {
                    format = "SVG";
                }
                if ((monthFormat = System.getProperty("MonthFormat")) == null || format.equals("")) {
                    monthFormat = AvailabilityReport.MONTH_FORMAT_CLASSIC;
                }
                String startMonth = System.getProperty("startMonth");
                String startDate = System.getProperty("startDate");
                String startYear = System.getProperty("startYear");
                if (startMonth == null || startDate == null || startYear == null) {
                    throw new NumberFormatException("missing date properties");
                }
                try {
                    AvailabilityReport.generateReport(logourl, categoryName, format, monthFormat, startMonth, startDate, startYear);
                }
                catch (Exception e) {
                    LOG.warn("Error while generating report.", (Throwable)e);
                }
            }
        });
    }

    public static void generateReport(String logourl, String categoryName, String format, String monthFormat, String startMonth, String startDate, String startYear) throws Exception {
        String xslFileName;
        String pdfFileName;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String catFileName = categoryName.replace(' ', '-');
        if (format.equals("SVG")) {
            pdfFileName = ConfigFileConstants.getHome() + "/share/reports/AVAIL-SVG-" + catFileName + fmt.format(new Date()) + ".pdf";
            xslFileName = ConfigFileConstants.getFilePathString() + ConfigFileConstants.getFileName((int)ConfigFileConstants.REPORT_SVG_XSL);
        } else if (format.equals("PDF")) {
            pdfFileName = ConfigFileConstants.getHome() + "/share/reports/AVAIL-PDF-" + catFileName + fmt.format(new Date()) + ".pdf";
            xslFileName = ConfigFileConstants.getFilePathString() + ConfigFileConstants.getFileName((int)ConfigFileConstants.REPORT_PDF_XSL);
        } else if (format.equals("HTML")) {
            pdfFileName = ConfigFileConstants.getHome() + "/share/reports/AVAIL-HTML-" + catFileName + fmt.format(new Date()) + ".html";
            xslFileName = ConfigFileConstants.getFilePathString() + ConfigFileConstants.getFileName((int)ConfigFileConstants.REPORT_HTML_XSL);
        } else {
            LOG.error("Format '{}' is unsupported.  Must be one of: SVG, PDF, or HTML.", (Object)format);
            return;
        }
        try {
            AvailabilityReport report = new AvailabilityReport("Unknown", startMonth, startDate, startYear);
            report.getReportData(logourl, categoryName, format, monthFormat, startMonth, startDate, startYear);
            LOG.info("Generated Report Data... ");
            File file = new File(pdfFileName);
            FileOutputStream pdfFileWriter = new FileOutputStream(file);
            report.generatePDF(xslFileName, pdfFileWriter, format);
            LOG.debug("xsl -> {} pdfFileName -> {} format -> {}", new Object[]{xslFileName, pdfFileName, format});
            LOG.info("Generated Report ... and saved as {}", (Object)pdfFileName);
        }
        catch (Throwable e) {
            LOG.error("Exception", e);
        }
    }
}

