/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.opennms.core.utils.InsufficientInformationException;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.model.events.EventUtils;

@EventListener(name="enlinkd")
public final class EventProcessor {
    private EnhancedLinkd m_linkd;

    public void setLinkd(EnhancedLinkd linkd) {
        this.m_linkd = linkd;
    }

    public EnhancedLinkd getLinkd() {
        return this.m_linkd;
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeAdded")
    public void handleNodeAdded(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        this.m_linkd.addNode();
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeleted(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        this.m_linkd.deleteNode(event.getNodeid().intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedService")
    public void handleNodeGainedService(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        EventUtils.checkService((IEvent)event);
        if (event.getService().equals("SNMP")) {
            this.m_linkd.execSingleSnmpCollection(event.getNodeid().intValue());
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeLostService")
    public void handleNodeLostService(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        EventUtils.checkService((IEvent)event);
        if (event.getService().equals("SNMP")) {
            this.m_linkd.suspendNodeCollection(event.getNodeid().intValue());
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeRegainedService")
    public void handleRegainedService(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        EventUtils.checkService((IEvent)event);
        if (event.getService().equals("SNMP")) {
            this.m_linkd.wakeUpNodeCollection(event.getNodeid().intValue());
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/forceRescan")
    public void handleForceRescan(IEvent e) {
        this.m_linkd.execSingleSnmpCollection(e.getNodeid().intValue());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadDaemonConfig(IEvent e) {
        List parmCollection = e.getParmCollection();
        for (IParm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Enlinkd".equalsIgnoreCase(parm.getValue().getContent())) continue;
            this.m_linkd.reloadConfig();
            break;
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadTopology")
    public void handleReloadTopology(IEvent e) {
        String topologyNamespace = EventUtils.getParm((IEvent)e, (String)"namespace");
        if (topologyNamespace == null || "all".equalsIgnoreCase(topologyNamespace)) {
            this.m_linkd.reloadTopology();
        }
    }
}

