/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.search.api.Match;
import org.opennms.netmgt.search.api.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultItem {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResultItem.class);
    private String identifier;
    private String icon;
    private String label;
    private String url;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final List<Match> matches = new ArrayList<Match>();
    private int weight;
    private String info = "";

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof SearchResultItem) {
            SearchResultItem that = (SearchResultItem)o;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.label, that.label) && Objects.equals(this.url, that.url) && Objects.equals(this.properties, that.properties) && Objects.equals(this.matches, that.matches) && Objects.equals(this.icon, that.icon) && Objects.equals(this.weight, that.weight);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.label, this.properties, this.matches, this.url, this.icon, this.weight);
    }

    public void addMatch(Match match) {
        Optional<Match> existingMatch = this.matches.stream().filter(m -> match.getId().equals(m.getId())).findAny();
        if (existingMatch.isPresent()) {
            LOG.warn("A match with id {} already exists: {}. Will ignore Match {}", new Object[]{match.getId(), existingMatch.get(), match});
        } else {
            this.matches.add(match);
        }
    }

    public void addMatches(List<Matcher> matcherList, String input) {
        Objects.requireNonNull(matcherList);
        Objects.requireNonNull(input);
        matcherList.stream().filter(m -> !"".equals(m.getValue()) && m.getValue() != null).filter(m -> m.matches(input)).map(m -> new Match(m.getLabel(), m.getLabel(), m.getValue())).forEach(m -> this.addMatch((Match)m));
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    public void merge(SearchResultItem mergeMe) {
        this.getProperties().putAll(mergeMe.getProperties());
        mergeMe.getMatches().forEach(m -> this.addMatch((Match)m));
        this.setWeight(Math.max(this.getWeight(), mergeMe.getWeight()));
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }
}

