/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchResultItem;

public class SearchResult {
    public static SearchResult EMPTY = new SearchResult("$EMPTY$");
    private final SearchContext context;
    private final List<SearchResultItem> results = new ArrayList<SearchResultItem>();
    private boolean more;

    public SearchResult(String context) {
        this(new SearchContext(Objects.requireNonNull(context)));
    }

    public SearchResult(SearchContext searchContext) {
        this.context = Objects.requireNonNull(searchContext);
    }

    public void addItem(SearchResultItem item) {
        Objects.requireNonNull(item);
        Optional<SearchResultItem> existingItem = this.results.stream().filter(r -> r.getIdentifier().equals(item.getIdentifier())).findAny();
        if (existingItem.isPresent()) {
            existingItem.get().merge(item);
        } else {
            this.results.add(item);
        }
    }

    public SearchContext getContext() {
        return this.context;
    }

    public boolean hasMore() {
        return this.more;
    }

    public List<SearchResultItem> getResults() {
        return this.results;
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public void setMore(boolean more) {
        this.more = more;
    }

    public boolean isMore() {
        return this.more;
    }

    public SearchResult withResults(List<SearchResultItem> searchResultItems) {
        this.results.addAll(searchResultItems);
        return this;
    }

    public SearchResult withMore(boolean hasMore) {
        this.more = hasMore;
        return this;
    }

    public SearchResult withMore(Collection<?> totalList, Collection<?> subList) {
        this.withMore(totalList.size() > subList.size());
        return this;
    }
}

