/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.spog;

import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.features.grpc.exporter.mapper.EventsMapper;
import org.opennms.features.grpc.exporter.spog.SpogGrpcClient;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventSubscriptionService;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.plugin.grpc.proto.spog.EventUpdateList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsExporter
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventsExporter.class);
    private final EventSubscriptionService eventSubscriptionService;
    private final RuntimeInfo runtimeInfo;
    private final SpogGrpcClient client;
    private final boolean eventExportEnabled;

    public EventsExporter(EventSubscriptionService eventSubscriptionService, RuntimeInfo runtimeInfo, SpogGrpcClient client, boolean eventExportEnabled) {
        this.eventSubscriptionService = Objects.requireNonNull(eventSubscriptionService);
        this.runtimeInfo = runtimeInfo;
        this.client = client;
        this.eventExportEnabled = eventExportEnabled;
    }

    public void start() {
        this.eventSubscriptionService.addEventListener((EventListener)this);
    }

    public void stop() {
        this.eventSubscriptionService.removeEventListener((EventListener)this);
    }

    public String getName() {
        return EventsExporter.class.getName();
    }

    public void onEvent(IEvent event) {
        this.sendEventUpdate(event);
    }

    private void sendEventUpdate(IEvent event) {
        if (!event.hasNodeid()) {
            return;
        }
        if (!this.client.isEnabled()) {
            LOG.debug("SPOG service disabled, not sending event updates");
            return;
        }
        if (!this.eventExportEnabled) {
            LOG.debug("Event Export disabled, not sending event updates");
            return;
        }
        LOG.debug("Received new event with uei : {} and id : {}", (Object)event.getUei(), (Object)event.getDbid());
        EventUpdateList events = EventsMapper.INSTANCE.toEventUpdateList(List.of(event), this.runtimeInfo, SystemInfoUtils.getInstanceId(), false);
        this.client.sendEventUpdate(events);
    }
}

