/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.mapper;

import java.util.Date;
import java.util.List;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.NullValueCheckStrategy;
import org.mapstruct.NullValueMappingStrategy;
import org.mapstruct.factory.Mappers;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.events.api.model.ISnmp;
import org.opennms.plugin.grpc.proto.spog.Event;
import org.opennms.plugin.grpc.proto.spog.EventParameter;
import org.opennms.plugin.grpc.proto.spog.EventUpdateList;
import org.opennms.plugin.grpc.proto.spog.Severity;
import org.opennms.plugin.grpc.proto.spog.SnmpInfo;

@Mapper(collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS)
public interface EventsMapper {
    public static final EventsMapper INSTANCE = (EventsMapper)Mappers.getMapper(EventsMapper.class);

    @IterableMapping(nullValueMappingStrategy=NullValueMappingStrategy.RETURN_DEFAULT)
    @Mappings(value={@Mapping(target="severity", expression="java(mapSeverity(event.getSeverity()))"), @Mapping(target="id", source="dbid"), @Mapping(target="label", source="host"), @Mapping(target="createTime", source="creationTime"), @Mapping(target="description", source="descr"), @Mapping(target="logMessage", source="logmsg.content"), @Mapping(target="ipAddress", source="interfaceAddress.hostAddress"), @Mapping(target="snmpInfo", source="snmp"), @Mapping(target="parameter", source="parmCollection"), @Mapping(target="nodeId", source="nodeid")})
    public Event mapEvent(IEvent var1);

    public SnmpInfo mapSnmpInfo(ISnmp var1);

    @IterableMapping(nullValueMappingStrategy=NullValueMappingStrategy.RETURN_DEFAULT)
    @Mappings(value={@Mapping(target="instanceId", source="runtimeInfo.systemId"), @Mapping(target="instanceName", source="instanceName"), @Mapping(target="event", source="eventUpdates"), @Mapping(target="snapshot", source="isSnapshot")})
    public EventUpdateList toEventUpdates(List<IEvent> var1, RuntimeInfo var2, String var3, boolean var4);

    default public EventUpdateList toEventUpdateList(List<IEvent> eventUpdates, RuntimeInfo runtimeInfo, String instanceName, boolean snapshot) {
        EventUpdateList.Builder builder = this.toEventUpdates(eventUpdates, runtimeInfo, instanceName, snapshot).toBuilder();
        return builder.build();
    }

    @Mappings(value={@Mapping(target="name", source="parmName"), @Mapping(target="value", source="value.content"), @Mapping(target="type", source="value.type")})
    public EventParameter mapEventParameter(IParm var1);

    default public long mapDate(Date date) {
        return date != null ? date.getTime() : 0L;
    }

    default public Severity mapSeverity(String severity) {
        switch (severity.toUpperCase()) {
            case "NORMAL": {
                return Severity.NORMAL;
            }
            case "CLEARED": {
                return Severity.CLEARED;
            }
            case "MINOR": {
                return Severity.MINOR;
            }
            case "WARNING": {
                return Severity.WARNING;
            }
            case "INDETERMINATE": {
                return Severity.INDETERMINATE;
            }
            case "MAJOR": {
                return Severity.MAJOR;
            }
            case "CRITICAL": {
                return Severity.CRITICAL;
            }
        }
        return Severity.UNRECOGNIZED;
    }
}

