/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.bsm;

import java.util.List;
import java.util.Objects;
import org.opennms.features.grpc.exporter.bsm.BsmInventoryService;
import org.opennms.features.grpc.exporter.mapper.MonitoredServiceWithMetadata;
import org.opennms.integration.api.v1.dao.NodeDao;
import org.opennms.integration.api.v1.model.IpInterface;
import org.opennms.integration.api.v1.model.MonitoredService;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventSubscriptionService;
import org.opennms.netmgt.events.api.model.IEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsmInventoryExporter
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(BsmInventoryExporter.class);
    private final EventSubscriptionService eventSubscriptionService;
    private final NodeDao nodeDao;
    private final BsmInventoryService inventoryService;

    public BsmInventoryExporter(EventSubscriptionService eventSubscriptionService, NodeDao nodeDao, BsmInventoryService inventoryService) {
        this.eventSubscriptionService = Objects.requireNonNull(eventSubscriptionService);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.inventoryService = Objects.requireNonNull(inventoryService);
    }

    public void start() {
        this.eventSubscriptionService.addEventListener((EventListener)this, List.of("uei.opennms.org/nodes/nodeGainedService", "uei.opennms.org/nodes/serviceDeleted", "uei.opennms.org/nodes/interfaceDeleted", "uei.opennms.org/nodes/interfaceReparented", "uei.opennms.org/nodes/nodeDeleted"));
    }

    public void stop() {
        this.eventSubscriptionService.removeEventListener((EventListener)this);
    }

    public String getName() {
        return BsmInventoryExporter.class.getName();
    }

    public void onEvent(IEvent event) {
        LOG.debug("Got BSM inventory-event with uei : {}", (Object)event.getUei());
        switch (event.getUei()) {
            case "uei.opennms.org/nodes/nodeGainedService": {
                if (event.getNodeid() == null || event.getInterface() == null || event.getService() == null) {
                    return;
                }
                Node node = this.nodeDao.getNodeById(Integer.valueOf(event.getNodeid().intValue()));
                if (node == null) {
                    return;
                }
                IpInterface iface = node.getInterfaceByIp(event.getInterfaceAddress()).orElse(null);
                if (iface == null) {
                    return;
                }
                MonitoredService service = iface.getMonitoredService(event.getService()).orElse(null);
                if (service == null) {
                    return;
                }
                this.inventoryService.sendAddService(new MonitoredServiceWithMetadata(node, iface, service));
                break;
            }
            default: {
                this.inventoryService.sendSnapshot();
            }
        }
    }
}

