/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.xml.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.opennms.core.fileutils.DotDUpdateWatcher;
import org.opennms.core.ipc.twin.api.TwinPublisher;
import org.opennms.core.ipc.twin.api.TwinSubscriber;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.xml.IpfixDotD;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.xml.IpfixElements;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.AbstractInformationElementXmlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreInformationElementXmlProvider
extends AbstractInformationElementXmlProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CoreInformationElementXmlProvider.class);
    final String OPENNMS_HOME = System.getProperty("opennms.home");
    private final TwinPublisher twinPublisher;
    private InformationElementDatabase.Adder adder;

    public CoreInformationElementXmlProvider(TwinPublisher twinPublisher, TwinSubscriber twinSubscriber) {
        super(twinSubscriber);
        this.twinPublisher = twinPublisher;
    }

    private Set<File> getFiles() throws IOException {
        Path ipfixDotD = Paths.get(System.getProperty("karaf.etc"), new String[0]).resolve("ipfix.d");
        try (Stream<Path> stream = Files.list(ipfixDotD);){
            Set<File> set = stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".xml")).map(Path::toFile).collect(Collectors.toSet());
            return set;
        }
    }

    private IpfixDotD loadIpfixDotDFiles() {
        Set<File> files;
        IpfixDotD ipfixDotD = new IpfixDotD();
        try {
            files = this.getFiles();
        }
        catch (IOException e) {
            LOG.error("Error reading files in directory etc/ipfix.d", (Throwable)e);
            return null;
        }
        for (File file : files) {
            try {
                IpfixElements ipfixElements = (IpfixElements)JAXB.unmarshal((File)file, IpfixElements.class);
                ipfixDotD.getIpfixElements().add(ipfixElements);
            }
            catch (DataBindingException e) {
                LOG.error("Cannot load file {}", (Object)file.getAbsolutePath(), (Object)e);
                return null;
            }
        }
        return ipfixDotD;
    }

    public void load(InformationElementDatabase.Adder adder) {
        super.load(adder);
        if (this.adder == null) {
            this.adder = adder;
            try {
                DotDUpdateWatcher dotDUpdateWatcher = new DotDUpdateWatcher(this.OPENNMS_HOME + "/etc/ipfix.d", (dir, name) -> name.endsWith(".xml"), () -> this.reloadConfig(adder));
            }
            catch (Exception e) {
                LOG.error("Error initializing DotDUpdateWatcher for directory {}", (Object)(this.OPENNMS_HOME + "/etc/ipfix.d"), (Object)e);
            }
            this.reloadConfig(adder);
        }
    }

    private void reloadConfig(InformationElementDatabase.Adder adder) {
        LOG.info("Loading information elements from XML files in {}", (Object)(this.OPENNMS_HOME + "/etc/ipfix.d"));
        IpfixDotD ipfixDotD = this.loadIpfixDotDFiles();
        if (ipfixDotD == null) {
            return;
        }
        try {
            if (this.twinSession == null) {
                this.twinSession = this.twinPublisher.register("ipfix-dot-d.config", IpfixDotD.class);
            }
            this.twinSession.publish((Object)ipfixDotD);
        }
        catch (IOException e) {
            LOG.error("Error publishing ipfix.d configuration files");
        }
    }
}

