/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.core;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractCollectionAgentFactory<T extends CollectionAgent>
implements CollectionAgentFactory {
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    @Autowired
    private PlatformTransactionManager transMgr;

    protected abstract T createAgent(Integer var1, IpInterfaceDao var2, PlatformTransactionManager var3, String var4);

    public T createCollectionAgentAndOverrideLocation(String nodeCriteria, InetAddress ipAddr, String location) {
        OnmsNode node = this.nodeDao.get(nodeCriteria);
        if (node == null) {
            throw new IllegalArgumentException(String.format("No node found with lookup criteria: %s", nodeCriteria));
        }
        OnmsIpInterface ipInterface = this.ipInterfaceDao.findByNodeIdAndIpAddress(node.getId(), InetAddressUtils.str((InetAddress)ipAddr));
        if (ipInterface == null) {
            throw new IllegalArgumentException(String.format("No interface found with IP %s on node %s", InetAddressUtils.str((InetAddress)ipAddr), nodeCriteria));
        }
        T agent = this.createAgent(ipInterface.getId(), this.ipInterfaceDao, this.transMgr, location);
        return agent;
    }

    public T createCollectionAgent(String nodeCriteria, InetAddress ipAddr) {
        return this.createCollectionAgentAndOverrideLocation(nodeCriteria, ipAddr, null);
    }

    public T createCollectionAgent(OnmsIpInterface ipInterface) {
        T agent = this.createAgent(ipInterface.getId(), this.ipInterfaceDao, this.transMgr, null);
        return agent;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.ipInterfaceDao = ipInterfaceDao;
    }

    public void setPlatformTransactionManager(PlatformTransactionManager transMgr) {
        this.transMgr = transMgr;
    }
}

