/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.ifttt;

import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.spring.FileReloadContainer;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.ifttt.config.IfTttConfig;
import org.opennms.features.ifttt.config.Trigger;
import org.opennms.features.ifttt.config.TriggerPackage;
import org.opennms.features.ifttt.config.TriggerSet;
import org.opennms.features.ifttt.helper.DefaultVariableNameExpansion;
import org.opennms.features.ifttt.helper.IfTttTrigger;
import org.opennms.features.ifttt.helper.VariableNameExpansion;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

public class IfTttDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(IfTttDaemon.class);
    private final AlarmDao alarmDao;
    private final TransactionOperations transactionOperations;
    private final FileReloadContainer<IfTttConfig> m_fileReloadContainer;
    private ScheduledExecutorService m_alarmPoller;
    private final File ifTttConfigFile;
    private final EntityScopeProvider entityScopeProvider;

    public IfTttDaemon(AlarmDao alarmDao, TransactionOperations transactionOperations, EntityScopeProvider entityScopeProvider, File ifTttConfigFile) {
        this.alarmDao = alarmDao;
        this.transactionOperations = transactionOperations;
        this.ifTttConfigFile = ifTttConfigFile;
        this.entityScopeProvider = entityScopeProvider;
        this.m_fileReloadContainer = new FileReloadContainer(ifTttConfigFile, (object, resource) -> {
            LOG.debug("Reloading configuration file {}.", (Object)resource.getFilename());
            return (IfTttConfig)JaxbUtils.unmarshal(IfTttConfig.class, (File)ifTttConfigFile);
        });
    }

    public IfTttDaemon(AlarmDao alarmDao, TransactionOperations transactionOperations, EntityScopeProvider entityScopeProvider) {
        this(alarmDao, transactionOperations, entityScopeProvider, Paths.get(System.getProperty("opennms.home", ""), "etc", "ifttt-config.xml").toFile());
    }

    public void start() {
        LOG.debug("Starting IFTTT daemon.");
        if (((IfTttConfig)this.m_fileReloadContainer.getObject()).getEnabled().booleanValue()) {
            this.fireIfTttTriggerSet((IfTttConfig)this.m_fileReloadContainer.getObject(), "ON");
        }
        this.startPoller(((IfTttConfig)this.m_fileReloadContainer.getObject()).getPollInterval());
    }

    public void stop() {
        LOG.debug("Stopping IFTTT daemon.");
        if (((IfTttConfig)this.m_fileReloadContainer.getObject()).getEnabled().booleanValue()) {
            this.fireIfTttTriggerSet((IfTttConfig)this.m_fileReloadContainer.getObject(), "OFF");
        }
        this.stopPoller();
    }

    private void startPoller(final long pollInterval) {
        LOG.debug("Starting alarm poller (interval {}s).", (Object)pollInterval);
        this.m_alarmPoller = Executors.newScheduledThreadPool(1);
        this.m_alarmPoller.scheduleWithFixedDelay(new Runnable(){
            private Map<Boolean, Map<String, Integer>> oldAlarmCount = new HashMap<Boolean, Map<String, Integer>>();
            private Map<Boolean, Map<String, OnmsSeverity>> oldSeverity = new HashMap<Boolean, Map<String, OnmsSeverity>>();
            {
                this.oldAlarmCount.put(Boolean.TRUE, new HashMap());
                this.oldAlarmCount.put(Boolean.FALSE, new HashMap());
                this.oldSeverity.put(Boolean.TRUE, new HashMap());
                this.oldSeverity.put(Boolean.FALSE, new HashMap());
            }

            private List<OnmsAlarm> filterAlarms(List<OnmsAlarm> alarms, TriggerPackage triggerPackage) {
                Stream<Object> stream = alarms.stream();
                if (triggerPackage.getOnlyUnacknowledged().booleanValue()) {
                    stream = stream.filter(alarm -> !alarm.isAcknowledged());
                }
                if (!Strings.isNullOrEmpty((String)triggerPackage.getCategoryFilter())) {
                    stream = stream.filter(alarm -> alarm.getNodeId() != null).filter(alarm -> alarm.getNode().getCategories().stream().anyMatch(category -> category.getName().matches(triggerPackage.getCategoryFilter())));
                }
                if (!Strings.isNullOrEmpty((String)triggerPackage.getReductionKeyFilter())) {
                    stream = stream.filter(alarm -> !Strings.isNullOrEmpty((String)alarm.getReductionKey())).filter(alarm -> alarm.getReductionKey().matches(triggerPackage.getReductionKeyFilter()));
                }
                return stream.collect(Collectors.toList());
            }

            @Override
            public void run() {
                try {
                    final IfTttConfig ifTttConfig = (IfTttConfig)IfTttDaemon.this.m_fileReloadContainer.getObject();
                    if (ifTttConfig.getPollInterval() != pollInterval) {
                        IfTttDaemon.this.restartPoller(ifTttConfig.getPollInterval());
                        return;
                    }
                    if (!ifTttConfig.getEnabled().booleanValue()) {
                        LOG.debug("Disabled - skipping alarm polling.");
                        return;
                    }
                    IfTttDaemon.this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsAlarm.class).gt("severity", (Object)OnmsSeverity.NORMAL);
                            List alarms = IfTttDaemon.this.alarmDao.findMatching(criteriaBuilder.toCriteria());
                            for (TriggerPackage triggerPackage : ifTttConfig.getTriggerPackages()) {
                                if (!oldSeverity.get(triggerPackage.getOnlyUnacknowledged()).containsKey(triggerPackage.getFilterKey())) {
                                    oldSeverity.get(triggerPackage.getOnlyUnacknowledged()).put(triggerPackage.getFilterKey(), OnmsSeverity.INDETERMINATE);
                                    oldAlarmCount.get(triggerPackage.getOnlyUnacknowledged()).put(triggerPackage.getFilterKey(), 0);
                                }
                                List<OnmsAlarm> filteredAlarms = this.filterAlarms(alarms, triggerPackage);
                                Optional<OnmsSeverity> maxAlarmsSeverity = filteredAlarms.stream().map(OnmsAlarm::getSeverity).max(Comparator.naturalOrder());
                                OnmsSeverity newSeverity = maxAlarmsSeverity.orElse(OnmsSeverity.NORMAL);
                                int newAlarmCount = filteredAlarms.size();
                                LOG.debug("Received {} filtered, {} new severity", (Object)newAlarmCount, (Object)newSeverity);
                                DefaultVariableNameExpansion defaultVariableNameExpansion = new DefaultVariableNameExpansion(oldSeverity.get(triggerPackage.getOnlyUnacknowledged()).get(triggerPackage.getFilterKey()), newSeverity, oldAlarmCount.get(triggerPackage.getOnlyUnacknowledged()).get(triggerPackage.getFilterKey()), newAlarmCount);
                                if (!newSeverity.equals((Object)oldSeverity.get(triggerPackage.getOnlyUnacknowledged()).get(triggerPackage.getFilterKey())) || newAlarmCount != oldAlarmCount.get(triggerPackage.getOnlyUnacknowledged()).get(triggerPackage.getFilterKey())) {
                                    IfTttDaemon.this.fireIfTttTriggerSet(ifTttConfig, triggerPackage.getFilterKey(), newSeverity, (VariableNameExpansion)defaultVariableNameExpansion);
                                }
                                LOG.debug("Old severity: {}, new severity: {}, old alarm count: {}, new alarm count: {}", new Object[]{oldSeverity.get(triggerPackage.getOnlyUnacknowledged()).get(triggerPackage.getFilterKey()), newSeverity, oldAlarmCount.get(triggerPackage.getOnlyUnacknowledged()).get(triggerPackage.getFilterKey()), newAlarmCount});
                                oldSeverity.get(triggerPackage.getOnlyUnacknowledged()).put(triggerPackage.getFilterKey(), newSeverity);
                                oldAlarmCount.get(triggerPackage.getOnlyUnacknowledged()).put(triggerPackage.getFilterKey(), newAlarmCount);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error("Error while polling alarm table.", (Throwable)e);
                }
                finally {
                    LOG.debug("Run complete. Next poll in {}s.", (Object)pollInterval);
                }
            }
        }, pollInterval, pollInterval, TimeUnit.SECONDS);
    }

    private void restartPoller(long pollInterval) {
        LOG.debug("Restarting alarm poller (interval {}s).", (Object)pollInterval);
        this.stopPoller();
        this.startPoller(pollInterval);
    }

    private void stopPoller() {
        LOG.debug("Stopping alarm poller.");
        if (this.m_alarmPoller != null) {
            this.m_alarmPoller.shutdown();
            this.m_alarmPoller = null;
        }
    }

    private void fireIfTttTriggerSet(IfTttConfig ifTttConfig, String name) {
        if (ifTttConfig == null) {
            return;
        }
        for (TriggerPackage triggerPackage : ifTttConfig.getTriggerPackages()) {
            this.fireIfTttTriggerSet(ifTttConfig, triggerPackage.getFilterKey(), name.toUpperCase(), (String string) -> string);
        }
    }

    private void fireIfTttTriggerSet(IfTttConfig ifTttConfig, String filterKey, OnmsSeverity newSeverity, VariableNameExpansion variableNameExpansion) {
        this.fireIfTttTriggerSet(ifTttConfig, filterKey, newSeverity.getLabel().toUpperCase(), variableNameExpansion);
    }

    protected void fireIfTttTriggerSet(IfTttConfig ifTttConfig, String filterKey, String name, VariableNameExpansion variableNameExpansion) {
        if (ifTttConfig == null) {
            return;
        }
        TriggerPackage triggerPackage = ifTttConfig.getTriggerPackageForFilters(filterKey);
        if (triggerPackage != null) {
            TriggerSet triggerSet = triggerPackage.getTriggerSetForName(name);
            if (triggerSet != null) {
                for (Trigger trigger : triggerSet.getTriggers()) {
                    new IfTttTrigger().key(Interpolator.interpolate((String)ifTttConfig.getKey(), (Scope)this.entityScopeProvider.getScopeForScv()).output).event(trigger.getEventName()).value1(variableNameExpansion.replace(trigger.getValue1())).value2(variableNameExpansion.replace(trigger.getValue2())).value3(variableNameExpansion.replace(trigger.getValue3())).trigger();
                    try {
                        Thread.sleep(trigger.getDelay());
                    }
                    catch (InterruptedException e) {
                        LOG.error("Error triggering IFTTT event: ", (Throwable)e);
                    }
                }
            } else {
                LOG.debug("No trigger-set with name '{}' defined.", (Object)name);
            }
        } else {
            LOG.error("Error retrieving trigger package for filter {}.", (Object)filterKey);
        }
    }

    FileReloadContainer<IfTttConfig> getFileReloadContainer() {
        return this.m_fileReloadContainer;
    }
}

