/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;

public class Slf4jLogFactory
extends LogFactory {
    @Override
    protected LogAdapter createLogger(String name) {
        return new Slf4jLogAdapter(LoggerFactory.getLogger((String)name));
    }

    @Override
    public LogAdapter getRootLogger() {
        return new Slf4jLogAdapter(LoggerFactory.getLogger((String)"ROOT"));
    }

    @Override
    public Iterator<?> loggers() {
        return Collections.emptyIterator();
    }

    private static class Slf4jLogAdapter
    implements LogAdapter,
    Comparable<Object> {
        private final Logger logger;

        public Slf4jLogAdapter(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void debug(Serializable message) {
            this.logger.debug(String.valueOf(message));
        }

        @Override
        public void info(CharSequence message) {
            this.logger.info(String.valueOf(message));
        }

        @Override
        public void warn(Serializable message) {
            this.logger.warn(String.valueOf(message));
        }

        @Override
        public void error(Serializable message) {
            this.logger.error(String.valueOf(message));
        }

        @Override
        public void error(CharSequence message, Throwable throwable) {
            this.logger.error(String.valueOf(message), throwable);
        }

        @Override
        public void fatal(Object message) {
            this.logger.error(String.valueOf(message));
        }

        @Override
        public void fatal(CharSequence message, Throwable throwable) {
            this.logger.error(String.valueOf(message), throwable);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public LogLevel getLogLevel() {
            if (this.logger.isDebugEnabled()) {
                return LogLevel.DEBUG;
            }
            if (this.logger.isInfoEnabled()) {
                return LogLevel.INFO;
            }
            if (this.logger.isWarnEnabled()) {
                return LogLevel.WARN;
            }
            return LogLevel.ERROR;
        }

        @Override
        public LogLevel getEffectiveLogLevel() {
            return this.getLogLevel();
        }

        @Override
        public void setLogLevel(LogLevel level) {
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public Iterator<?> getLogHandler() {
            return Collections.emptyIterator();
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof Slf4jLogAdapter) {
                return this.getName().compareTo(((Slf4jLogAdapter)o).getName());
            }
            return 0;
        }
    }
}

