/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.opennms.netmgt.snmp.snmp4j.OpaqueValueType;
import org.opennms.netmgt.snmp.snmp4j.opaqueadapter.DoubleAdapter;
import org.opennms.netmgt.snmp.snmp4j.opaqueadapter.ErrorAdapter;
import org.opennms.netmgt.snmp.snmp4j.opaqueadapter.OpaqueTypeAdapter;
import org.opennms.netmgt.snmp.snmp4j.opaqueadapter.UnsupportedAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;

public class OpaqueExt
extends Opaque {
    private static final Logger LOG = LoggerFactory.getLogger(OpaqueExt.class);
    private static final byte ID_BITTS = 31;
    private static final byte BITTS_6 = 32;
    private static final byte BITTS_EX_TYPE = 127;
    private OpaqueTypeAdapter adapter = null;

    private OpaqueTypeAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = OpaqueExt.createAdapter(this.getValue());
        }
        return this.adapter;
    }

    public OpaqueExt() {
    }

    public OpaqueExt(byte[] bytes) {
        super(bytes);
    }

    @Override
    public Object clone() {
        OpaqueExt cloned = new OpaqueExt(this.getValue());
        cloned.adapter = this.adapter;
        return cloned;
    }

    @Override
    public String toString() {
        return this.getAdapter().getString();
    }

    public Long getLong() {
        return this.getAdapter().getLong();
    }

    public Double getDouble() {
        return this.getAdapter().getDouble();
    }

    @Override
    public void setValue(OctetString value) {
        super.setValue(value);
        this.adapter = null;
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        super.decodeBER(inputStream);
        this.adapter = null;
    }

    @Override
    public int getSyntax() {
        return 68;
    }

    public OpaqueValueType getValueType() {
        return this.getAdapter().getValueType();
    }

    private static UnsupportedAdapter createUnsupportedAdapter(byte[] bytes) {
        OctetString octetString = new OctetString(bytes);
        LOG.debug("Unsupported bytes provided to OpaqueExt {}", (Object)octetString.toString());
        return new UnsupportedAdapter(octetString);
    }

    private static ErrorAdapter createErrorAdapter(String message, byte[] bytes) {
        if (LOG.isDebugEnabled()) {
            OctetString octetString = new OctetString(bytes);
            LOG.debug("Cannot create TypeAdapter. {} ;, data: {}", (Object)message, (Object)octetString.toString());
        }
        return new ErrorAdapter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OpaqueTypeAdapter createAdapter(byte[] bytes) {
        int offset;
        if (bytes.length < 3) {
            return OpaqueExt.createErrorAdapter("To short", bytes);
        }
        byte type = (byte)(bytes[0] & 0x1F);
        if ((type & 0x20) != 0) {
            return OpaqueExt.createUnsupportedAdapter(bytes);
        }
        if (type != 31) {
            offset = 1;
        } else {
            type = bytes[1];
            if (type >= 127) return OpaqueExt.createUnsupportedAdapter(bytes);
            offset = 2;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes, offset, bytes.length - offset);
        try (BERInputStream is = new BERInputStream(buffer);){
            int length = BER.decodeLength(is);
            if (bytes.length - buffer.position() != length) {
                ErrorAdapter errorAdapter = OpaqueExt.createErrorAdapter("Wrong length of wrapped data", bytes);
                return errorAdapter;
            }
            switch (type) {
                case 120: {
                    if (length == 4) {
                        float floatValue = buffer.getFloat();
                        DoubleAdapter doubleAdapter = new DoubleAdapter(Double.valueOf(floatValue));
                        return doubleAdapter;
                    }
                    if (length != 8) return OpaqueExt.createUnsupportedAdapter(bytes);
                    double doubleValue = buffer.getDouble();
                    DoubleAdapter doubleAdapter = new DoubleAdapter(doubleValue);
                    return doubleAdapter;
                }
            }
            return OpaqueExt.createUnsupportedAdapter(bytes);
        }
        catch (IOException ex) {
            LOG.warn("Unable to create an OpaqueTypeAdapter", (Throwable)ex);
            return new ErrorAdapter();
        }
    }

    @Override
    public boolean isPrintable() {
        OpaqueValueType valueType = this.getAdapter().getValueType();
        if (valueType == OpaqueValueType.ERROR) {
            return false;
        }
        return this.getAdapter().getValueType() == OpaqueValueType.DOUBLE || this.getAdapter().getValueType() == OpaqueValueType.LONG || super.isPrintable();
    }
}

