/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.ua;

import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.Vector;
import org.sblim.slp.Locator;
import org.sblim.slp.ServiceLocationEnumeration;
import org.sblim.slp.ServiceType;
import org.sblim.slp.ServiceURL;
import org.sblim.slp.internal.TRC;
import org.sblim.slp.internal.msg.AttributeRequest;
import org.sblim.slp.internal.msg.ServiceRequest;
import org.sblim.slp.internal.msg.ServiceTypeRequest;
import org.sblim.slp.internal.msg.Util;
import org.sblim.slp.internal.ua.SLEnumerationImpl;

public class LocatorImpl
implements Locator {
    private Locale iLocale;
    private String iLangTag;

    public LocatorImpl(Locale pLocale) {
        this.iLocale = pLocale;
        this.iLangTag = Util.getLangTag(this.iLocale);
        TRC.debug("created, langTag=" + this.iLangTag);
    }

    public ServiceLocationEnumeration findAttributes(ServiceURL pURL, Vector pScopes, Vector pAttributeIds) {
        return this.findAttributes(pURL, pScopes, pAttributeIds, null);
    }

    public ServiceLocationEnumeration findAttributes(ServiceURL pURL, Vector pScopes, Vector pAttributeIds, Vector pDirectoryAgents) {
        return new SLEnumerationImpl(new AttributeRequest(this.iLangTag, (SortedSet)null, pURL.toString(), (List)LocatorImpl.getScopes(pScopes), (List)pAttributeIds, null), pDirectoryAgents);
    }

    public ServiceLocationEnumeration findAttributes(ServiceType pType, Vector pScopes, Vector pAttributeIds) {
        return this.findAttributes(pType, pScopes, pAttributeIds, null);
    }

    public ServiceLocationEnumeration findAttributes(ServiceType pType, Vector pScopes, Vector pAttributeIds, Vector pDirectoryAgents) {
        return new SLEnumerationImpl(new AttributeRequest(this.iLangTag, (SortedSet)null, pType.toString(), (List)LocatorImpl.getScopes(pScopes), (List)pAttributeIds, null), pDirectoryAgents);
    }

    public ServiceLocationEnumeration findServiceTypes(String pNamingAuthority, Vector pScopes) {
        return this.findServiceTypes(pNamingAuthority, pScopes, null);
    }

    public ServiceLocationEnumeration findServiceTypes(String pNamingAuthority, Vector pScopes, Vector pDirectoryAgent) {
        return new SLEnumerationImpl(new ServiceTypeRequest(this.iLangTag, null, pNamingAuthority, (List)LocatorImpl.getScopes(pScopes)), pDirectoryAgent);
    }

    public ServiceLocationEnumeration findServices(ServiceType pType, Vector pScopes, String pSearchFilter) {
        return this.findServices(pType, pScopes, pSearchFilter, null);
    }

    public ServiceLocationEnumeration findServices(ServiceType pType, Vector pScopes, String pSearchFilter, Vector pDirectoryAgents) {
        return new SLEnumerationImpl(new ServiceRequest(this.iLangTag, null, pType, (List)LocatorImpl.getScopes(pScopes), pSearchFilter, null), pDirectoryAgents);
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    private static Vector getScopes(Vector pScopes) {
        if (pScopes == null) {
            pScopes = new Vector<String>();
        }
        if (pScopes.isEmpty()) {
            pScopes.add("default");
        }
        return pScopes;
    }
}

