/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.sblim.slp.internal.TRC;

public class Net {
    private static boolean cHasV6;
    private static boolean cHasV4;
    private static boolean cScanned;

    public static boolean hasIPv6() {
        Net.scan();
        return cHasV6;
    }

    public static boolean hasIPv4() {
        Net.scan();
        return cHasV4;
    }

    private static void scan() {
        if (cScanned) {
            return;
        }
        try {
            cScanned = true;
            Enumeration<NetworkInterface> ifaceEnum = NetworkInterface.getNetworkInterfaces();
            block2: while (ifaceEnum.hasMoreElements()) {
                NetworkInterface iface = ifaceEnum.nextElement();
                Enumeration<InetAddress> addrEnum = iface.getInetAddresses();
                while (addrEnum.hasMoreElements()) {
                    InetAddress addr = addrEnum.nextElement();
                    if (addr instanceof Inet4Address) {
                        cHasV4 = true;
                        if (!cHasV6) continue;
                        break block2;
                    }
                    if (!(addr instanceof Inet6Address)) continue;
                    cHasV6 = true;
                    if (!cHasV4) continue;
                    break block2;
                }
            }
            TRC.info("available IP versions : IPv4:" + cHasV4 + ", IPv6:" + cHasV6);
        }
        catch (SocketException e) {
            TRC.error(e);
        }
    }
}

