/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.AgendaComponentFactory;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Pattern;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;

public abstract class AbstractTerminalNode
extends BaseNode
implements TerminalNode {
    private RuleImpl rule;
    private GroupElement subrule;
    private int subruleIndex;
    private Declaration[] allDeclarations;
    protected Declaration[] requiredDeclarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private LeftTupleSource tupleSource;
    private BitMask declaredMask = EmptyBitMask.get();
    private BitMask inferredMask = EmptyBitMask.get();
    private BitMask negativeMask = EmptyBitMask.get();
    private LeftTupleNode[] pathNodes;
    private transient PathEndNode[] pathEndNodes;
    private SegmentMemory.SegmentPrototype[] segmentPrototypes;
    private SegmentMemory.SegmentPrototype[] eagerSegmentPrototypes;
    protected PathEndNode.PathMemSpec pathMemSpec;
    private int objectCount;

    public AbstractTerminalNode() {
    }

    public AbstractTerminalNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, LeftTupleSource source, BuildContext context, RuleImpl rule, GroupElement subrule, int subruleIndex) {
        super(id, partitionId, partitionsEnabled);
        this.tupleSource = source;
        this.rule = rule;
        this.subrule = subrule;
        this.subruleIndex = subruleIndex;
        this.setObjectCount(this.getLeftTupleSource().getObjectCount());
        context.addPathEndNode(this);
        this.initMemoryId(context);
        this.initDeclaredMask(context);
        this.initInferredMask();
        Map<String, Declaration> decls = this.subrule.getOuterDeclarations();
        this.allDeclarations = decls.values().toArray(new Declaration[decls.size()]);
        this.initDeclarations(decls, context);
    }

    abstract void initDeclarations(Map<String, Declaration> var1, BuildContext var2);

    @Override
    public PathEndNode.PathMemSpec getPathMemSpec() {
        return this.getPathMemSpec(null);
    }

    @Override
    public PathEndNode.PathMemSpec getPathMemSpec(TerminalNode removingTN) {
        if (this.pathMemSpec == null) {
            this.pathMemSpec = this.calculatePathMemSpec(null, removingTN);
        }
        return this.pathMemSpec;
    }

    @Override
    public void resetPathMemSpec(TerminalNode removingTN) {
        Arrays.stream(this.pathEndNodes).forEach(n -> {
            n.nullPathMemSpec();
            n.setSegmentPrototypes(null);
            n.setEagerSegmentPrototypes(null);
        });
        this.pathMemSpec = removingTN == null ? null : this.calculatePathMemSpec(null, removingTN);
    }

    @Override
    public RuleImpl getRule() {
        return this.rule;
    }

    @Override
    public GroupElement getSubRule() {
        return this.subrule;
    }

    @Override
    public int getSubruleIndex() {
        return this.subruleIndex;
    }

    @Override
    public Declaration[] getAllDeclarations() {
        return this.allDeclarations;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    @Override
    public void nullPathMemSpec() {
        this.pathMemSpec = null;
    }

    @Override
    public void setPathEndNodes(PathEndNode[] pathEndNodes) {
        this.pathEndNodes = pathEndNodes;
    }

    @Override
    public PathEndNode[] getPathEndNodes() {
        return this.pathEndNodes;
    }

    @Override
    public void setSegmentPrototypes(SegmentMemory.SegmentPrototype[] smems) {
        this.segmentPrototypes = smems;
    }

    @Override
    public SegmentMemory.SegmentPrototype[] getSegmentPrototypes() {
        return this.segmentPrototypes;
    }

    @Override
    public SegmentMemory.SegmentPrototype[] getEagerSegmentPrototypes() {
        return this.eagerSegmentPrototypes;
    }

    @Override
    public void setEagerSegmentPrototypes(SegmentMemory.SegmentPrototype[] eagerSegmentPrototypes) {
        this.eagerSegmentPrototypes = eagerSegmentPrototypes;
    }

    @Override
    public int getPathIndex() {
        return this.tupleSource.getPathIndex() + 1;
    }

    @Override
    public int getObjectCount() {
        return this.objectCount;
    }

    @Override
    public void setObjectCount(int count) {
        this.objectCount = count;
    }

    protected void initDeclaredMask(BuildContext context) {
        if (!(this.unwrapTupleSource() instanceof LeftInputAdapterNode)) {
            this.setDeclaredMask(AllSetBitMask.get());
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        ObjectType objectType = pattern.getObjectType();
        if (PropertySpecificUtil.isPropertyReactive(context, objectType)) {
            List<String> accessibleProperties = pattern.getAccessibleProperties(context.getRuleBase());
            this.setDeclaredMask(pattern.getPositiveWatchMask(accessibleProperties));
            this.setNegativeMask(pattern.getNegativeWatchMask(accessibleProperties));
        } else {
            this.setDeclaredMask(AllSetBitMask.get());
        }
    }

    @Override
    public void initInferredMask() {
        LeftTupleSource leftTupleSource = this.unwrapTupleSource();
        if (leftTupleSource instanceof LeftInputAdapterNode && ((LeftInputAdapterNode)leftTupleSource).getParentObjectSource() instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)((LeftInputAdapterNode)leftTupleSource).getParentObjectSource();
            this.setInferredMask(alphaNode.updateMask(this.getDeclaredMask()));
        } else {
            this.setInferredMask(this.getDeclaredMask());
        }
        this.setInferredMask(this.getInferredMask().resetAll(this.getNegativeMask()));
        if (this.getNegativeMask().isAllSet() && !this.getDeclaredMask().isAllSet()) {
            this.setInferredMask(this.getInferredMask().setAll(this.getDeclaredMask()));
        }
    }

    @Override
    public LeftTupleSource unwrapTupleSource() {
        return this.tupleSource instanceof FromNode ? this.tupleSource.getLeftTupleSource() : this.tupleSource;
    }

    @Override
    public PathMemory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        return AbstractTerminalNode.initPathMemory(this, new PathMemory(this, reteEvaluator));
    }

    public static PathMemory initPathMemory(PathEndNode pathEndNode, PathMemory pmem) {
        PathEndNode.PathMemSpec pathMemSpec = pathEndNode.getPathMemSpec();
        pmem.setAllLinkedMaskTest(pathMemSpec.allLinkedTestMask);
        pmem.setSegmentMemories(new SegmentMemory[pathEndNode.getPathMemSpec().smemCount()]);
        return pmem;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        RuleTerminalNodeLeftTuple peer = (RuleTerminalNodeLeftTuple)AgendaComponentFactory.get().createTerminalTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        this.getLeftTupleSource().removeTupleSink(this);
        this.tupleSource = null;
        return true;
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    @Override
    public BitMask getDeclaredMask() {
        return this.declaredMask;
    }

    @Override
    public BitMask getInferredMask() {
        return this.inferredMask;
    }

    @Override
    public BitMask getLeftInferredMask() {
        return this.inferredMask;
    }

    @Override
    public void setDeclaredMask(BitMask mask) {
        this.declaredMask = mask;
    }

    @Override
    public void setInferredMask(BitMask mask) {
        this.inferredMask = mask;
    }

    @Override
    public BitMask getNegativeMask() {
        return this.negativeMask;
    }

    @Override
    public void setNegativeMask(BitMask mask) {
        this.negativeMask = mask;
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.getLeftTupleSource().networkUpdated(updateContext);
    }

    @Override
    public boolean isInUse() {
        return false;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public static LeftTupleNode[] getPathNodes(PathEndNode endNode) {
        LeftTupleNode[] pathNodes = new LeftTupleNode[endNode.getPathIndex() + 1];
        for (LeftTupleNode node = endNode; node != null; node = node.getLeftTupleSource()) {
            pathNodes[node.getPathIndex()] = node;
        }
        return pathNodes;
    }

    @Override
    public LeftTupleNode[] getPathNodes() {
        if (this.pathNodes == null) {
            this.pathNodes = AbstractTerminalNode.getPathNodes(this);
        }
        return this.pathNodes;
    }

    @Override
    public final boolean hasPathNode(LeftTupleNode node) {
        for (LeftTupleNode pathNode : this.getPathNodes()) {
            if (node.getId() != pathNode.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isTerminalNodeOf(LeftTupleNode node) {
        for (PathEndNode pathEndNode : this.getPathEndNodes()) {
            if (!pathEndNode.hasPathNode(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LeftTupleSinkPropagator getSinkPropagator() {
        return EmptyLeftTupleSinkAdapter.getInstance();
    }

    @Override
    public final void setPartitionIdWithSinks(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        return this.getLeftTupleSource().getObjectTypeNode();
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public void visitLeftTupleNodes(Consumer<LeftTupleNode> func) {
        for (PathEndNode endNode : this.getPathEndNodes()) {
            for (LeftTupleNode node : endNode.getPathNodes()) {
                func.accept(node);
            }
        }
    }

    protected int calculateHashCode() {
        return 31 * (31 + this.rule.hashCode()) + this.subruleIndex;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RuleTerminalNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        TerminalNode other = (TerminalNode)object;
        return this.getRule().equals(other.getRule()) && this.getSubruleIndex() == other.getSubruleIndex();
    }
}

