/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.configuration;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public interface GraphCacheStrategy {
    public static final TimedGraphCacheStrategy DEFAULT = GraphCacheStrategy.TIMED(5, TimeUnit.MINUTES);
    public static final GraphCacheStrategy FOREVER = new GraphCacheStrategy(){};

    public static TimedGraphCacheStrategy TIMED(int duration, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        if (duration <= 0) {
            throw new IllegalArgumentException("duration must be > 0");
        }
        return () -> timeUnit.toSeconds(duration);
    }

    public static interface TimedGraphCacheStrategy
    extends GraphCacheStrategy {
        public long getCacheReloadIntervalInSeconds();
    }
}

