/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.schema;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import liquibase.resource.ResourceAccessor;
import org.springframework.core.io.Resource;

public class ExistingResourceAccessor
implements ResourceAccessor {
    private final Resource m_resource;

    public ExistingResourceAccessor() {
        this.m_resource = null;
    }

    public ExistingResourceAccessor(Resource resource) {
        this.m_resource = resource;
    }

    public Set<InputStream> getResourcesAsStream(String path) throws IOException {
        if (this.m_resource == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.m_resource.createRelative(path).getInputStream());
    }

    public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        throw new UnsupportedOperationException("Unnecessary; not used in temporary database resource access.");
    }

    public ClassLoader toClassLoader() {
        throw new UnsupportedOperationException("Unnecessary; not used in temporary database resource access.");
    }

    public String toString() {
        return this.m_resource == null ? "null" : this.m_resource.toString();
    }
}

