/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.opennms.createindex;

import liquibase.database.Database;
import liquibase.ext.opennms.createindex.CreateIndexWithWhereStatement;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateIndexGenerator;
import liquibase.statement.core.CreateIndexStatement;
import liquibase.structure.DatabaseObject;

public class CreateIndexWithWhereGenerator
extends CreateIndexGenerator {
    private static final Logger LOG = LogService.getLog(CreateIndexWithWhereGenerator.class);

    public int getPriority() {
        return super.getPriority() + 1;
    }

    public Sql[] generateSql(CreateIndexStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Sql[] superSql = super.generateSql(statement, database, sqlGeneratorChain);
        if (statement instanceof CreateIndexWithWhereStatement) {
            if (superSql.length != 1) {
                LOG.warning("expected 1 create index statement, but got " + superSql.length);
                return superSql;
            }
            return new Sql[]{new UnparsedSql(superSql[0].toSql() + " WHERE " + ((CreateIndexWithWhereStatement)statement).getWhere(), superSql[0].getEndDelimiter(), superSql[0].getAffectedDatabaseObjects().toArray(new DatabaseObject[0]))};
        }
        return superSql;
    }
}

