/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import com.google.common.collect.Table;
import java.util.Map;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.common.TopologyUpdater;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.LldpElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.LldpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.LldpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class LldpOnmsTopologyUpdater
extends TopologyUpdater {
    private final LldpTopologyService m_lldpTopologyService;

    public static LldpOnmsTopologyUpdater clone(LldpOnmsTopologyUpdater bpu) {
        LldpOnmsTopologyUpdater update = new LldpOnmsTopologyUpdater(bpu.getTopologyDao(), bpu.getLldpTopologyService(), bpu.getNodeTopologyService());
        update.setRunned(bpu.isRunned());
        update.setTopology(bpu.getTopology());
        return update;
    }

    public static OnmsTopologyPort create(OnmsTopologyVertex source, LldpLinkTopologyEntity sourceLink, LldpLinkTopologyEntity targetlink, SnmpInterfaceTopologyEntity snmpiface) {
        OnmsTopologyPort port = OnmsTopologyPort.create((String)sourceLink.getId().toString(), (OnmsTopologyVertex)source, (Integer)sourceLink.getLldpPortIfindex());
        port.setIfindex(sourceLink.getLldpPortIfindex());
        if (snmpiface != null) {
            port.setIfname(snmpiface.getIfName());
        } else if (sourceLink.getLldpPortIdSubType() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME) {
            port.setIfname(sourceLink.getLldpPortId());
        } else if (targetlink.getLldpRemPortIdSubType() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME) {
            port.setIfname(targetlink.getLldpRemPortId());
        } else if (!"".equals(sourceLink.getLldpPortDescr())) {
            port.setIfname(sourceLink.getLldpPortDescr());
        } else if (!"".equals(targetlink.getLldpRemPortDescr())) {
            port.setIfname(targetlink.getLldpRemPortDescr());
        } else {
            port.setIfname(sourceLink.getLldpPortId());
        }
        port.setAddr(Topology.getRemoteAddress((LldpLinkTopologyEntity)targetlink));
        port.setToolTipText(Topology.getPortTextString((String)source.getLabel(), (Integer)port.getIfindex(), (String)port.getAddr(), (SnmpInterfaceTopologyEntity)snmpiface));
        return port;
    }

    public LldpOnmsTopologyUpdater(OnmsTopologyDao topologyDao, LldpTopologyService lldpTopologyService, NodeTopologyService nodeTopologyService) {
        super((TopologyService)lldpTopologyService, topologyDao, nodeTopologyService);
        this.m_lldpTopologyService = lldpTopologyService;
    }

    public String getName() {
        return "LldpTopologyUpdater";
    }

    public OnmsTopology buildTopology() {
        Map nodeMap = this.getNodeMap();
        Map ipMap = this.getIpPrimaryMap();
        Table nodeToOnmsSnmpTable = this.getSnmpInterfaceTable();
        OnmsTopology topology = new OnmsTopology();
        for (LldpElementTopologyEntity element : this.m_lldpTopologyService.findAllLldpElements()) {
            topology.getVertices().add(LldpOnmsTopologyUpdater.create((NodeTopologyEntity)((NodeTopologyEntity)nodeMap.get(element.getNodeId())), (IpInterfaceTopologyEntity)((IpInterfaceTopologyEntity)ipMap.get(element.getNodeId()))));
        }
        for (TopologyConnection pair : this.m_lldpTopologyService.match()) {
            topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getDefaultEdgeId((int)((LldpLinkTopologyEntity)pair.getLeft()).getId(), (int)((LldpLinkTopologyEntity)pair.getRight()).getId()), (OnmsTopologyPort)LldpOnmsTopologyUpdater.create(topology.getVertex(((LldpLinkTopologyEntity)pair.getLeft()).getNodeIdAsString()), (LldpLinkTopologyEntity)pair.getLeft(), (LldpLinkTopologyEntity)pair.getRight(), (SnmpInterfaceTopologyEntity)nodeToOnmsSnmpTable.get((Object)((LldpLinkTopologyEntity)pair.getLeft()).getNodeId(), (Object)((LldpLinkTopologyEntity)pair.getLeft()).getLldpPortIfindex())), (OnmsTopologyPort)LldpOnmsTopologyUpdater.create(topology.getVertex(((LldpLinkTopologyEntity)pair.getRight()).getNodeIdAsString()), (LldpLinkTopologyEntity)pair.getRight(), (LldpLinkTopologyEntity)pair.getLeft(), (SnmpInterfaceTopologyEntity)nodeToOnmsSnmpTable.get((Object)((LldpLinkTopologyEntity)pair.getRight()).getNodeId(), (Object)((LldpLinkTopologyEntity)pair.getRight()).getLldpPortIfindex()))));
        }
        return topology;
    }

    public OnmsTopologyProtocol getProtocol() {
        return LldpOnmsTopologyUpdater.create((ProtocolSupported)ProtocolSupported.LLDP);
    }

    public LldpTopologyService getLldpTopologyService() {
        return this.m_lldpTopologyService;
    }
}

