/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdTopologyFactory;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkdTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    public static final String TOPOLOGY_NAMESPACE_LINKD = "nodes";
    private static final Logger LOG = LoggerFactory.getLogger(LinkdTopologyProvider.class);
    private final LinkdTopologyFactory m_linkdTopologyFactory;
    private final Set<ProtocolSupported> m_supportedSet;

    public LinkdTopologyProvider(LinkdTopologyFactory linkdTopologyFactory) {
        this(TOPOLOGY_NAMESPACE_LINKD, LinkdTopologyFactory.getProtocolSupportedSet(ProtocolSupported.NODES.name(), ProtocolSupported.LLDP.name(), ProtocolSupported.CDP.name(), ProtocolSupported.BRIDGE.name(), ProtocolSupported.OSPF.name(), ProtocolSupported.ISIS.name(), ProtocolSupported.USERDEFINED.name()), linkdTopologyFactory);
        linkdTopologyFactory.setDelegate(this);
        LOG.info("Created delegate instance namespace {}, protocols {}", (Object)TOPOLOGY_NAMESPACE_LINKD, this.m_supportedSet);
    }

    public LinkdTopologyProvider(String name, LinkdTopologyFactory linkdTopologyFactory) {
        this("nodes:" + name, LinkdTopologyFactory.getProtocolSupportedSet(name), linkdTopologyFactory);
    }

    public LinkdTopologyProvider(String name, LinkdTopologyFactory linkdTopologyFactory, List<String> protocols) {
        this("nodes:" + name, LinkdTopologyFactory.getProtocolSupportedSet(protocols.toArray(new String[0])), linkdTopologyFactory);
    }

    private LinkdTopologyProvider(String namespace, Set<ProtocolSupported> protocolSupportedSet, LinkdTopologyFactory factory) {
        super(namespace);
        this.m_linkdTopologyFactory = Objects.requireNonNull(factory);
        this.m_supportedSet = protocolSupportedSet;
        LOG.info("Created instance namespace {}, protocols {}", (Object)namespace, this.m_supportedSet);
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return this.m_linkdTopologyFactory.getSelection(selectedVertices, type);
    }

    public boolean contributesTo(ContentType type) {
        return this.m_linkdTopologyFactory.contributesTo(type);
    }

    public Defaults getDefaults() {
        return this.m_linkdTopologyFactory.getDefaults(this.graph);
    }

    public void refresh() {
        LOG.info("refresh: {}: protocolSupported: {}", (Object)this.getNamespace(), this.m_supportedSet);
        this.m_linkdTopologyFactory.setDelegate(this);
        this.graph.resetContainer();
        this.m_linkdTopologyFactory.doRefresh(this.m_supportedSet, this.graph);
        LOG.info("refresh: {}: Found {} vertices", (Object)this.getNamespace(), (Object)this.graph.getVertices(new Criteria[0]).size());
        LOG.info("refresh: {}: Found {} edges", (Object)this.getNamespace(), (Object)this.graph.getEdges(new Criteria[0]).size());
    }

    public Set<ProtocolSupported> getProtocolSupported() {
        return this.m_supportedSet;
    }
}

