/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotFile {
    private static final Logger log = LoggerFactory.getLogger(SnapshotFile.class);
    public final long offset;
    private volatile File file;

    public SnapshotFile(File file) {
        this(file, LogFileUtils.offsetFromFileName(file.getName()));
    }

    public SnapshotFile(File file, long offset) {
        this.file = file;
        this.offset = offset;
    }

    public boolean deleteIfExists() throws IOException {
        boolean deleted = Files.deleteIfExists(this.file.toPath());
        if (deleted) {
            log.info("Deleted producer state snapshot {}", (Object)this.file.getAbsolutePath());
        } else {
            log.info("Failed to delete producer state snapshot {} because it does not exist.", (Object)this.file.getAbsolutePath());
        }
        return deleted;
    }

    public void updateParentDir(File parentDir) {
        String name = this.file.getName();
        this.file = new File(parentDir, name);
    }

    public File file() {
        return this.file;
    }

    public void renameTo(String newSuffix) throws IOException {
        File renamed = new File(Utils.replaceSuffix((String)this.file.getPath(), (String)"", (String)newSuffix));
        try {
            Utils.atomicMoveWithFallback((Path)this.file.toPath(), (Path)renamed.toPath());
        }
        finally {
            this.file = renamed;
        }
    }

    public String toString() {
        return "SnapshotFile(offset=" + this.offset + ", file=" + this.file + ')';
    }
}

