/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.felix.utils.properties.Properties;
import org.apache.felix.utils.properties.TypedProperties;

public final class Utils {
    private Utils() {
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalStateException(message);
        }
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static void assertFalse(boolean condition, String message) {
        if (condition) {
            throw new IllegalStateException(message);
        }
    }

    public static String join(CharSequence sep, Iterable<? extends CharSequence> strings) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence charSequence : strings) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(charSequence);
        }
        return sb.toString();
    }

    public static byte[] toBytes(TypedProperties source) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            source.save(baos);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot store properties", ex);
        }
        return baos.toByteArray();
    }

    public static byte[] toBytes(Properties source) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            source.save(baos);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot store properties", ex);
        }
        return baos.toByteArray();
    }

    public static byte[] toBytes(Map<String, Object> source) {
        return Utils.toBytes(Utils.toProperties(source));
    }

    public static TypedProperties toProperties(byte[] source) {
        try {
            TypedProperties rc = new TypedProperties(false);
            if (source != null) {
                rc.load(new ByteArrayInputStream(source));
            }
            return rc;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot load properties", ex);
        }
    }

    public static TypedProperties toProperties(Map<String, Object> source) {
        if (source instanceof TypedProperties) {
            return (TypedProperties)source;
        }
        TypedProperties rc = new TypedProperties(false);
        rc.putAll(source);
        return rc;
    }

    public static String stripSuffix(String value, String suffix) {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }
}

