/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.IndexedPropertyImp;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import com.atomikos.beans.PropertyImp;
import com.atomikos.beans.ReadOnlyException;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class BeanInspector {
    private Object bean_;

    public BeanInspector(Object bean) {
        this.bean_ = bean;
    }

    public Property[] getProperties() throws PropertyException {
        Property[] ret = null;
        try {
            PropertyDescriptor[] props;
            Class<?> clazz = this.bean_.getClass();
            BeanInfo info = Introspector.getBeanInfo(clazz);
            if (info != null && (props = info.getPropertyDescriptors()) != null) {
                ret = new Property[props.length];
                for (int i = 0; i < props.length; ++i) {
                    if (props[i] instanceof IndexedPropertyDescriptor) {
                        IndexedPropertyDescriptor d = (IndexedPropertyDescriptor)props[i];
                        ret[i] = new IndexedPropertyImp(this.bean_, d);
                        continue;
                    }
                    ret[i] = new PropertyImp(this.bean_, props[i]);
                }
            }
        }
        catch (Exception e) {
            throw new PropertyException("Error getting properties", e);
        }
        return ret;
    }

    public Property getProperty(String name) throws PropertyException {
        Property ret = null;
        Property[] properties = this.getProperties();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                if (!properties[i].getName().equals(name)) continue;
                ret = properties[i];
            }
        }
        return ret;
    }

    public Object getBean() {
        return this.bean_;
    }

    public void setPropertyValue(String name, String value) throws ReadOnlyException, PropertyException {
        Property p = this.getProperty(name);
        if (p == null) {
            throw new PropertyException("No such property: " + name);
        }
        p.getEditor().setStringValue(value);
        p.setValue(p.getEditor().getEditedObject());
    }

    public String getPropertyValue(String name) throws PropertyException {
        String ret = "";
        Property p = this.getProperty(name);
        Object val = p.getValue();
        if (val != null) {
            ret = val.toString();
        }
        return ret;
    }
}

