/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.ide;

import io.hawt.ide.IdeFacadeMBean;
import io.hawt.util.IOHelper;
import io.hawt.util.MBeanSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdeFacade
extends MBeanSupport
implements IdeFacadeMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(IdeFacade.class);
    private static IdeFacade singleton;
    private File baseDir;

    public static IdeFacade getSingleton() {
        if (singleton == null) {
            LOG.warn("No IdeFacade constructed yet so using default configuration for now");
            singleton = new IdeFacade();
        }
        return singleton;
    }

    public void init() throws Exception {
        singleton = this;
        super.init();
    }

    protected String getDefaultObjectName() {
        return "hawtio:type=IdeFacade";
    }

    public File getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = new File(System.getProperty("basedir", "."));
        }
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public String findClassAbsoluteFileName(String fileName, String className, List<String> sourceRoots) {
        String answer;
        block2: {
            String sourceRoot;
            File baseDir;
            int lastIdx = className.lastIndexOf(46);
            if (lastIdx > 0 && !fileName.contains("/") && !fileName.contains(File.separator)) {
                String packagePath = className.substring(0, lastIdx).replace('.', File.separatorChar);
                fileName = packagePath + File.separator + fileName;
            }
            if ((answer = this.findInSourceFolders(baseDir = this.getBaseDir(), fileName)) != null || sourceRoots == null) break block2;
            Iterator<String> iterator = sourceRoots.iterator();
            while (iterator.hasNext() && (answer = this.findInSourceFolders(new File(sourceRoot = iterator.next()), fileName)) == null) {
            }
        }
        return answer;
    }

    protected String findInSourceFolders(File baseDir, String fileName) {
        String answer = this.findInFolder(baseDir, fileName);
        if (answer == null && baseDir.exists() && (answer = this.findInChildFolders(new File(baseDir, "src/main"), fileName)) == null) {
            answer = this.findInChildFolders(new File(baseDir, "src/test"), fileName);
        }
        return answer;
    }

    protected String findInChildFolders(File dir, String fileName) {
        File[] files;
        String answer = this.findInFolder(dir, fileName);
        if (answer == null && this.isDirectory(dir) && (files = dir.listFiles()) != null) {
            File file;
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n && (answer = this.findInFolder(file = fileArray[i], fileName)) == null; ++i) {
            }
        }
        return answer;
    }

    protected String findInFolder(File dir, String relativeName) {
        File file;
        if (this.isDirectory(dir) && (file = new File(dir, relativeName)).exists() && file.isFile()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private boolean isDirectory(File dir) {
        return dir.exists() && dir.isDirectory();
    }

    @Override
    public String ideaOpenAndNavigate(String fileName, int line, int column) throws Exception {
        if (line < 0) {
            line = 0;
        }
        if (column < 0) {
            column = 0;
        }
        String xml = "<?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\n<methodCall>\n  <methodName>fileOpener.openAndNavigate</methodName>\n  <params>\n    <param><value><string>" + fileName + "</string></value></param>\n    <param><value><int>" + line + "</int></value></param>\n    <param><value><int>" + column + "</int></value></param>\n  </params>\n</methodCall>\n";
        return this.ideaXmlRpc(xml);
    }

    @Override
    public String ideaOpen(String fileName) throws Exception {
        String xml = "<?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\n<methodCall>\n  <methodName>fileOpener.open</methodName>\n  <params>\n    <param><value><string>" + fileName + "</string></value></param>\n  </params>\n</methodCall>\n";
        return this.ideaXmlRpc(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String ideaXmlRpc(String xml) throws IOException {
        String charset = "UTF-8";
        HttpURLConnection connection = (HttpURLConnection)new URL("http://localhost:63342").openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("accept-charset", charset);
        connection.setRequestProperty("Content-Type", "text/xml");
        byte[] bytes = xml.getBytes();
        connection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
        OutputStream os = null;
        Object writer = null;
        try {
            os = connection.getOutputStream();
            os.write(bytes);
            String string = IOHelper.readFully((BufferedReader)new BufferedReader(new InputStreamReader(connection.getInputStream())));
            return string;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

