/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.util.SessionProperties;

public class ThreadPool {
    private ThreadGroup iGroup;
    private List iIdleThreads = new LinkedList();
    private List iThreadPool = new LinkedList();
    private List iQueue = new LinkedList();
    private long iIdleTimeout = 30000L;
    private int iMaxPoolSize;
    private int iMinPoolSize;
    private int iCntr = 0;
    private boolean iShutdown = false;
    private String iWorkerName;

    public ThreadPool(int pMinPoolSize, int pMaxPoolSize, ThreadGroup pGroup, String pWorkerName) {
        this.iGroup = pGroup != null ? pGroup : new ThreadGroup("TreadPool Group");
        this.iMinPoolSize = pMinPoolSize;
        this.iMaxPoolSize = pMaxPoolSize;
        this.iWorkerName = pWorkerName != null ? pWorkerName : "Worker ";
        for (int i = 0; i < pMinPoolSize; ++i) {
            Worker worker = new Worker(this, this.iWorkerName + this.getID());
            this.iThreadPool.add(worker);
            worker.start();
        }
    }

    public synchronized long getIdleTimeOutMs() {
        return this.iThreadPool.size() <= this.iMinPoolSize ? -1L : this.iIdleTimeout;
    }

    public boolean execute(Runnable task) {
        return this.execute(task, true);
    }

    public synchronized boolean execute(Runnable task, boolean enqueue) {
        if (this.iShutdown) {
            return false;
        }
        int totalIdle = this.iIdleThreads.size();
        if (totalIdle > 0) {
            Worker worker = (Worker)this.iIdleThreads.remove(totalIdle - 1);
            return worker.assignTask(task);
        }
        if (this.iMaxPoolSize == -1 || this.iThreadPool.size() <= this.iMaxPoolSize) {
            Worker worker = this.createWorker();
            return worker.assignTask(task);
        }
        if (enqueue) {
            this.iQueue.add(task);
            return true;
        }
        return false;
    }

    private Worker createWorker() {
        Worker worker = new Worker(this, this.iWorkerName + this.getID());
        this.iThreadPool.add(worker);
        return worker;
    }

    protected ThreadGroup getGroup() {
        return this.iGroup;
    }

    public synchronized boolean taskCompleted(Worker worker, boolean timedOut) {
        if (this.iShutdown) {
            return false;
        }
        if (this.iQueue.size() > 0) {
            this.iIdleThreads.remove(worker);
            worker.assignTask((Runnable)this.iQueue.remove(0));
            return true;
        }
        if (timedOut && this.iThreadPool.size() > this.iMinPoolSize) {
            this.iIdleThreads.remove(worker);
            this.iThreadPool.remove(worker);
            return false;
        }
        if (this.iMaxPoolSize == -1 || this.iThreadPool.size() <= this.iMaxPoolSize) {
            if (!this.iIdleThreads.contains(worker)) {
                this.iIdleThreads.add(worker);
            }
            worker.setIdleTimeout(this.getIdleTimeOutMs());
            return true;
        }
        return false;
    }

    protected synchronized void removeThread(Worker worker) {
        if (worker != null && this.iThreadPool != null) {
            this.iThreadPool.remove(worker);
        }
    }

    public synchronized void shutdown() {
        if (!this.iShutdown) {
            Worker worker;
            Iterator iter;
            this.iShutdown = true;
            if (this.iIdleThreads != null) {
                iter = this.iIdleThreads.iterator();
                while (iter.hasNext()) {
                    worker = (Worker)iter.next();
                    worker.kill();
                }
                this.iIdleThreads = null;
            }
            if (this.iThreadPool != null) {
                iter = this.iThreadPool.iterator();
                while (iter.hasNext()) {
                    worker = (Worker)iter.next();
                    worker.kill();
                }
                this.iThreadPool = null;
            }
        }
    }

    private String getID() {
        if (++this.iCntr >= 10000) {
            this.iCntr = 1;
        }
        return String.valueOf(this.iCntr);
    }

    private static class Worker
    extends Thread {
        private boolean iAlive = true;
        private boolean iStarted;
        private ThreadPool iPool;
        private Runnable iTask;
        private long iIdleTimeout;
        private boolean iTimedOut = false;

        public Worker(ThreadPool pool, String name) {
            super(pool.getGroup(), name);
            this.iPool = pool;
            this.setDaemon(true);
        }

        public synchronized void start() {
            this.iStarted = true;
            this.iAlive = true;
            super.start();
        }

        public synchronized void kill() {
            this.iAlive = false;
            this.iStarted = false;
            this.notify();
        }

        public synchronized boolean assignTask(Runnable task) {
            if (this.iAlive) {
                this.iTask = task;
                if (!this.iStarted) {
                    this.start();
                } else {
                    this.notify();
                }
                return true;
            }
            return false;
        }

        public long getIdleTimeout() {
            return this.iIdleTimeout;
        }

        public void setIdleTimeout(long pIdleTimeout) {
            this.iIdleTimeout = pIdleTimeout;
        }

        private synchronized Runnable waitForTask() {
            if (this.iTask != null) {
                Runnable tsk = this.iTask;
                this.iTask = null;
                return tsk;
            }
            this.iAlive = this.iPool.taskCompleted(this, this.iTimedOut);
            if (this.iAlive && this.iTask == null) {
                try {
                    long idleTimeOut = this.getIdleTimeout();
                    if (idleTimeOut > 0L) {
                        this.wait(idleTimeOut);
                        this.iTimedOut = this.iTask == null;
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }

        public void run() {
            while (this.iAlive) {
                Runnable tsk = this.waitForTask();
                if (tsk == null) continue;
                try {
                    tsk.run();
                }
                catch (Throwable t) {
                    Logger logger = SessionProperties.getGlobalProperties().getLogger();
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logger.log(Level.SEVERE, "Exception while executing task from thread pool", t);
                }
            }
            this.iStarted = false;
            this.iPool.removeThread(this);
        }
    }
}

