/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.AuthInfo;
import org.sblim.wbem.http.Challenge;
import org.sblim.wbem.util.SessionProperties;

public class PegasusLocalAuthInfo
extends AuthInfo {
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String OS_NAME = "os.name";
    private static final String Z_OS = "z/OS";
    private boolean iChallenged = false;

    public void updateAuthenticationInfo(Challenge challenge, String authenticate, URI url, String requestMethod) throws NoSuchAlgorithmException {
        this.iChallenged = true;
        this.iResponse = authenticate;
    }

    public String toString() {
        block6: {
            if (this.iChallenged && this.iResponse != null && this.iResponse.startsWith("Local ")) {
                try {
                    String line;
                    String fileName = this.iResponse.substring(7, this.iResponse.length() - 1);
                    if (fileName.length() == 0) {
                        throw new IOException("No local auth file specified");
                    }
                    File authorizationFile = new File(fileName);
                    if (!authorizationFile.canRead()) {
                        throw new IOException("Local auth file not accessible");
                    }
                    BufferedReader in = Z_OS.equals(System.getProperty(OS_NAME)) ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(authorizationFile), ISO_8859_1)) : new BufferedReader(new FileReader(authorizationFile));
                    StringBuffer buffer = new StringBuffer();
                    while ((line = in.readLine()) != null) {
                        buffer.append(line);
                    }
                    in.close();
                    StringBuffer header = new StringBuffer();
                    header.append("Local \"");
                    header.append(this.getCredentials().getUserName());
                    header.append(':');
                    header.append(fileName);
                    header.append(':');
                    header.append(buffer);
                    header.append('\"');
                    return header.toString();
                }
                catch (IOException e) {
                    Logger logger = SessionProperties.getGlobalProperties().getLogger();
                    if (!logger.isLoggable(Level.WARNING)) break block6;
                    logger.log(Level.WARNING, "Could not read pegasus local auth file", e);
                }
            }
        }
        return "Local \"" + this.getCredentials().getUserName() + "\"";
    }

    public String getHeaderFieldName() {
        return "PegasusAuthorization";
    }

    public boolean isSentOnFirstRequest() {
        return true;
    }

    public boolean isKeptAlive() {
        return true;
    }
}

