/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sblim.wbem.cim.CIMAuthenticationException;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMTransportException;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.BatchHandle;
import org.sblim.wbem.client.BatchResult;
import org.sblim.wbem.client.CIMEnumeration;
import org.sblim.wbem.client.CIMEnumerationImpl;
import org.sblim.wbem.client.CIMOMHandle;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.indications.CIMEventDispatcher;
import org.sblim.wbem.client.indications.CIMIndicationHandler;
import org.sblim.wbem.client.indications.CIMIndicationListenertList;
import org.sblim.wbem.client.indications.CIMListener;
import org.sblim.wbem.client.operations.CIMAssociatorNamesOp;
import org.sblim.wbem.client.operations.CIMAssociatorsOp;
import org.sblim.wbem.client.operations.CIMCreateNameSpaceOp;
import org.sblim.wbem.client.operations.CIMDeleteNameSpaceOp;
import org.sblim.wbem.client.operations.CIMEnumClassNamesOp;
import org.sblim.wbem.client.operations.CIMEnumClassesOp;
import org.sblim.wbem.client.operations.CIMEnumInstanceNamesOp;
import org.sblim.wbem.client.operations.CIMEnumInstancesOp;
import org.sblim.wbem.client.operations.CIMEnumNameSpaceOp;
import org.sblim.wbem.client.operations.CIMEnumQualifierTypesOp;
import org.sblim.wbem.client.operations.CIMExecQueryOp;
import org.sblim.wbem.client.operations.CIMGetClassOp;
import org.sblim.wbem.client.operations.CIMGetInstanceOp;
import org.sblim.wbem.client.operations.CIMGetPropertyOp;
import org.sblim.wbem.client.operations.CIMGetQualifierTypeOp;
import org.sblim.wbem.client.operations.CIMInvokeMethodOp;
import org.sblim.wbem.client.operations.CIMOperation;
import org.sblim.wbem.client.operations.CIMReferenceNamesOp;
import org.sblim.wbem.client.operations.CIMReferencesOp;
import org.sblim.wbem.http.AuthInfo;
import org.sblim.wbem.http.AuthorizationHandler;
import org.sblim.wbem.http.HttpClientPool;
import org.sblim.wbem.http.HttpConnectionHandler;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpHeaderParser;
import org.sblim.wbem.http.HttpServerConnection;
import org.sblim.wbem.http.HttpUrlConnection;
import org.sblim.wbem.http.io.DebugInputStream;
import org.sblim.wbem.util.Benchmark;
import org.sblim.wbem.util.SessionProperties;
import org.sblim.wbem.xml.CIMClientXML_HelperImpl;
import org.sblim.wbem.xml.CIMResponse;
import org.sblim.wbem.xml.CIMXMLParserImpl;
import org.sblim.wbem.xml.XMLDefaultHandlerImpl;
import org.sblim.wbem.xml.parser.XMLPullParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CIMClientXML
implements CIMOMHandle {
    private static final String CLASSNAME = "org.sblim.wbem.client.CIMClientXML";
    private URI iUri;
    private CIMIndicationListenertList iIndicationClient;
    private HttpServerConnection iIndicationServer = null;
    private Object iLock = new Object();
    private int iCounter = 0;
    private int iNsCounter = 1;
    private CIMClientXML_HelperImpl iXmlHelper = null;
    private CIMNameSpace iNamespace;
    private HttpUrlConnection iConnection;
    private boolean iUseMPost = true;
    private boolean iMPostFailed = false;
    private volatile long iMPostFailTime = 0L;
    private volatile long iCurrentTime = 0L;
    private boolean iUseHttp11 = true;
    private Locale iLocale = Locale.getDefault();
    private HttpClientPool iHttpClientPool = new HttpClientPool();
    private AuthorizationHandler iAuthorizationHandler;
    private String iAuthorization;
    private Logger iLogger = null;
    private SessionProperties iSessionProperties;

    public CIMClientXML(CIMNameSpace pNamespace, Principal pPrincipal, Object pCredential, String pProtocol) throws CIMException {
        this(pNamespace, pPrincipal, pCredential, pProtocol, null);
    }

    public CIMClientXML(CIMNameSpace pNamespace, Principal pPrincipal, Object pCredential, String pProtocol, SessionProperties pProperties) throws CIMException {
        try {
            this.init(pNamespace, pPrincipal, pCredential, pProtocol, pProperties);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void init(CIMNameSpace pNamespace, Principal pPrincipal, Object pCredential, String pProtocol, SessionProperties pProperties) throws CIMException {
        String methodName = "init";
        this.iLogger = SessionProperties.getGlobalProperties().getLogger();
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, "init(CIMNameSpace, Principal, Object)", new Object[]{pNamespace, pPrincipal, pCredential});
        }
        try {
            this.iSessionProperties = pProperties != null ? pProperties : SessionProperties.getGlobalProperties();
            this.iHttpClientPool.setSessionProperties(pProperties);
            this.iXmlHelper = new CIMClientXML_HelperImpl();
            if (pNamespace == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null namespace argument");
            }
            this.iNamespace = (CIMNameSpace)pNamespace.clone();
            this.iUri = this.iNamespace.getHostURI();
            if (this.iUri == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", "Malformed URI is equal to NULL");
            }
            AuthInfo authInfo = AuthInfo.createAuthorizationInfo(this.iSessionProperties.getHttpAuthenticationModule(), Boolean.FALSE, this.iNamespace.getHost(), this.iNamespace.getPort(), null, null, null);
            String usePrincipal = "";
            char[] useCredential = new char[]{};
            if (pCredential != null && pCredential instanceof PasswordCredential && ((PasswordCredential)pCredential).getUserPassword() != null) {
                useCredential = ((PasswordCredential)pCredential).getUserPassword();
            }
            if (pPrincipal != null && pPrincipal.getName() != null) {
                usePrincipal = pPrincipal.getName();
            }
            boolean defaultAuthEnabled = this.iSessionProperties.isCredentialsDefaultEnabled();
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.log(Level.FINER, "Default authorization " + (defaultAuthEnabled ? "IS" : "NOT") + " enabled !");
            }
            if ((usePrincipal.equals("") || useCredential.equals(new char[0])) && defaultAuthEnabled) {
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "Principal and/or Credential not set - using default authorization!");
                }
                usePrincipal = this.iSessionProperties.getDefaultPrincipal();
                useCredential = this.iSessionProperties.getDefaultCredentials().toCharArray();
            }
            authInfo.setCredentials(new PasswordAuthentication(usePrincipal, useCredential));
            this.iAuthorizationHandler = new AuthorizationHandler();
            this.iAuthorizationHandler.addAuthorizationInfo(authInfo);
            this.iIndicationClient = new CIMIndicationListenertList();
            this.iXmlHelper = new CIMClientXML_HelperImpl();
        }
        catch (CIMException e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error occured during initilizing", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error occured during initilizing", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e);
        }
        finally {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
        }
    }

    protected void getCIMOMCapabilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale pLocale) {
        String methodName = "setLocale(Locale)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, pLocale);
        }
        try {
            if (pLocale == null) {
                CIMException e = new CIMException("CIM_ERR_INVALID_PARAMETER", "null Locale object");
                if (this.iLogger.isLoggable(Level.INFO)) {
                    this.iLogger.log(Level.INFO, "Invalid Locale object - null reference", e);
                }
                throw e;
            }
            this.iLocale = pLocale;
        }
        finally {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
        }
    }

    public Locale getLocale() {
        String methodName = "getLocale()";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, this.iLocale);
            this.iLogger.exiting(CLASSNAME, methodName, this.iLocale);
        }
        return this.iLocale;
    }

    public void useHttp11(boolean pValue) {
        String methodName = "useHttp11(boolean)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, pValue);
        }
        this.iUseHttp11 = pValue;
        if (!this.iUseHttp11) {
            this.iUseMPost = false;
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.log(Level.FINER, "Setting useHttp11:" + this.iUseHttp11);
            this.iLogger.log(Level.FINER, "Setting MPost:" + this.iUseMPost);
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, methodName);
        }
    }

    public void useMPost(boolean pValue) {
        String methodName = "useMPost(boolean)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, pValue);
        }
        this.iUseMPost = pValue;
        if (this.iUseMPost) {
            this.iUseHttp11 = true;
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.log(Level.FINER, "Setting useHttp11:" + this.iUseHttp11);
            this.iLogger.log(Level.FINER, "Setting MPost:" + this.iUseMPost);
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, methodName);
        }
    }

    public void preCheck(CIMObjectPath pPath) throws CIMException {
        if (pPath == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null object path");
        }
        String ns = pPath.getNameSpace();
        if (ns == null || ns.length() == 0) {
            pPath.setNameSpace(this.iNamespace.getNameSpace());
        }
    }

    public void preCheck(CIMNameSpace pNamespace) throws CIMException {
        if (pNamespace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null namespace");
        }
    }

    public CIMNameSpace getNameSpace() {
        return this.iNamespace;
    }

    public Enumeration associatorNames(CIMObjectPath pPath) throws CIMException {
        return this.associatorNames(pPath, null, null, null, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration associatorNames(CIMObjectPath pPath, String pAssociationClass, String pResultClass, String pRole, String pResultRole) throws CIMException {
        String methodName = "associatorNames(CIMObjectPath, String, String, String, String)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath, pAssociationClass, pResultClass, pRole, pResultRole});
        }
        this.preCheck(pPath);
        CIMEnumeration enumeration = null;
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.associatorNames_request(doc, pPath, pAssociationClass, pResultClass, pRole, pResultRole));
            InputStreamReader is = this.transmitRequest("AssociatorNames", hh, doc);
            enumeration = this.getEnumeration(is, pPath);
        }
        catch (CIMException e) {
            try {
                if (!this.iLogger.isLoggable(Level.INFO)) throw e;
                this.iLogger.log(Level.INFO, "Error while processing associatorNames request", e);
                throw e;
                catch (Exception e2) {
                    if (!this.iLogger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e2);
                    this.iLogger.log(Level.INFO, "Error while processing associatorNames request", e2);
                    throw new CIMException("CIM_ERR_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                if (!this.iLogger.isLoggable(Level.FINER)) throw throwable;
                this.iLogger.exiting(CLASSNAME, methodName, enumeration);
                throw throwable;
            }
        }
        if (!this.iLogger.isLoggable(Level.FINER)) return enumeration;
        this.iLogger.exiting(CLASSNAME, methodName, enumeration);
        return enumeration;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration associators(CIMObjectPath pPath, String pAssociationClass, String pResultClass, String pRole, String pResultRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException {
        String methodName = "associators(CIMObjectPath, String, String, String, String, boolean, boolean,  String[])";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath, pAssociationClass, pResultClass, pRole, pResultRole, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList});
        }
        this.preCheck(pPath);
        CIMEnumeration enumeration = null;
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.associators_request(doc, pPath, pAssociationClass, pResultClass, pRole, pResultRole, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("Associators", hh, doc);
            enumeration = this.getEnumeration(is, pPath);
        }
        catch (CIMException e) {
            try {
                if (!this.iLogger.isLoggable(Level.INFO)) throw e;
                this.iLogger.log(Level.INFO, "Error while processing associator request", e);
                throw e;
                catch (Exception e2) {
                    if (!this.iLogger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e2);
                    this.iLogger.log(Level.INFO, "Error while processing associator request", e2);
                    throw new CIMException("CIM_ERR_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                if (!this.iLogger.isLoggable(Level.FINER)) throw throwable;
                this.iLogger.exiting(CLASSNAME, methodName, enumeration);
                throw throwable;
            }
        }
        if (!this.iLogger.isLoggable(Level.FINER)) return enumeration;
        this.iLogger.exiting(CLASSNAME, methodName, enumeration);
        return enumeration;
    }

    public void deleteInstance(CIMObjectPath pPath) throws CIMException {
        String methodName = "deleteInstance(CIMObjectPath)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath});
        }
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.deleteInstance_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("DeleteInstance", hh, doc);
            CIMEnumeration result = this.getEnumeration(is, pPath);
            if (result != null) {
                result.close();
            }
        }
        catch (CIMException e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing deleteInstance request", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing deleteInstance request", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e);
        }
        finally {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
        }
    }

    public Enumeration enumerateInstanceNames(CIMObjectPath pPath) throws CIMException {
        String methodName = "enumerateInstanceNames(CIMObjectPath)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath});
        }
        this.preCheck(pPath);
        CIMEnumeration enumeration = null;
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateInstanceNames_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("EnumerateInstanceNames", hh, doc);
            enumeration = this.getEnumeration(is, pPath);
        }
        catch (CIMException e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing enumerateInstanceNames request", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing enumerateInstanceNames request", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e);
        }
        finally {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
        }
        return enumeration;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration enumerateInstances(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException {
        String methodName = "enumerateInstances(CIMObjectPath, boolean, boolean, boolean, boolean, String[])";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath, pDeep, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList});
        }
        this.preCheck(pPath);
        CIMEnumeration enumeration = null;
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateInstances_request(doc, pPath, pDeep, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("EnumerateInstances", hh, doc);
            enumeration = this.getEnumeration(is, pPath);
        }
        catch (CIMException e) {
            try {
                if (!this.iLogger.isLoggable(Level.INFO)) throw e;
                this.iLogger.log(Level.INFO, "Error while processing enumerateInstances request", e);
                throw e;
                catch (Exception e2) {
                    if (!this.iLogger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e2);
                    this.iLogger.log(Level.INFO, "Error while processing enumerateInstances request", e2);
                    throw new CIMException("CIM_ERR_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                if (!this.iLogger.isLoggable(Level.INFO)) throw throwable;
                this.iLogger.exiting(CLASSNAME, methodName, enumeration);
                throw throwable;
            }
        }
        if (!this.iLogger.isLoggable(Level.INFO)) return enumeration;
        this.iLogger.exiting(CLASSNAME, methodName, enumeration);
        return enumeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMInstance getInstance(CIMObjectPath pPath, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException {
        String methodName = "getInstance(CIMObjectPath, boolean, boolean, boolean, String[])";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList});
        }
        this.preCheck(pPath);
        CIMInstance inst = null;
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.getInstance_request(doc, pPath, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("GetInstance", hh, doc);
            CIMEnumeration enumeration = this.getEnumeration(is, pPath);
            try {
                if (enumeration.hasMoreElements()) {
                    inst = (CIMInstance)enumeration.nextElement();
                    inst.setObjectPath(pPath);
                }
            }
            finally {
                enumeration.close();
            }
        }
        catch (CIMException e) {
            try {
                if (!this.iLogger.isLoggable(Level.INFO)) throw e;
                this.iLogger.log(Level.INFO, "Error while processing getInstance request", e);
                throw e;
                catch (Exception e2) {
                    if (!this.iLogger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e2);
                    this.iLogger.log(Level.INFO, "Error while processing getInstance request", e2);
                    throw new CIMException("CIM_ERR_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                if (!this.iLogger.isLoggable(Level.FINER)) throw throwable;
                this.iLogger.exiting(CLASSNAME, methodName, inst);
                throw throwable;
            }
        }
        if (!this.iLogger.isLoggable(Level.FINER)) return inst;
        this.iLogger.exiting(CLASSNAME, methodName, inst);
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMClass getClass(CIMObjectPath pPath, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException {
        String methodName = "getClass(CIMObjectPath, boolean, boolean, boolean, String[])";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath, pLocalOnly, pIncludeQualifiers, pPropertyList});
        }
        this.preCheck(pPath);
        CIMClass cimClass = null;
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.getClass_request(doc, pPath, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("GetClass", hh, doc);
            CIMEnumeration enumeration = this.getEnumeration(is, pPath);
            try {
                if (enumeration.hasMoreElements()) {
                    cimClass = (CIMClass)enumeration.nextElement();
                }
            }
            finally {
                enumeration.close();
            }
        }
        catch (CIMException e) {
            try {
                if (!this.iLogger.isLoggable(Level.INFO)) throw e;
                this.iLogger.log(Level.INFO, "Error while processing getClass request", e);
                throw e;
                catch (Exception e2) {
                    if (!this.iLogger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e2);
                    this.iLogger.log(Level.INFO, "Error while processing getClass request", e2);
                    throw new CIMException("CIM_ERR_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                if (!this.iLogger.isLoggable(Level.FINER)) throw throwable;
                this.iLogger.exiting(CLASSNAME, methodName, cimClass);
                throw throwable;
            }
        }
        if (!this.iLogger.isLoggable(Level.FINER)) return cimClass;
        this.iLogger.exiting(CLASSNAME, methodName, cimClass);
        return cimClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath createInstance(CIMObjectPath pObjectName, CIMInstance pInstance) throws CIMException {
        String methodName = "createInstance(CIMObjectPath, CIMInstance)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pObjectName, pInstance});
        }
        this.preCheck(pObjectName);
        CIMObjectPath ref = null;
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.createInstance_request(doc, pObjectName, pInstance));
            InputStreamReader is = this.transmitRequest("CreateInstance", hh, doc);
            CIMEnumeration enumeration = this.getEnumeration(is, pObjectName);
            try {
                if (enumeration.hasMoreElements()) {
                    ref = (CIMObjectPath)enumeration.nextElement();
                }
            }
            finally {
                enumeration.close();
            }
        }
        catch (CIMException e) {
            try {
                if (!this.iLogger.isLoggable(Level.INFO)) throw e;
                this.iLogger.log(Level.INFO, "Error while processing createInstance request", e);
                throw e;
                catch (Exception e2) {
                    if (!this.iLogger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e2);
                    this.iLogger.log(Level.INFO, "Error while processing createInstance request", e2);
                    throw new CIMException("CIM_ERR_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                if (!this.iLogger.isLoggable(Level.FINER)) throw throwable;
                this.iLogger.exiting(CLASSNAME, methodName, ref);
                throw throwable;
            }
        }
        if (!this.iLogger.isLoggable(Level.FINER)) return ref;
        this.iLogger.exiting(CLASSNAME, methodName, ref);
        return ref;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMValue invokeMethod(CIMObjectPath pObjectName, String pMethodName, Vector pInputArguments, Vector pOutputArguments) throws CIMException {
        String mName = "invokeMethod(CIMObjectPath, String, Vector, Vector)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, mName, new Object[]{pObjectName, pMethodName, pInputArguments, pOutputArguments});
        }
        this.preCheck(pObjectName);
        CIMValue rtnValue = null;
        try {
            CIMResponse response;
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.toString(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.invokeMethod_request(doc, pObjectName, pMethodName, pInputArguments));
            InputStreamReader is = this.transmitRequest(pMethodName, hh, doc);
            if (this.getXmlParser() == 1 || this.getXmlParser() == 0) {
                XMLDefaultHandlerImpl hndlr = new XMLDefaultHandlerImpl(this.iSessionProperties.isDebugXMLInput());
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(new InputSource(is), (DefaultHandler)hndlr);
                Vector o = hndlr.getObjects();
                response = (CIMResponse)o.elementAt(0);
            } else {
                response = this.getSingleResponse(is);
            }
            response.checkError();
            Vector resultSet = response.getFirstReturnValue();
            if (resultSet.size() > 0 && resultSet.elementAt(0) instanceof CIMValue) {
                rtnValue = (CIMValue)resultSet.elementAt(0);
            }
            Vector outParamValues = response.getParamValues();
            if (pOutputArguments != null) {
                pOutputArguments.addAll(outParamValues);
            }
        }
        catch (CIMException e) {
            try {
                if (!this.iLogger.isLoggable(Level.INFO)) throw e;
                this.iLogger.log(Level.INFO, "Error while processing invokeMethod request", e);
                throw e;
                catch (Exception e2) {
                    if (!this.iLogger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e2);
                    this.iLogger.log(Level.INFO, "Error while processing invokeMethod request", e2);
                    throw new CIMException("CIM_ERR_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                if (!this.iLogger.isLoggable(Level.FINER)) throw throwable;
                this.iLogger.exiting(CLASSNAME, mName, rtnValue);
                throw throwable;
            }
        }
        if (!this.iLogger.isLoggable(Level.FINER)) return rtnValue;
        this.iLogger.exiting(CLASSNAME, mName, rtnValue);
        return rtnValue;
    }

    public void createClass(CIMObjectPath pPath, CIMClass pClass) throws CIMException {
        String methodName = "createClass(CIMObjectPath, CIMClass)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath, pClass});
        }
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.createClass_request(doc, pPath, pClass));
            InputStreamReader is = this.transmitRequest("CreateClass", hh, doc);
            CIMEnumeration result = this.getEnumeration(is, pPath);
            if (result != null) {
                result.close();
            }
        }
        catch (CIMException e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing createClass request", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing createClass request", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e);
        }
        finally {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
        }
    }

    public void createQualifierType(CIMObjectPath pPath, CIMQualifierType pQualifierType) throws CIMException {
        String methodName = "createQualifierType(CIMObjectPath, CIMQualifierType)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath, pQualifierType});
        }
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.createQualifierType_request(doc, pPath, pQualifierType));
            InputStreamReader is = this.transmitRequest("CreateQualifierType", hh, doc);
            CIMEnumeration result = this.getEnumeration(is, pPath);
            if (result != null) {
                result.close();
            }
        }
        catch (CIMException e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing createQualifierType request", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing createQualifierType request", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e);
        }
        finally {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
        }
    }

    public void deleteClass(CIMObjectPath pPath) throws CIMException {
        String methodName = "deleteClass(CIMObjectPath)";
        if (this.iLogger.isLoggable(Level.INFO)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath});
        }
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.deleteClass_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("DeleteClass", hh, doc);
            CIMEnumeration result = this.getEnumeration(is, pPath);
            if (result != null) {
                result.close();
            }
        }
        catch (CIMException e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing deleteClass request", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing deleteClass request", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e);
        }
        finally {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
        }
    }

    public void deleteQualifierType(CIMObjectPath pPath) throws CIMException {
        String methodName = "deleteQualifierType(CIMObjectPath)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath});
        }
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.deleteQualifierType_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("DeleteQualifierType", hh, doc);
            CIMEnumeration result = this.getEnumeration(is, pPath);
            if (result != null) {
                result.close();
            }
        }
        catch (CIMException e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing deleteQualifierType request", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.iLogger.isLoggable(Level.INFO)) {
                this.iLogger.log(Level.INFO, "Error while processing deleteQualifierType request", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e);
        }
        finally {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting(CLASSNAME, methodName);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration enumerateClasses(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin) throws CIMException {
        String methodName = "deleteQualifierType(CIMObjectPath, boolean, boolean, boolean, boolean)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pPath, pDeep, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin});
        }
        this.preCheck(pPath);
        CIMEnumeration enumeration = null;
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateClasses_request(doc, pPath, pDeep, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin));
            InputStreamReader is = this.transmitRequest("EnumerateClasses", hh, doc);
            enumeration = this.getEnumeration(is, pPath);
        }
        catch (CIMException e) {
            try {
                if (!this.iLogger.isLoggable(Level.INFO)) throw e;
                this.iLogger.log(Level.INFO, "Error while processing enumerateClasses request", e);
                throw e;
                catch (Exception e2) {
                    if (!this.iLogger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e2);
                    this.iLogger.log(Level.INFO, "Error while processing enumerateClasses request", e2);
                    throw new CIMException("CIM_ERR_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                if (!this.iLogger.isLoggable(Level.FINER)) throw throwable;
                this.iLogger.exiting(CLASSNAME, methodName, enumeration);
                throw throwable;
            }
        }
        if (!this.iLogger.isLoggable(Level.FINER)) return enumeration;
        this.iLogger.exiting(CLASSNAME, methodName, enumeration);
        return enumeration;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration enumerateClassNames(CIMObjectPath pObjectName, boolean pDeep) throws CIMException {
        String methodName = "enumerateClassNames(CIMObjectPath, boolean)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pObjectName, pDeep});
        }
        this.preCheck(pObjectName);
        CIMEnumeration enumeration = null;
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateClassNames_request(doc, pObjectName, pDeep));
            InputStreamReader is = this.transmitRequest("EnumerateClassNames", hh, doc);
            enumeration = this.getEnumeration(is, pObjectName);
        }
        catch (CIMException e) {
            try {
                if (!this.iLogger.isLoggable(Level.INFO)) throw e;
                this.iLogger.log(Level.INFO, "Error while processing enumerateClassNames request", e);
                throw e;
                catch (Exception e2) {
                    if (!this.iLogger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e2);
                    this.iLogger.log(Level.INFO, "Error while processing enumerateClassNames request", e2);
                    throw new CIMException("CIM_ERR_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                if (!this.iLogger.isLoggable(Level.FINER)) throw throwable;
                this.iLogger.exiting(CLASSNAME, methodName, enumeration);
                throw throwable;
            }
        }
        if (!this.iLogger.isLoggable(Level.FINER)) return enumeration;
        this.iLogger.exiting(CLASSNAME, methodName, enumeration);
        return enumeration;
    }

    public Enumeration execQuery(CIMObjectPath pPath) throws CIMException {
        return this.execQuery(pPath, null, "WQL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMValue getProperty(CIMObjectPath pPath, String pPropertyName) throws CIMException {
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.getInstance_request(doc, pPath, false, false, false, new String[]{pPropertyName}));
            InputStreamReader is = this.transmitRequest("GetInstance", hh, doc);
            CIMEnumeration enumeration = this.getEnumeration(is, pPath);
            try {
                if (!enumeration.hasMoreElements()) return null;
                CIMInstance inst = (CIMInstance)enumeration.nextElement();
                if (inst == null) return null;
                CIMProperty property = inst.getProperty(pPropertyName);
                if (property == null) return null;
                CIMValue cIMValue = property.getValue();
                return cIMValue;
            }
            finally {
                enumeration.close();
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public Enumeration referenceNames(CIMObjectPath pPath) throws CIMException {
        return this.referenceNames(pPath, null, null);
    }

    public Enumeration referenceNames(CIMObjectPath pPath, String pResultClass, String pRole) throws CIMException {
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.referenceNames_request(doc, pPath, pResultClass, pRole));
            InputStreamReader is = this.transmitRequest("ReferenceNames", hh, doc);
            return this.getEnumeration(is, pPath);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public Enumeration references(CIMObjectPath pPath) throws CIMException {
        return this.references(pPath, null, null, true, true, null);
    }

    public Enumeration references(CIMObjectPath pPath, String pResultClass, String pRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException {
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.references_request(doc, pPath, pResultClass, pRole, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("References", hh, doc);
            return this.getEnumeration(is, pPath);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void setClass(CIMObjectPath pPath, CIMClass pClass) throws CIMException {
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.setClass_request(doc, pPath, pClass));
            InputStreamReader is = this.transmitRequest("ModifyClass", hh, doc);
            CIMEnumeration result = this.getEnumeration(is, pPath);
            if (result != null) {
                result.close();
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void setInstance(CIMObjectPath pPath, CIMInstance pInstance, boolean pIncludeQualifiers, String[] pPropertyList) throws CIMException {
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.setInstance_request(doc, pPath, pInstance, pIncludeQualifiers, pPropertyList));
            InputStreamReader is = this.transmitRequest("ModifyInstance", hh, doc);
            CIMEnumeration result = this.getEnumeration(is, pPath);
            if (result != null) {
                result.close();
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void setProperty(CIMObjectPath pPath, String pPropertyName) throws CIMException {
        this.setProperty(pPath, pPropertyName, null);
    }

    public void setProperty(CIMObjectPath pPath, String pPropertyName, CIMValue pValue) throws CIMException {
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.setProperty_request(doc, pPath, pPropertyName, pValue));
            InputStreamReader is = this.transmitRequest("SetProperty", hh, doc);
            CIMEnumeration result = this.getEnumeration(is, pPath);
            if (result != null) {
                result.close();
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void setQualifierType(CIMObjectPath pPath, CIMQualifierType pQualifierType) throws CIMException {
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.setQualifierType_request(doc, pPath, pQualifierType));
            InputStreamReader is = this.transmitRequest("SetQualifierType", hh, doc);
            CIMEnumeration result = this.getEnumeration(is, pPath);
            if (result != null) {
                result.close();
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void close() throws CIMException {
        this.close(false);
    }

    public void close(boolean pKeepEnumerations) throws CIMException {
        if (this.iLogger.isLoggable(Level.WARNING)) {
            this.iLogger.log(Level.WARNING, "The CIM Client on: " + this.iUri + " has been closed!");
        }
        if (this.iConnection != null) {
            this.iConnection.close(pKeepEnumerations);
        }
        if (this.iIndicationServer != null) {
            this.iIndicationServer.close();
        }
    }

    public void createNameSpace(CIMNameSpace pNamespace) throws CIMException {
        this.preCheck(pNamespace);
        String namespace = pNamespace.getNameSpace();
        CIMInstance inst = new CIMInstance();
        inst.setClassName("CIM_NameSpace");
        CIMProperty prop = new CIMProperty("Name");
        prop.setValue(new CIMValue(namespace, CIMDataType.getPredefinedType(8)));
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        v.add(prop);
        inst.setProperties(v);
        CIMObjectPath op = new CIMObjectPath(null, "root");
        this.createInstance(op, inst);
    }

    public void deleteNameSpace(CIMNameSpace pNamespace) throws CIMException {
        this.preCheck(pNamespace);
        CIMObjectPath op = new CIMObjectPath();
        op.setNameSpace(pNamespace);
        this.deleteInstance(op);
    }

    public Enumeration enumNameSpace(CIMObjectPath pPath, boolean pDeep) throws CIMException {
        this.preCheck(pPath);
        pPath.setObjectName("CIM_NameSpace");
        return this.enumerateInstanceNames(pPath);
    }

    public Enumeration execQuery(CIMObjectPath pPath, String pQuery, String pQueryLanguage) throws CIMException {
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.execQuery_request(doc, pPath, pQuery, pQueryLanguage));
            InputStreamReader is = this.transmitRequest("ExecQuery", hh, doc);
            return this.getEnumeration(is, pPath);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public CIMQualifierType getQualifierType(CIMObjectPath pPath) throws CIMException {
        return this.getQualifierType(pPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMQualifierType getQualifierType(CIMObjectPath pPath, String pQualifierType) throws CIMException {
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.getQualifier_request(doc, pPath, pQualifierType));
            InputStreamReader is = this.transmitRequest("GetQualifier", hh, doc);
            CIMEnumeration enumeration = this.getEnumeration(is, pPath);
            try {
                if (!enumeration.hasMoreElements()) return null;
                CIMQualifierType cIMQualifierType = (CIMQualifierType)enumeration.nextElement();
                return cIMQualifierType;
            }
            finally {
                enumeration.close();
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public Enumeration enumQualifierTypes(CIMObjectPath pPath) throws CIMException {
        this.preCheck(pPath);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumQualifierTypes_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("EnumerateQualifiers", hh, doc);
            return this.getEnumeration(is, pPath);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public BatchResult performBatchOperations(BatchHandle pBatchHandle) throws CIMException {
        Vector operations = pBatchHandle.getOperations();
        BatchResult result = null;
        if (operations.size() < 2) {
            throw new CIMException("CIM_ERR_FAILED", "Invalid number of batch operations (" + operations.size() + ")");
        }
        Iterator iter = operations.iterator();
        while (iter.hasNext()) {
            CIMOperation op = (CIMOperation)iter.next();
            if (op instanceof CIMCreateNameSpaceOp || op instanceof CIMDeleteNameSpaceOp) {
                this.preCheck(op.getNameSpace());
                continue;
            }
            this.preCheck(op.getObjectName());
        }
        HttpHeader hh = new HttpHeader();
        hh.addField("CIMBatch", "CIMBatch");
        Document doc = this.iXmlHelper.newDocument();
        try {
            CIMResponse response;
            this.iXmlHelper.performBatchOperation_request(doc, operations);
            InputStreamReader is = this.transmitRequest(null, hh, doc);
            if (this.getXmlParser() == 1 || this.getXmlParser() == 0) {
                XMLDefaultHandlerImpl hndlr = new XMLDefaultHandlerImpl(this.iSessionProperties.isDebugXMLInput());
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(new InputSource(is), (DefaultHandler)hndlr);
                Vector o = hndlr.getObjects();
                response = (CIMResponse)o.elementAt(0);
            } else {
                response = this.getMultiResponse(is);
            }
            Vector allResponses = response.getAllResponses();
            if (allResponses.size() != operations.size()) {
                throw new CIMException("CIM_ERR_FAILED", "Batch operation result set size does not the size of the request");
            }
            iter = allResponses.iterator();
            for (int i = 0; i < allResponses.size(); ++i) {
                CIMResponse resp = (CIMResponse)allResponses.elementAt(i);
                CIMOperation op = (CIMOperation)operations.elementAt(i);
                if (resp.isSuccessul()) {
                    if (op instanceof CIMGetClassOp || op instanceof CIMGetInstanceOp || op instanceof CIMGetPropertyOp || op instanceof CIMGetQualifierTypeOp) {
                        Vector v = resp.getFirstReturnValue();
                        if (v.size() > 0) {
                            if (op instanceof CIMGetPropertyOp) {
                                CIMInstance inst = (CIMInstance)v.elementAt(0);
                                CIMProperty property = inst.getProperty(((CIMGetPropertyOp)op).getPropertyName());
                                if (property == null) continue;
                                op.setResult(property.getValue());
                                continue;
                            }
                            if (op instanceof CIMGetClassOp || op instanceof CIMGetInstanceOp) {
                                op.setResult(CIMClientXML.fixResultSet(op.getObjectName(), v, this.iNamespace));
                                continue;
                            }
                            op.setResult(v.elementAt(0));
                            continue;
                        }
                        op.setResult(null);
                        continue;
                    }
                    if (op instanceof CIMAssociatorNamesOp || op instanceof CIMAssociatorsOp || op instanceof CIMEnumClassesOp || op instanceof CIMEnumClassNamesOp || op instanceof CIMEnumInstanceNamesOp || op instanceof CIMEnumInstancesOp || op instanceof CIMEnumNameSpaceOp || op instanceof CIMEnumQualifierTypesOp || op instanceof CIMReferenceNamesOp || op instanceof CIMReferencesOp || op instanceof CIMExecQueryOp) {
                        op.setResult(CIMClientXML.fixResultSet(op.getObjectName(), resp.getFirstReturnValue(), this.iNamespace).elements());
                        continue;
                    }
                    if (!(op instanceof CIMInvokeMethodOp)) continue;
                    Vector outParamValues = resp.getParamValues();
                    Vector outArgs = ((CIMInvokeMethodOp)op).getOutParams();
                    if (outArgs == null) continue;
                    outArgs.addAll(outParamValues);
                    continue;
                }
                op.setResult(resp.getException());
            }
            result = new BatchResult(operations.toArray(new CIMOperation[operations.size()]));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean initializeIndicationServer() {
        if (this.iIndicationServer != null) return true;
        CIMClientXML cIMClientXML = this;
        synchronized (cIMClientXML) {
            if (this.iIndicationServer != null) return true;
            CIMEventDispatcher dispatcher = new CIMEventDispatcher(this.iIndicationClient);
            CIMIndicationHandler indicationHdlr = new CIMIndicationHandler(dispatcher, this.iSessionProperties);
            try {
                this.iIndicationServer = new HttpServerConnection(new HttpConnectionHandler(indicationHdlr), 0, false, this.iSessionProperties);
                this.iIndicationServer.setName("CIMListener - Http Server");
                this.iIndicationServer.start();
                return true;
            }
            catch (Exception e) {
                dispatcher.kill();
                if (!this.iLogger.isLoggable(Level.WARNING)) return false;
                this.iLogger.log(Level.WARNING, "could not initialize CIM Indication Listener", e);
            }
            return false;
        }
    }

    public void addCIMListener(CIMListener pListener) throws CIMException {
        if (!this.initializeIndicationServer()) {
            throw new CIMException("CIM_ERR_FAILED", "Could not initialize indication listener");
        }
        this.iIndicationClient.addListener(pListener);
    }

    public void addCIMListener(CIMListener pListener, String pId) throws CIMException {
        if (pListener == null) {
            throw new IllegalArgumentException("null CIMListener argument");
        }
        if (!this.initializeIndicationServer()) {
            throw new CIMException("CIM_ERR_FAILED", "Could not initialize indication listener");
        }
        this.iIndicationClient.addListener(pListener);
    }

    public void removeCIMListener(CIMListener pListener) throws CIMException {
        this.iIndicationClient.removeListener(pListener);
    }

    public CIMInstance getIndicationListener(CIMListener pListener) throws CIMException {
        if (pListener == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null listener argument");
        }
        if (!this.initializeIndicationServer()) {
            throw new CIMException("CIM_ERR_FAILED", "Could not initialize indication listener");
        }
        try {
            String host = this.iIndicationServer.getHostIP();
            int port = this.iIndicationServer.getPort();
            CIMClass clazz = this.getClass(new CIMObjectPath("CIM_ListenerDestinationCIMXML"), false, false, false, null);
            CIMInstance inst = clazz.newInstance();
            inst.setProperty("CreationClassName", new CIMValue("CIM_IndicationHandlerCIMXML", CIMDataType.getPredefinedType(8)));
            inst.setProperty("SystemCreationClassName", new CIMValue("CIM_ComputerSystem", CIMDataType.getPredefinedType(8)));
            inst.setProperty("Name", new CIMValue(this.getUniqueID(host, port), CIMDataType.getPredefinedType(8)));
            inst.setProperty("SystemName", new CIMValue(host, CIMDataType.getPredefinedType(8)));
            String id = String.valueOf(pListener.hashCode());
            inst.setProperty("Destination", new CIMValue("http://" + host + ":" + port + "/" + id, CIMDataType.getPredefinedType(8)));
            return inst;
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public CIMInstance getIndicationHandler(CIMListener pListener) throws CIMException {
        if (pListener == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null listener argument");
        }
        if (!this.initializeIndicationServer()) {
            throw new CIMException("CIM_ERR_FAILED", "Could not initialize indication server");
        }
        try {
            String host = this.iIndicationServer.getHostIP();
            int port = this.iIndicationServer.getPort();
            String id = String.valueOf(pListener.hashCode());
            CIMClass clazz = this.getClass(new CIMObjectPath("CIM_IndicationHandler"), false, false, false, null);
            CIMInstance inst = clazz.newInstance();
            inst.setProperty("CreationClassName", new CIMValue("CIM_IndicationHandler", CIMDataType.getPredefinedType(8)));
            inst.setProperty("SystemCreationClassName", new CIMValue("CIM_ComputerSystem", CIMDataType.getPredefinedType(8)));
            inst.setProperty("Name", new CIMValue(this.getUniqueID(host, port), CIMDataType.getPredefinedType(8)));
            inst.setProperty("SystemName", new CIMValue(host, CIMDataType.getPredefinedType(8)));
            inst.setProperty("Destination", new CIMValue("http://" + host + ":" + port + "/" + id, CIMDataType.getPredefinedType(8)));
            return inst;
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueID(String pHost, int pPort) {
        int cntr;
        Object object = this.iLock;
        synchronized (object) {
            cntr = this.iCounter++;
        }
        String uniqueId = pHost + ":" + pPort + ":" + System.currentTimeMillis() + ":" + cntr++;
        return uniqueId;
    }

    public HttpUrlConnection newConnection(String pCimMethod, HttpHeader pHeader) {
        String methodName = "newConnection(String, HttpHeader)";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pCimMethod, pHeader});
        }
        this.iConnection = new HttpUrlConnection(this.iUri, this.iHttpClientPool, this.iAuthorizationHandler);
        if (this.iMPostFailed) {
            this.iCurrentTime = System.currentTimeMillis();
            if (this.iCurrentTime - this.iMPostFailTime > 86400000L) {
                this.iMPostFailed = false;
            }
        }
        if (this.iUseMPost && !this.iMPostFailed) {
            this.iConnection.setRequestMethod("M-POST");
        } else {
            this.iConnection.setRequestMethod("POST");
        }
        this.iConnection.useHttp11(this.iUseHttp11);
        String localeStr = this.iLocale.getLanguage();
        if (this.iLocale.getCountry().length() > 0) {
            localeStr = localeStr + '-' + this.iLocale.getCountry();
        }
        this.iConnection.setDoOutput(true);
        this.iConnection.setDoInput(true);
        this.iConnection.setRequestProperty("Content-type", "application/xml; charset=\"utf-8\"");
        this.iConnection.setRequestProperty("Accept", "text/html, text/xml, application/xml");
        this.iConnection.setRequestProperty("Cache-Control", "no-cache");
        this.iConnection.setRequestProperty("Content-Language", localeStr);
        this.iConnection.setRequestProperty("Accept-Language", localeStr + ", *");
        if (this.iAuthorization != null) {
            this.iConnection.setRequestProperty("Authorization", this.iAuthorization);
        }
        String prefix = "";
        if (this.iConnection.getRequestMethod().equalsIgnoreCase("M-POST")) {
            ++this.iNsCounter;
            if (this.iNsCounter > 99) {
                this.iNsCounter = 0;
            }
            String ns = (this.iNsCounter < 10 ? "0" : "") + this.iNsCounter;
            this.iConnection.setRequestProperty("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + ns);
            prefix = ns + "-";
        }
        this.iConnection.setRequestProperty(prefix + "CIMProtocolVersion", "1.0");
        this.iConnection.setRequestProperty(prefix + "CIMOperation", "MethodCall");
        try {
            this.iConnection.setRequestProperty(prefix + "CIMMethod", HttpHeader.encode(pCimMethod, "UTF-8", "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            if (this.iLogger.isLoggable(Level.WARNING)) {
                this.iLogger.log(Level.WARNING, "Unable to encode HTTP Header", e);
            }
            this.iConnection.setRequestProperty(prefix + "CIMMethod", pCimMethod);
        }
        Iterator iter = pHeader.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.iConnection.setRequestProperty(prefix + entry.getKey().toString(), entry.getValue().toString());
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.log(Level.FINER, "headers = " + pHeader);
            this.iLogger.exiting(CLASSNAME, methodName, this.iConnection);
        }
        return this.iConnection;
    }

    private CIMEnumeration getEnumeration(InputStreamReader pStream, CIMObjectPath pPath) throws Exception {
        try {
            CIMEnumerationImpl enumeration = this.getXmlParser() == 1 || this.getXmlParser() == 0 ? new CIMEnumerationImpl(new XMLDefaultHandlerImpl(this.iSessionProperties.isDebugXMLInput()), pPath, this.iNamespace, pStream, this.iConnection.getHttpClient(), this.getXmlParser() == 1) : new CIMEnumerationImpl(this.getSingleResponse(pStream).getFirstReturnValue().elements(), pPath, this.iNamespace);
            return enumeration;
        }
        catch (Exception e) {
            this.iConnection.disconnect();
            throw e;
        }
    }

    public CIMResponse getMultiResponse(InputStreamReader pStream) throws IOException, SAXException {
        Document doc = this.iXmlHelper.parse(new InputSource(pStream));
        if (this.iSessionProperties.isDebugXMLInput()) {
            CIMClientXML_HelperImpl.dumpDocument(doc);
        }
        pStream.close();
        Element rootE = doc.getDocumentElement();
        CIMResponse response = (CIMResponse)CIMXMLParserImpl.parseCIM(rootE);
        return response;
    }

    public CIMResponse getDocument(InputStreamReader pStream) throws IOException, SAXException {
        Document doc = this.iXmlHelper.parse(new InputSource(pStream));
        if (this.iSessionProperties.isDebugXMLInput()) {
            CIMClientXML_HelperImpl.dumpDocument(doc);
        }
        pStream.close();
        Element rootE = doc.getDocumentElement();
        CIMResponse response = (CIMResponse)CIMXMLParserImpl.parseCIM(rootE);
        response.checkError();
        return response;
    }

    private CIMResponse getSingleResponse(InputStreamReader pStream) throws IOException, SAXException {
        XMLDefaultHandlerImpl handler = new XMLDefaultHandlerImpl(this.iSessionProperties.isDebugXMLInput());
        handler.parse(new XMLPullParser(pStream));
        Vector v = handler.getObjects();
        if (v.size() > 0) {
            CIMResponse response = (CIMResponse)v.elementAt(0);
            response.checkError();
            return response;
        }
        throw new IllegalStateException("XML parsing produces no CIM response");
    }

    public InputStreamReader transmitRequest(String pCimMethod, HttpHeader pHeader, Document pDocument) throws CIMException, IOException, ProtocolException, SAXException {
        String methodName = "transmitRequest(String, HttpHeader, Document )";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName, new Object[]{pCimMethod, pHeader});
        }
        Benchmark.startTransportTimer();
        int retries = this.iSessionProperties.getRetriesNumber();
        while (retries-- >= 0) {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.log(Level.FINER, "Attempting to connect.. num of attempts left:" + retries);
            }
            if (this.iConnection != null) {
                this.iConnection.disconnect();
            }
            this.iConnection = this.newConnection(pCimMethod, pHeader);
            try {
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "connecting...");
                }
                this.iConnection.connect();
            }
            catch (UnknownHostException uhe) {
                throw new CIMTransportException("EXT_ERR_UNKNOWN_SERVER", uhe);
            }
            catch (SocketException e) {
                this.iConnection.disconnect();
                throw new CIMTransportException("EXT_ERR_UNABLE_TO_CONNECT", e);
            }
            OutputStream os = this.iConnection.getOutputStream();
            if (this.iSessionProperties.isDebugXMLOutput()) {
                CIMClientXML_HelperImpl.dumpDocument(pDocument);
            }
            CIMClientXML_HelperImpl.serialize(os, pDocument);
            os.flush();
            os.close();
            int resultCode = 200;
            try {
                resultCode = this.iConnection.getResponseCode();
            }
            catch (SocketException e) {
                this.iConnection.disconnect();
                throw new CIMException("EXT_ERR_UNABLE_TO_CONNECT", e);
            }
            catch (SocketTimeoutException e) {
                this.iConnection.disconnect();
                throw new CIMException("EXT_ERR_TIME_OUT", e);
            }
            catch (Throwable e) {
                this.iConnection.disconnect();
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            HttpHeader headers = this.parseHeaders(this.iConnection);
            String auth = this.iConnection.getRequestProperty("Authorization");
            if (auth != null) {
                this.iAuthorization = auth;
            }
            String cimError = headers.getField("CIMError");
            if (resultCode == 200) {
                int lengthToCheck;
                int contentLength;
                String contentLengthField;
                if (this.iSessionProperties.isContentLengthRetryEnabled() && (contentLengthField = headers.getField("Content-length")) != null && contentLengthField.trim().length() > 0 && (contentLength = Integer.parseInt(contentLengthField)) < (lengthToCheck = this.iSessionProperties.getContentLength())) {
                    if (!this.iLogger.isLoggable(Level.WARNING)) continue;
                    this.iLogger.log(Level.WARNING, "Content Length below :" + lengthToCheck + " ...retrying !");
                    continue;
                }
                String charset = this.getCharacterSet(headers);
                InputStream is = this.iSessionProperties.isDebugInputStream() ? new DebugInputStream(this.iConnection.getInputStream(), this.iSessionProperties.getDebugOutputStream()) : this.iConnection.getInputStream();
                Benchmark.stopTransportTimer();
                return new InputStreamReader(is, charset);
            }
            if (resultCode == 500) {
                if (!this.iLogger.isLoggable(Level.FINER)) continue;
                this.iLogger.log(Level.FINER, "Received HTTP Error 500 - HTTP_INTERNAL_ERROR - retying !");
                continue;
            }
            if (resultCode == 501) {
                String cimProtocolVersion = headers.getField("CIMProtocolVersion");
                if (cimProtocolVersion == null && cimError == null && this.iUseMPost) {
                    if (this.iLogger.isLoggable(Level.FINER)) {
                        this.iLogger.log(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - retying with HTTP POST !");
                    }
                    this.iMPostFailTime = System.currentTimeMillis();
                    this.iMPostFailed = true;
                    continue;
                }
                if (cimProtocolVersion == null || cimProtocolVersion.length() == 0) {
                    cimProtocolVersion = "1.0";
                }
                if ("unsupported-protocol-version".equalsIgnoreCase(cimError)) {
                    if (!this.iLogger.isLoggable(Level.FINER)) break;
                    this.iLogger.log(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - unsupported-protocol-version !");
                    break;
                }
                if ("multiple-request-unsupported".equalsIgnoreCase(cimError)) {
                    if (!this.iLogger.isLoggable(Level.FINER)) break;
                    this.iLogger.log(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - multiple-request-unsupported !");
                    break;
                }
                if ("unsupported-cim-version".equalsIgnoreCase(cimError)) {
                    if (!this.iLogger.isLoggable(Level.FINER)) break;
                    this.iLogger.log(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - unsupported-cim-version !");
                    break;
                }
                if (!"unsupported-dtd-version".equalsIgnoreCase(cimError)) continue;
                if (!this.iLogger.isLoggable(Level.FINER)) break;
                this.iLogger.log(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - unsupported-dtd-version !");
                break;
            }
            if (resultCode == 400) {
                if (!"request-not-valid".equalsIgnoreCase(cimError)) {
                    if ("request-not-well-formed".equalsIgnoreCase(cimError)) {
                        if (!this.iLogger.isLoggable(Level.FINER)) break;
                        this.iLogger.log(Level.FINER, "Received HTTP Error 400 - BAD REQUEST - request-not-well-formed !");
                        break;
                    }
                    if ("request-not-loosely-valid".equalsIgnoreCase(cimError)) {
                        if (!this.iLogger.isLoggable(Level.FINER)) break;
                        this.iLogger.log(Level.FINER, "Received HTTP Error 400 - BAD REQUEST - request-not-loosely-valid !");
                        break;
                    }
                }
                if (!this.iLogger.isLoggable(Level.FINER)) break;
                this.iLogger.log(Level.FINER, "Received HTTP Error 400 - BAD REQUEST - cimError not specified!");
                break;
            }
            if (resultCode == 401) {
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "Received HTTP Error 401 - UNAUTHORIZED. Throwing CIMAuthenticationException!");
                }
                this.iConnection.disconnect();
                throw new CIMAuthenticationException("EXT_ERR_AUTHENTICATION");
            }
            if (resultCode == 403) {
                if (!this.iLogger.isLoggable(Level.FINER)) break;
                this.iLogger.log(Level.FINER, "Received HTTP Error 403 - FORBIDDEN.");
                break;
            }
            if (resultCode == 407) {
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "Received HTTP Error 407 - ERR PROXY AUTHENTICATION. Throwing CIMAuthenticationException!");
                }
                this.iConnection.disconnect();
                throw new CIMAuthenticationException("EXT_ERR_PROXY_AUTHENTICATION");
            }
            if (resultCode == 405) {
                if (!this.iLogger.isLoggable(Level.FINER)) break;
                this.iLogger.log(Level.FINER, "Received HTTP Error 405 - BAD METHOD.");
                break;
            }
            if (resultCode == 510) {
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "Received HTTP Error 510 on M-POST. Retrying with POST.");
                }
                this.iMPostFailTime = System.currentTimeMillis();
                this.iMPostFailed = true;
                continue;
            }
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.log(Level.FINER, "No known HTTP error recognized. Retrying with POST.");
            }
            this.iMPostFailTime = System.currentTimeMillis();
            this.iMPostFailed = true;
        }
        Benchmark.stopTransportTimer();
        Object[] errorMsg = new String[]{"\"HTTP " + this.iConnection.getResponseCode() + " " + this.iConnection.getResponseMessage() + "\"", "CIMError:\"" + this.iConnection.getHeaderField("CIMError") + "\""};
        this.iConnection.disconnect();
        throw new CIMTransportException("EXT_ERR_UNABLE_TO_CONNECT", errorMsg);
    }

    protected String getCharacterSet(HttpHeader pHeader) {
        String contentType = pHeader.getField("Content-type");
        String charset = "UTF-8";
        if (contentType != null && contentType.length() > 0) {
            HttpHeaderParser contentTypeHeader = new HttpHeaderParser(contentType);
            charset = contentTypeHeader.findValue("charset", charset);
        }
        return charset;
    }

    protected HttpHeader parseHeaders(URLConnection pConnection) {
        String man = pConnection.getHeaderField("Man");
        String opt = pConnection.getHeaderField("Opt");
        HttpHeader headers = new HttpHeader();
        String ns = null;
        HttpHeaderParser manOptHeader = null;
        if (man != null && man.length() > 0) {
            manOptHeader = new HttpHeaderParser(man);
        } else if (opt != null && opt.length() > 0) {
            manOptHeader = new HttpHeaderParser(opt);
        }
        if (manOptHeader != null) {
            ns = manOptHeader.findValue("ns");
        }
        if (ns != null) {
            String key;
            int i = 0;
            while ((key = pConnection.getHeaderFieldKey(++i)) != null) {
                if (key.startsWith(ns + "-")) {
                    headers.addField(key.substring(3), pConnection.getHeaderField(i));
                    continue;
                }
                headers.addField(key, pConnection.getHeaderField(i));
            }
        } else {
            String key;
            int i = 1;
            while ((key = pConnection.getHeaderFieldKey(i)) != null) {
                headers.addField(key, pConnection.getHeaderField(i));
                ++i;
            }
        }
        return headers;
    }

    protected static Vector fixResultSet(CIMObjectPath pRequest, Vector pVector, CIMNameSpace pNameSpace) {
        if (pVector != null && pRequest.getNameSpace() != null && pNameSpace.getNameSpace() != null) {
            Iterator iter = pVector.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                CIMClientXML.fixResult(pRequest, o, pNameSpace);
            }
        }
        return pVector;
    }

    protected static Object fixResult(CIMObjectPath pRequest, Object pObject, CIMNameSpace pNameSpace) {
        if (pObject != null) {
            String opNs;
            String ns = pRequest.getNameSpace();
            if (ns == null) {
                ns = pNameSpace.getNameSpace();
            }
            CIMObjectPath def = new CIMObjectPath();
            def.setNameSpace(ns);
            CIMObjectPath op = null;
            if (pObject instanceof CIMObjectPath) {
                op = (CIMObjectPath)pObject;
            } else if (pObject instanceof CIMInstance) {
                op = ((CIMInstance)pObject).getObjectPath();
            } else if (pObject instanceof CIMClass) {
                op = ((CIMClass)pObject).getObjectPath();
            }
            if (op != null && ((opNs = op.getNameSpace()) == null || opNs.length() == 0)) {
                op.setNameSpace(def.getNameSpace());
            }
        }
        return pObject;
    }

    private int getXmlParser() {
        return this.iSessionProperties.getXmlParser();
    }

    public SessionProperties getSessionProperties() {
        return this.iSessionProperties.isGlobal() ? this.iSessionProperties : null;
    }

    public void setSessionProperties(SessionProperties pProperties) {
        this.iSessionProperties = pProperties != null ? pProperties : SessionProperties.getGlobalProperties();
        this.iHttpClientPool.setSessionProperties(pProperties);
    }
}

